/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.servicetags;

import com.sun.scn.servicetags.util.XMLUtil;
import com.sun.servicetag.SystemEnvironment;
import java.util.Formatter;
import org.w3c.dom.Element;

public class EnvironmentInformation {
    private String hostname;
    private String hostId;
    private String osName;
    private String osVersion;
    private String osArchitecture;
    private String systemModel;
    private String systemManufacturer;
    private String cpuManufacturer;
    private String serialNumber;

    public EnvironmentInformation() {
        this.init(true, null, null, null, null, null, null, null, null, null);
    }

    public EnvironmentInformation(SystemEnvironment se) {
        this.init(false, se.getHostname(), se.getHostId(), se.getOsName(), se.getOsVersion(), se.getOsArchitecture(), se.getSystemModel(), se.getSystemManufacturer(), se.getCpuManufacturer(), se.getSerialNumber());
    }

    public EnvironmentInformation(boolean collectEnvData) {
        this.init(collectEnvData, null, null, null, null, null, null, null, null, null);
    }

    public EnvironmentInformation(Element e) {
        this.init(false, XMLUtil.getOptionalTextValue(e, "hostname"), XMLUtil.getOptionalTextValue(e, "hostId"), XMLUtil.getOptionalTextValue(e, "osName"), XMLUtil.getOptionalTextValue(e, "osVersion"), XMLUtil.getOptionalTextValue(e, "osArchitecture"), XMLUtil.getOptionalTextValue(e, "systemModel"), XMLUtil.getOptionalTextValue(e, "systemManufacturer"), XMLUtil.getOptionalTextValue(e, "cpuManufacturer"), XMLUtil.getOptionalTextValue(e, "serialNumber"));
    }

    public EnvironmentInformation(String hostname, String hostId, String osName, String osVersion, String osArchitecture, String systemModel, String systemManufacturer, String cpuManufacturer, String serialNumber) {
        this.init(true, hostname, hostId, osName, osVersion, osArchitecture, systemModel, systemManufacturer, cpuManufacturer, serialNumber);
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public void setOsArchitecture(String osArchitecture) {
        this.osArchitecture = osArchitecture;
    }

    public void setSystemModel(String systemModel) {
        this.systemModel = systemModel;
    }

    public void setSystemManufacturer(String systemManufacturer) {
        this.systemManufacturer = systemManufacturer;
    }

    public void setCpuManufacturer(String cpuManufacturer) {
        this.cpuManufacturer = cpuManufacturer;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setHostId(String hostId) {
        if (hostId == null || hostId.equals("null")) {
            hostId = "";
        }
        if ((hostId = hostId.trim()).length() > 16) {
            hostId = hostId.substring(0, 16);
        }
        this.hostId = hostId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    public String getSystemModel() {
        return this.systemModel;
    }

    public String getSystemManufacturer() {
        return this.systemManufacturer;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getCpuManufacturer() {
        return this.cpuManufacturer;
    }

    public String toXMLString() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("<environment>\n", new Object[0]);
        fmt.format("<hostname>%s</hostname>\n", this.hostname);
        fmt.format("<hostId>%s<hostId/>\n", this.hostId);
        fmt.format("<osName>%s</osName>\n", this.osName);
        fmt.format("<osVersion>%s</osVersion>\n", this.osVersion);
        fmt.format("<osArchitecture>%s<osArchitecture/>\n", this.osArchitecture);
        fmt.format("<systemModel>%s<systemModel/>\n", this.systemModel);
        fmt.format("<systemManufacturer>%s<systemManufacturer/>\n", this.systemManufacturer);
        fmt.format("<cpuManufacturer>%s<cpuManufacturer/>\n", this.cpuManufacturer);
        fmt.format("<serialNumber>%s<serialNumber/>\n", this.serialNumber);
        fmt.format("</environment>\n", new Object[0]);
        return sb.toString();
    }

    private void init(boolean captureFromLocal, String hostname, String hostId, String osName, String osVersion, String osArchitecture, String systemModel, String systemManufacturer, String cpuManufacturer, String serialNumber) {
        this.hostname = hostname != null ? hostname.trim() : hostname;
        this.setHostId(hostId);
        this.osName = osName != null ? osName.trim() : osName;
        this.osVersion = osVersion != null ? osVersion.trim() : osVersion;
        this.osArchitecture = osArchitecture != null ? osArchitecture.trim() : osArchitecture;
        this.systemModel = systemModel != null ? systemModel.trim() : systemModel;
        this.systemManufacturer = systemManufacturer != null ? systemManufacturer.trim() : systemManufacturer;
        this.cpuManufacturer = cpuManufacturer != null ? cpuManufacturer.trim() : cpuManufacturer;
        this.serialNumber = serialNumber != null ? serialNumber.trim() : serialNumber;
        if (!captureFromLocal) {
            return;
        }
        if (hostname == null || hostname.equals("") || hostId == null || hostId.equals("") || osName == null || osName.equals("") || osVersion == null || osVersion.equals("") || osArchitecture == null || osArchitecture.equals("") || systemModel == null || systemModel.equals("") || systemManufacturer == null || systemManufacturer.equals("") || cpuManufacturer == null || cpuManufacturer.equals("") || serialNumber == null || serialNumber.equals("")) {
            SystemEnvironment se = SystemEnvironment.getSystemEnvironment();
            if (hostname == null || hostname.equals("")) {
                this.hostname = se.getHostname();
            }
            if (hostId == null || hostId.equals("")) {
                this.setHostId(se.getHostId());
            }
            if (osName == null || osName.equals("")) {
                this.osName = se.getOsName();
            }
            if (osVersion == null || osVersion.equals("")) {
                this.osVersion = se.getOsVersion();
            }
            if (osArchitecture == null || osArchitecture.equals("")) {
                this.osArchitecture = se.getOsArchitecture();
            }
            if (systemModel == null || systemModel.equals("")) {
                this.systemModel = se.getSystemModel();
            }
            if (systemManufacturer == null || systemManufacturer.equals("")) {
                this.systemManufacturer = se.getSystemManufacturer();
            }
            if (cpuManufacturer == null || cpuManufacturer.equals("")) {
                this.cpuManufacturer = se.getCpuManufacturer();
            }
            if (serialNumber == null || serialNumber.equals("")) {
                this.serialNumber = se.getSerialNumber();
            }
        }
    }
}

