/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContexts;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnits;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jpa")
@Scoped(value=Singleton.class)
public class JPASniffer
extends GenericSniffer
implements Sniffer {
    private static final String[] containers = new String[]{"org.glassfish.persistence.jpa.JPAContainer"};
    private static final Class[] handledAnnotations = new Class[]{PersistenceContext.class, PersistenceContexts.class, PersistenceUnit.class, PersistenceUnits.class};
    private static char SEPERATOR_CHAR = (char)47;
    private static final String WEB_INF = "WEB-INF";
    private static final String WEB_INF_LIb = "WEB-INF" + SEPERATOR_CHAR + "lib";
    private static final String WEB_INF_CLASSSES = "WEB-INF" + SEPERATOR_CHAR + "classes";
    private static final String META_INF_PERSISTENCE_XML = "META-INF" + SEPERATOR_CHAR + "persistence.xml";
    private static final String WEB_INF_CLASSSES_META_INF_PERSISTENCE_XML = WEB_INF_CLASSSES + SEPERATOR_CHAR + META_INF_PERSISTENCE_XML;
    private static final String JAR_SUFFIX = ".jar";

    public JPASniffer() {
        super("jpa", null, null);
    }

    public boolean handles(ReadableArchive location, ClassLoader loader) {
        boolean isJPAArchive = false;
        isJPAArchive = this.isEntryPresent(location, WEB_INF_CLASSSES_META_INF_PERSISTENCE_XML);
        if (!isJPAArchive && this.isEntryPresent(location, WEB_INF_LIb)) {
            Enumeration entries = location.entries(WEB_INF_LIb);
            while (entries.hasMoreElements() && !isJPAArchive) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(JAR_SUFFIX) || entryName.indexOf(SEPERATOR_CHAR, WEB_INF_LIb.length() + 1) != -1) continue;
                try {
                    ReadableArchive jarInLib = location.getSubArchive(entryName);
                    isJPAArchive = this.isEntryPresent(jarInLib, META_INF_PERSISTENCE_XML);
                    jarInLib.close();
                }
                catch (IOException e) {}
            }
        }
        return isJPAArchive;
    }

    private boolean isEntryPresent(ReadableArchive location, String entry) {
        boolean entryPresent = false;
        try {
            entryPresent = location.exists(entry);
        }
        catch (IOException e) {
            // empty catch block
        }
        return entryPresent;
    }

    public Class<? extends Annotation>[] getAnnotationTypes() {
        return handledAnnotations;
    }

    public String[] getContainersNames() {
        return containers;
    }
}

