/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.Holder;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Inhabitants;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.Womb;
import org.jvnet.hk2.component.Wombs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyInhabitant<T>
extends AbstractInhabitantImpl<T> {
    private final String typeName;
    private volatile Inhabitant<T> real;
    private final Holder<ClassLoader> classLoader;
    protected final Habitat habitat;
    private final MultiMap<String, String> metadata;

    public LazyInhabitant(Habitat habitat, Holder<ClassLoader> cl, String typeName, MultiMap<String, String> metadata) {
        assert (metadata != null);
        this.habitat = habitat;
        this.classLoader = cl;
        this.typeName = typeName;
        this.metadata = metadata;
    }

    @Override
    public String typeName() {
        return this.typeName;
    }

    @Override
    public Class<T> type() {
        this.fetch();
        return this.real.type();
    }

    @Override
    public MultiMap<String, String> metadata() {
        return this.metadata;
    }

    private synchronized void fetch() {
        if (this.real != null) {
            return;
        }
        try {
            Class<?> c = this.classLoader.get().loadClass(this.typeName);
            this.real = Inhabitants.wrapByScope(c, this.createWomb(c), this.habitat);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentException("Failed to load " + this.typeName + " from " + this.classLoader.get(), e);
        }
    }

    protected Womb<T> createWomb(Class<T> c) {
        return Wombs.create(c, this.habitat, this.metadata);
    }

    @Override
    public T get(Inhabitant onBehalfOf) throws ComponentException {
        this.fetch();
        return this.real.get(onBehalfOf);
    }

    @Override
    public void release() {
        if (this.real != null) {
            this.real.release();
        }
    }
}

