/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.services.impl.ContainerMapper;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.internal.data.ContainerInfo;
import org.glassfish.internal.data.ContainerRegistry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class SnifferAdapter
implements Adapter {
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    ContainerStarter containerStarter;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    Logger logger;
    private Sniffer sniffer;
    private ContainerMapper mapper;
    private Adapter adapter = null;

    public void initialize(Sniffer sniffer, ContainerMapper mapper) {
        this.sniffer = sniffer;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request req, Response resp) throws Exception {
        if (this.adapter != null) {
            this.adapter.service(req, resp);
            return;
        }
        ContainerRegistry containerRegistry = this.containerRegistry;
        synchronized (containerRegistry) {
            if (this.adapter != null) {
                this.adapter.service(req, resp);
                return;
            }
            if (this.containerRegistry.getContainer(this.sniffer.getContainersNames()[0]) != null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Container is claimed to be started...");
                }
                this.containerRegistry.getContainer(this.sniffer.getContainersNames()[0]).getContainer();
            } else {
                long startTime = System.currentTimeMillis();
                this.logger.info("Attempting to start the " + this.sniffer.getModuleType() + " container");
                Module snifferModule = this.modulesRegistry.find(this.sniffer.getClass());
                try {
                    Collection<ContainerInfo> containersInfo = this.containerStarter.startContainer(this.sniffer, snifferModule);
                    if (containersInfo != null && containersInfo.size() > 0) {
                        for (ContainerInfo info : containersInfo) {
                            if (this.logger.isLoggable(Level.FINE)) {
                                this.logger.fine("Got container, deployer is " + info.getDeployer());
                            }
                            info.getContainer();
                            this.logger.info("Done with starting " + this.sniffer.getModuleType() + " container in " + (System.currentTimeMillis() - startTime) + " ms");
                        }
                    } else {
                        this.logger.severe("Could not start container , no exception provided");
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Exception while starting container " + this.sniffer.getContainersNames()[0], e);
                }
            }
            MessageBytes decodedURI = req.decodedURI();
            try {
                MappingData mappingData = (MappingData)req.getNote(12);
                mappingData.recycle();
                this.adapter = this.mapper.map(req, decodedURI, null);
                if (this.adapter.equals(this)) {
                    this.adapter = null;
                    throw new RuntimeException("SnifferAdapter cannot map themself.");
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Exception while mapping the request", e);
                throw e;
            }
            if (this.adapter == null) {
                throw new RuntimeException("No Adapter found.");
            }
            this.adapter.service(req, resp);
        }
    }

    public void afterService(Request request, Response response) throws Exception {
        if (this.adapter != null) {
            this.adapter.afterService(request, response);
        }
    }
}

