/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.appserv.security.AuditModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.SecurityRole;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class Audit
extends AuditModule {
    private static final String AUDIT_ON = "auditOn";
    private static boolean auditFlag = false;
    private static Logger logger = LogDomains.getLogger(Audit.class, (String)"javax.enterprise.system.core.security");

    public static boolean isActive() {
        return auditFlag;
    }

    public void init(Properties props) {
        super.init(props);
        String audit = props.getProperty(AUDIT_ON);
        auditFlag = audit == null ? false : Boolean.valueOf(audit);
    }

    public void authentication(String user, String realm, boolean success) {
        if (auditFlag) {
            StringBuffer sbuf = new StringBuffer("Audit: Authentication for user = (");
            sbuf.append(user);
            sbuf.append(") under realm = (");
            sbuf.append(realm).append(") returned = ").append(success);
            logger.log(Level.INFO, sbuf.toString());
        }
    }

    public void webInvocation(String user, HttpServletRequest req, String type, boolean success) {
        if (auditFlag) {
            StringBuilder sbuf = new StringBuilder("Audit: [Web] Authorization for user = (");
            sbuf.append(user).append(") and permission type = (").append(type).append(") for request ");
            sbuf.append(req.getMethod()).append(" ").append(req.getRequestURI()).append(" returned =").append(success);
            logger.log(Level.INFO, sbuf.toString());
        }
    }

    public void ejbInvocation(String user, String ejb, String method, boolean success) {
        if (auditFlag) {
            StringBuilder sbuf = new StringBuilder("Audit: [EJB] Authorization for user =");
            sbuf.append(user).append(" for ejb = (");
            sbuf.append(ejb).append(") method = (").append(method).append(") returned =").append(success);
            logger.log(Level.INFO, sbuf.toString());
        }
    }

    public void webServiceInvocation(String uri, String endpoint, boolean success) {
        if (auditFlag) {
            StringBuilder sbuf = new StringBuilder("Audit: [WebService] ");
            sbuf.append("uri: ").append(uri);
            sbuf.append("endpoint: ").append(endpoint);
            sbuf.append(", valid request =").append(success);
            logger.log(Level.INFO, sbuf.toString());
        }
    }

    public void ejbAsWebServiceInvocation(String endpoint, boolean success) {
        if (auditFlag) {
            StringBuilder sbuf = new StringBuilder("Audit: [EjbAsWebService] ");
            sbuf.append("endpoint : ").append(endpoint).append(", valid request =").append(success);
            logger.log(Level.INFO, sbuf.toString());
        }
    }

    public void serverStarted() {
        if (auditFlag) {
            logger.log(Level.INFO, "Audit: Application server startup complete");
        }
    }

    public void serverShutdown() {
        if (auditFlag) {
            logger.log(Level.INFO, "Audit: Application server shutdown complete");
        }
    }

    public static void showACL(Application app) {
        if (!Audit.isActive() || !logger.isLoggable(Level.FINEST)) {
            return;
        }
        try {
            Audit.dumpDiagnostics(app);
        }
        catch (Throwable e) {
            logger.fine("Error while showing ACL diagnostics: " + e.toString());
        }
    }

    private static void dumpDiagnostics(Application app) {
        logger.finest("====[ Role and ACL Summary ]==========");
        if (!app.isVirtual()) {
            logger.finest("Summary for application: " + app.getRegistrationName());
        } else {
            logger.finest("Standalone module.");
        }
        logger.finest("EJB components: " + app.getEjbComponentCount());
        logger.finest("Web components: " + app.getWebComponentCount());
        Set allRoles = app.getRoles();
        if (allRoles == null) {
            logger.finest("- No roles present.");
            return;
        }
        SecurityRoleMapper rmap = app.getRoleMapper();
        if (rmap == null) {
            logger.finest("- No role mappings present.");
            return;
        }
        Iterator i = allRoles.iterator();
        logger.finest("--[ Configured roles and mappings ]--");
        HashMap allRoleMap = new HashMap();
        while (i.hasNext()) {
            Role r = (Role)i.next();
            logger.finest(" [" + r.getName() + "]");
            allRoleMap.put(r.getName(), new HashSet());
            StringBuffer sb = new StringBuffer();
            sb.append("  is mapped to groups: ");
            Enumeration grps = rmap.getGroupsAssignedTo(r);
            while (grps.hasMoreElements()) {
                sb.append(grps.nextElement());
                sb.append(" ");
            }
            logger.finest(sb.toString());
            sb = new StringBuffer();
            sb.append("  is mapped to principals: ");
            Enumeration users = rmap.getUsersAssignedTo(r);
            while (users.hasMoreElements()) {
                sb.append(users.nextElement());
                sb.append(" ");
            }
            logger.finest(sb.toString());
        }
        Set ejbDescriptorSet = app.getEjbBundleDescriptors();
        for (EjbBundleDescriptor bundle : ejbDescriptorSet) {
            logger.finest("--[ EJB module: " + bundle.getName() + " ]--");
            Set ejbs = bundle.getEjbs();
            for (EjbDescriptor ejb : ejbs) {
                logger.finest("EJB: " + ejb.getEjbClassName());
                if (!ejb.getUsesCallerIdentity().booleanValue()) {
                    RunAsIdentityDescriptor runas = ejb.getRunAsIdentity();
                    if (runas == null) {
                        logger.finest(" (ejb does not use caller identity)");
                    } else {
                        String role = runas.getRoleName();
                        String user = runas.getPrincipal();
                        logger.finest(" Will run-as: Role: " + role + "  Principal: " + user);
                        if ((role == null || "".equals(role) || user == null || "".equals(user)) && logger.isLoggable(Level.FINEST)) {
                            logger.finest("*** Configuration error!");
                        }
                    }
                }
                logger.finest(" Method to Role restriction list:");
                Set methods = ejb.getMethodDescriptors();
                for (MethodDescriptor md : methods) {
                    HashSet ram;
                    logger.finest("   " + md.getFormattedString());
                    Set perms = ejb.getMethodPermissionsFor(md);
                    StringBuffer rbuf = new StringBuffer();
                    rbuf.append("     can only be invoked by: ");
                    Iterator sip = perms.iterator();
                    boolean unchecked = false;
                    boolean excluded = false;
                    boolean roleBased = false;
                    while (sip.hasNext()) {
                        MethodPermission p = (MethodPermission)sip.next();
                        if (p.isExcluded()) {
                            excluded = true;
                            logger.finest("     excluded - can not be invoked");
                            continue;
                        }
                        if (p.isUnchecked()) {
                            unchecked = true;
                            logger.finest("     unchecked - can be invoked by all");
                            continue;
                        }
                        if (!p.isRoleBased()) continue;
                        roleBased = true;
                        Role r = p.getRole();
                        rbuf.append(r.getName());
                        rbuf.append(" ");
                        ram = (HashSet)allRoleMap.get(r.getName());
                        ram.add(bundle.getName() + ":" + ejb.getEjbClassName() + "." + md.getFormattedString());
                    }
                    if (roleBased) {
                        logger.finest(rbuf.toString());
                        if (!excluded && !unchecked) continue;
                        logger.finest("*** Configuration error!");
                        continue;
                    }
                    if (unchecked) {
                        if (excluded) {
                            logger.finest("*** Configuration error!");
                        }
                        Set rks = allRoleMap.keySet();
                        Iterator rksi = rks.iterator();
                        while (rksi.hasNext()) {
                            ram = (HashSet)allRoleMap.get(rksi.next());
                            ram.add(bundle.getName() + ":" + ejb.getEjbClassName() + "." + md.getFormattedString());
                        }
                        continue;
                    }
                    if (excluded) continue;
                    logger.finest("*** Configuration error!");
                }
                logger.finest(" IOR configuration:");
                Set iors = ejb.getIORConfigurationDescriptors();
                if (iors == null) continue;
                for (EjbIORConfigurationDescriptor ior : iors) {
                    StringBuffer iorsb = new StringBuffer();
                    iorsb.append("realm=");
                    iorsb.append(ior.getRealmName());
                    iorsb.append(", integrity=");
                    iorsb.append(ior.getIntegrity());
                    iorsb.append(", trust-in-target=");
                    iorsb.append(ior.getEstablishTrustInTarget());
                    iorsb.append(", trust-in-client=");
                    iorsb.append(ior.getEstablishTrustInClient());
                    iorsb.append(", propagation=");
                    iorsb.append(ior.getCallerPropagation());
                    iorsb.append(", auth-method=");
                    iorsb.append(ior.getAuthenticationMethod());
                    logger.finest(iorsb.toString());
                }
            }
        }
        logger.finest("--[ EJB methods accessible by role ]--");
        Set rks = allRoleMap.keySet();
        for (String roleName : rks) {
            logger.finest(" [" + roleName + "]");
            HashSet ram = (HashSet)allRoleMap.get(roleName);
            for (String meth : ram) {
                logger.finest("   " + meth);
            }
        }
        Set webDescriptorSet = app.getWebBundleDescriptors();
        for (WebBundleDescriptor wbd : webDescriptorSet) {
            logger.finest("--[ Web module: " + wbd.getContextRoot() + " ]--");
            LoginConfiguration lconf = wbd.getLoginConfiguration();
            if (lconf != null) {
                logger.finest("  Login config: realm=" + lconf.getRealmName() + ", method=" + lconf.getAuthenticationMethod() + ", form=" + lconf.getFormLoginPage() + ", error=" + lconf.getFormErrorPage());
            }
            logger.finest("  Contains components:");
            Set webComps = wbd.getWebComponentDescriptors();
            for (WebComponentDescriptor wcd : webComps) {
                StringBuffer name = new StringBuffer();
                name.append("   - " + wcd.getCanonicalName());
                name.append(" [ ");
                Enumeration urlPs = wcd.getUrlPatterns();
                while (urlPs.hasMoreElements()) {
                    name.append(urlPs.nextElement().toString());
                    name.append(" ");
                }
                name.append("]");
                logger.finest(name.toString());
                RunAsIdentityDescriptor runas = wcd.getRunAsIdentity();
                if (runas == null) continue;
                String role = runas.getRoleName();
                String user = runas.getPrincipal();
                logger.finest("      Will run-as: Role: " + role + "  Principal: " + user);
                if (role != null && !"".equals(role) && user != null && !"".equals(user)) continue;
                logger.finest("*** Configuration error!");
            }
            logger.finest("  Security constraints:");
            Enumeration scEnum = wbd.getSecurityConstraints();
            while (scEnum.hasMoreElements()) {
                SecurityConstraintImpl sc = (SecurityConstraintImpl)scEnum.nextElement();
                Set wrcSet = sc.getWebResourceCollectionSet();
                for (WebResourceCollectionImpl wrc : wrcSet) {
                    Enumeration methEnum = wrc.getHttpMethods();
                    StringBuffer sbm = new StringBuffer();
                    while (methEnum.hasMoreElements()) {
                        sbm.append(methEnum.nextElement());
                        sbm.append(" ");
                    }
                    logger.finest("     Using method: " + sbm.toString());
                    Enumeration urlEnum = wrc.getUrlPatterns();
                    while (urlEnum.hasMoreElements()) {
                        logger.finest("       " + urlEnum.nextElement().toString());
                    }
                }
                AuthorizationConstraintImpl authCons = (AuthorizationConstraintImpl)sc.getAuthorizationConstraint();
                Enumeration rolesEnum = authCons.getSecurityRoles();
                StringBuffer rsb = new StringBuffer();
                rsb.append("     Accessible by roles: ");
                while (rolesEnum.hasMoreElements()) {
                    SecurityRole sr = (SecurityRole)rolesEnum.nextElement();
                    rsb.append(sr.getName());
                    rsb.append(" ");
                }
                logger.finest(rsb.toString());
                UserDataConstraint udc = sc.getUserDataConstraint();
                if (udc == null) continue;
                logger.finest("     Transport guarantee: " + udc.getTransportGuarantee());
            }
        }
        logger.finest("======================================");
    }
}

