/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.auth.login.PasswordLoginModule;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;

public class FileLoginModule
extends PasswordLoginModule {
    protected void authenticate() throws LoginException {
        if (!(this._currentRealm instanceof FileRealm)) {
            String msg = sm.getString("filelm.badrealm");
            throw new LoginException(msg);
        }
        FileRealm fileRealm = (FileRealm)this._currentRealm;
        String[] grpList = fileRealm.authenticate(this._username, this._password);
        if (grpList == null) {
            String msg = sm.getString("filelm.faillogin", (Object)this._username);
            throw new LoginException(msg);
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "File login succeeded for: " + this._username);
        }
        String[] groupListToForward = new String[grpList.length];
        for (int i = 0; i < grpList.length; ++i) {
            groupListToForward[i] = grpList[i];
        }
        this.commitAuthentication(this._username, this._password, this._currentRealm, groupListToForward);
    }
}

