/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observable;
import java.util.Set;

public class DynamicAttributesDescriptor
extends Observable
implements Serializable {
    private Map dynamicAttributes;

    public Map getExtraAttributes() {
        if (this.dynamicAttributes == null) {
            this.dynamicAttributes = new Hashtable();
        }
        return this.dynamicAttributes;
    }

    public void addExtraAttribute(String name, Object value) {
        if (value == null) {
            return;
        }
        if (this.dynamicAttributes == null) {
            this.dynamicAttributes = new Hashtable();
        }
        this.dynamicAttributes.put(name, value);
        this.changed();
    }

    public Object getExtraAttribute(String name) {
        if (this.dynamicAttributes == null) {
            return null;
        }
        return this.dynamicAttributes.get(name);
    }

    public void removeExtraAttribute(String name) {
        if (this.dynamicAttributes == null) {
            return;
        }
        this.dynamicAttributes.remove(name);
        this.changed();
    }

    public void print(StringBuffer toStringBuffer) {
        if (this.dynamicAttributes != null) {
            toStringBuffer.append("==>Dynamic Attribute");
            Set keys = this.dynamicAttributes.keySet();
            for (String keyName : keys) {
                Object o = this.getExtraAttribute(keyName);
                if (o instanceof Object[]) {
                    Object[] objects = (Object[])o;
                    for (int i = 0; i < objects.length; ++i) {
                        toStringBuffer.append("\n Indexed prop name ").append(keyName).append("[").append(i).append("] = ");
                        if (objects[i] instanceof DynamicAttributesDescriptor) {
                            ((DynamicAttributesDescriptor)objects[i]).print(toStringBuffer);
                            continue;
                        }
                        toStringBuffer.append(objects[i]);
                    }
                    continue;
                }
                toStringBuffer.append("\n  Property name = ").append(keyName).append(" value = ");
                if (o instanceof DynamicAttributesDescriptor) {
                    ((DynamicAttributesDescriptor)o).print(toStringBuffer);
                    continue;
                }
                toStringBuffer.append(o);
            }
            toStringBuffer.append("\n<==End");
            return;
        }
        toStringBuffer.append("<== No attribute ==>");
    }

    public String toString() {
        StringBuffer toStringBuf = new StringBuffer();
        this.print(toStringBuf);
        return toStringBuf.toString();
    }

    private void changed() {
        this.setChanged();
        this.notifyObservers();
    }
}

