/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.annotation.impl.EjbInWarScanner;
import com.sun.enterprise.deployment.archivist.BaseEjbArchivist;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.EjbDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.EjbRuntimeDDFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.apf.Scanner;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.xml.sax.SAXParseException;

@Service
@Scoped(value=PerLookup.class)
public class EjbInWarArchivist
extends BaseEjbArchivist {
    @Inject
    Habitat habitat;

    public DeploymentDescriptorFile getStandardDDFile() {
        return new EjbDeploymentDescriptorFile(){

            public String getDeploymentDescriptorPath() {
                return "WEB-INF/ejb-jar.xml";
            }
        };
    }

    public DeploymentDescriptorFile getConfigurationDDFile() {
        return new EjbRuntimeDDFile(){

            public String getDeploymentDescriptorPath() {
                return "WEB-INF/sun-ejb-jar.xml";
            }
        };
    }

    protected String getArchiveExtension() {
        return ".war";
    }

    public Scanner getScanner() {
        return (Scanner)this.habitat.getComponent(EjbInWarScanner.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPersistenceDeploymentDescriptors(ReadableArchive archive, EjbBundleDescriptor descriptor) throws IOException, SAXParseException {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, "EjbArchivist", "readPersistenceDeploymentDescriptors", "archive = {0}", archive.getURI());
        }
        HashMap<String, ReadableArchive> subArchives = new HashMap<String, ReadableArchive>();
        Enumeration entries = archive.entries();
        String CLASSES_DIR = "WEB-INF/classes/";
        String LIB_DIR = "WEB-INF/lib/";
        String JAR_EXT = ".jar";
        try {
            ReadableArchive libArchive = archive.getSubArchive("WEB-INF/lib/");
            if (libArchive != null) {
                Enumeration libEntries = libArchive.entries();
                while (libEntries.hasMoreElements()) {
                    String path = (String)libEntries.nextElement();
                    if (!path.endsWith(".jar")) continue;
                    if (path.indexOf(47) == -1) {
                        try {
                            subArchives.put("WEB-INF/lib//" + path, libArchive.getSubArchive(path));
                        }
                        catch (IOException ioe) {
                            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
                        }
                        continue;
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, "EjbArchivist", "readPersistenceDeploymentDescriptors", "skipping {0} as it exists inside a directory in {1}.", new Object[]{path, "WEB-INF/lib/"});
                }
            }
            String pathOfPersistenceXMLInsideClassesDir = "WEB-INF/classes/META-INF/persistence.xml";
            InputStream is = archive.getEntry("WEB-INF/classes/META-INF/persistence.xml");
            if (is != null) {
                is.close();
                subArchives.put("WEB-INF/classes/", archive.getSubArchive("WEB-INF/classes/"));
            }
            for (Map.Entry pathToArchiveEntry : subArchives.entrySet()) {
                this.readPersistenceDeploymentDescriptor((ReadableArchive)pathToArchiveEntry.getValue(), (String)pathToArchiveEntry.getKey(), descriptor);
            }
        }
        finally {
            for (ReadableArchive subArchive : subArchives.values()) {
                subArchive.close();
            }
        }
    }
}

