/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.expressions;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.LogicalExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.JavaPlatform;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class ExpressionOperator
implements Serializable {
    static final long serialVersionUID = -7066100204792043980L;
    protected int selector;
    protected String[] databaseStrings;
    protected boolean isPrefix = false;
    protected boolean isRepeating = false;
    protected Class nodeClass;
    protected int type = 5;
    protected int[] argumentIndices = null;
    protected static Map allOperators = ExpressionOperator.initializeOperators();
    protected static Map platformOperatorNames = ExpressionOperator.initializePlatformOperatorNames();
    protected String[] javaStrings;
    public static final int LogicalOperator = 1;
    public static final int ComparisonOperator = 2;
    public static final int AggregateOperator = 3;
    public static final int OrderOperator = 4;
    public static final int FunctionOperator = 5;
    public static final int And = 1;
    public static final int Or = 2;
    public static final int Not = 3;
    public static final int Equal = 4;
    public static final int NotEqual = 5;
    public static final int EqualOuterJoin = 6;
    public static final int LessThan = 7;
    public static final int LessThanEqual = 8;
    public static final int GreaterThan = 9;
    public static final int GreaterThanEqual = 10;
    public static final int Like = 11;
    public static final int NotLike = 12;
    public static final int In = 13;
    public static final int InSubQuery = 129;
    public static final int NotIn = 14;
    public static final int NotInSubQuery = 130;
    public static final int Between = 15;
    public static final int NotBetween = 16;
    public static final int IsNull = 17;
    public static final int NotNull = 18;
    public static final int Exists = 86;
    public static final int NotExists = 88;
    public static final int LikeEscape = 89;
    public static final int Decode = 105;
    public static final int Case = 117;
    public static final int Count = 19;
    public static final int Sum = 20;
    public static final int Average = 21;
    public static final int Maximum = 22;
    public static final int Minimum = 23;
    public static final int StandardDeviation = 24;
    public static final int Variance = 25;
    public static final int Distinct = 87;
    public static final int Ascending = 26;
    public static final int Descending = 27;
    public static final int ToUpperCase = 28;
    public static final int ToLowerCase = 29;
    public static final int Chr = 30;
    public static final int Concat = 31;
    public static final int HexToRaw = 32;
    public static final int Initcap = 33;
    public static final int Instring = 34;
    public static final int Soundex = 35;
    public static final int LeftPad = 36;
    public static final int LeftTrim = 37;
    public static final int Replace = 38;
    public static final int RightPad = 39;
    public static final int RightTrim = 40;
    public static final int Substring = 41;
    public static final int ToNumber = 42;
    public static final int Translate = 43;
    public static final int Trim = 44;
    public static final int Ascii = 45;
    public static final int Length = 46;
    public static final int CharIndex = 96;
    public static final int CharLength = 97;
    public static final int Difference = 98;
    public static final int Reverse = 99;
    public static final int Replicate = 100;
    public static final int Right = 101;
    public static final int Locate = 112;
    public static final int Locate2 = 113;
    public static final int ToChar = 114;
    public static final int ToCharWithFormat = 115;
    public static final int RightTrim2 = 116;
    public static final int Any = 118;
    public static final int Some = 119;
    public static final int All = 120;
    public static final int Trim2 = 121;
    public static final int LeftTrim2 = 122;
    public static final int AddMonths = 47;
    public static final int DateToString = 48;
    public static final int LastDay = 49;
    public static final int MonthsBetween = 50;
    public static final int NextDay = 51;
    public static final int RoundDate = 52;
    public static final int ToDate = 53;
    public static final int Today = 54;
    public static final int AddDate = 90;
    public static final int DateName = 92;
    public static final int DatePart = 93;
    public static final int DateDifference = 94;
    public static final int TruncateDate = 102;
    public static final int NewTime = 103;
    public static final int Nvl = 104;
    public static final int CurrentDate = 123;
    public static final int CurrentTime = 128;
    public static final int Ceil = 55;
    public static final int Cos = 56;
    public static final int Cosh = 57;
    public static final int Abs = 58;
    public static final int Acos = 59;
    public static final int Asin = 60;
    public static final int Atan = 61;
    public static final int Exp = 62;
    public static final int Sqrt = 63;
    public static final int Floor = 64;
    public static final int Ln = 65;
    public static final int Log = 66;
    public static final int Mod = 67;
    public static final int Power = 68;
    public static final int Round = 69;
    public static final int Sign = 70;
    public static final int Sin = 71;
    public static final int Sinh = 72;
    public static final int Tan = 73;
    public static final int Tanh = 74;
    public static final int Trunc = 75;
    public static final int Greatest = 76;
    public static final int Least = 77;
    public static final int Add = 78;
    public static final int Subtract = 79;
    public static final int Divide = 80;
    public static final int Multiply = 81;
    public static final int Atan2 = 91;
    public static final int Cot = 95;
    public static final int Deref = 82;
    public static final int Ref = 83;
    public static final int RefToHex = 84;
    public static final int Value = 85;
    public static final int Extract = 106;
    public static final int ExtractValue = 107;
    public static final int ExistsNode = 108;
    public static final int GetStringVal = 109;
    public static final int GetNumberVal = 110;
    public static final int IsFragment = 111;
    public static final int SDO_WITHIN_DISTANCE = 124;
    public static final int SDO_RELATE = 125;
    public static final int SDO_FILTER = 126;
    public static final int SDO_NN = 127;

    public ExpressionOperator() {
        this.setNodeClass(ClassConstants.FunctionExpression_Class);
    }

    public ExpressionOperator(int selector, Vector newDatabaseStrings) {
        this.setNodeClass(ClassConstants.FunctionExpression_Class);
        this.selector = selector;
        this.printsAs(newDatabaseStrings);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionOperator operator = (ExpressionOperator)object;
        if (this.getSelector() == 0) {
            return this.getDatabaseStrings().equals(operator.getDatabaseStrings());
        }
        return this.getSelector() == operator.getSelector();
    }

    public int hashCode() {
        return this.getSelector();
    }

    public static ExpressionOperator abs() {
        return ExpressionOperator.simpleFunction(58, "ABS");
    }

    public static ExpressionOperator acos() {
        return ExpressionOperator.simpleFunction(59, "ACOS");
    }

    public static ExpressionOperator addDate() {
        ExpressionOperator exOperator = ExpressionOperator.simpleThreeArgumentFunction(90, "DATEADD");
        int[] indices = new int[]{1, 2, 0};
        exOperator.setArgumentIndices(indices);
        return exOperator;
    }

    public static ExpressionOperator addMonths() {
        return ExpressionOperator.simpleTwoArgumentFunction(47, "ADD_MONTHS");
    }

    public static void addOperator(ExpressionOperator exOperator) {
        allOperators.put(new Integer(exOperator.getSelector()), exOperator);
    }

    public static ExpressionOperator and() {
        return ExpressionOperator.simpleLogical(1, "AND", "and");
    }

    public Object applyFunction(Object source, Vector arguments) {
        if (source instanceof String) {
            if (this.getSelector() == 28) {
                return ((String)source).toUpperCase();
            }
            if (this.getSelector() == 29) {
                return ((String)source).toLowerCase();
            }
            if (this.getSelector() == 31 && arguments.size() == 1 && arguments.elementAt(0) instanceof String) {
                return ((String)source).concat((String)arguments.elementAt(0));
            }
            if (this.getSelector() == 41 && arguments.size() == 2 && arguments.elementAt(0) instanceof Number && arguments.elementAt(1) instanceof Number) {
                int beginIndexInclusive = ((Number)arguments.elementAt(0)).intValue() - 1;
                int endIndexExclusive = beginIndexInclusive + ((Number)arguments.elementAt(1)).intValue();
                return ((String)source).substring(beginIndexInclusive, endIndexExclusive);
            }
            if (this.getSelector() == 42) {
                return new BigDecimal((String)source);
            }
            if (this.getSelector() == 44) {
                return ((String)source).trim();
            }
            if (this.getSelector() == 46) {
                return new Integer(((String)source).length());
            }
        } else if (source instanceof Number) {
            if (this.getSelector() == 55) {
                return new Double(Math.ceil(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 56) {
                return new Double(Math.cos(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 58) {
                return new Double(Math.abs(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 59) {
                return new Double(Math.acos(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 60) {
                return new Double(Math.asin(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 61) {
                return new Double(Math.atan(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 62) {
                return new Double(Math.exp(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 63) {
                return new Double(Math.sqrt(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 64) {
                return new Double(Math.floor(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 66) {
                return new Double(Math.log(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 68 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return new Double(Math.pow(((Number)source).doubleValue(), ((Number)arguments.elementAt(0)).doubleValue()));
            }
            if (this.getSelector() == 69) {
                return new Double(Math.round(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 71) {
                return new Double(Math.sin(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 73) {
                return new Double(Math.tan(((Number)source).doubleValue()));
            }
            if (this.getSelector() == 76 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return new Double(Math.max(((Number)source).doubleValue(), ((Number)arguments.elementAt(0)).doubleValue()));
            }
            if (this.getSelector() == 77 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return new Double(Math.min(((Number)source).doubleValue(), ((Number)arguments.elementAt(0)).doubleValue()));
            }
            if (this.getSelector() == 78 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return new Double(((Number)source).doubleValue() + ((Number)arguments.elementAt(0)).doubleValue());
            }
            if (this.getSelector() == 79 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return new Double(((Number)source).doubleValue() - ((Number)arguments.elementAt(0)).doubleValue());
            }
            if (this.getSelector() == 80 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return new Double(((Number)source).doubleValue() / ((Number)arguments.elementAt(0)).doubleValue());
            }
            if (this.getSelector() == 81 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return new Double(((Number)source).doubleValue() * ((Number)arguments.elementAt(0)).doubleValue());
            }
        }
        throw QueryException.cannotConformExpression();
    }

    public static ExpressionOperator ascending() {
        return ExpressionOperator.simpleOrdering(26, "ASC", "ascending");
    }

    public static ExpressionOperator ascii() {
        return ExpressionOperator.simpleFunction(45, "ASCII");
    }

    public static ExpressionOperator asin() {
        return ExpressionOperator.simpleFunction(60, "ASIN");
    }

    public static ExpressionOperator atan() {
        return ExpressionOperator.simpleFunction(61, "ATAN");
    }

    public static ExpressionOperator average() {
        return ExpressionOperator.simpleAggregate(21, "AVG", "average");
    }

    public void bePostfix() {
        this.isPrefix = false;
    }

    public void bePrefix() {
        this.isPrefix = true;
    }

    public void beRepeating() {
        this.isRepeating = true;
    }

    public static ExpressionOperator between() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(15);
        result.setType(2);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement("(");
        ((Vector)v).addElement(" BETWEEN ");
        ((Vector)v).addElement(" AND ");
        ((Vector)v).addElement(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator caseStatement() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(117);
        exOperator.bePrefix();
        exOperator.setNodeClass(FunctionExpression.class);
        return exOperator;
    }

    public static ExpressionOperator ceil() {
        return ExpressionOperator.simpleFunction(55, "CEIL");
    }

    public static ExpressionOperator charIndex() {
        return ExpressionOperator.simpleTwoArgumentFunction(96, "CHARINDEX");
    }

    public static ExpressionOperator charLength() {
        return ExpressionOperator.simpleFunction(97, "CHAR_LENGTH");
    }

    public static ExpressionOperator chr() {
        return ExpressionOperator.simpleFunction(30, "CHR");
    }

    public static ExpressionOperator concat() {
        return ExpressionOperator.simpleMath(31, "+");
    }

    public boolean conformBetween(Object left, Object right) {
        Object start = ((Vector)right).elementAt(0);
        Object end = ((Vector)right).elementAt(1);
        if (left == null || start == null || end == null) {
            return false;
        }
        if (left instanceof Number && start instanceof Number && end instanceof Number) {
            return ((Number)left).doubleValue() >= ((Number)start).doubleValue() && ((Number)left).doubleValue() <= ((Number)end).doubleValue();
        }
        if (left instanceof String && start instanceof String && end instanceof String) {
            return !(((String)left).compareTo((String)start) <= 0 && ((String)left).compareTo((String)start) != 0 || ((String)left).compareTo((String)end) >= 0 && ((String)left).compareTo((String)end) != 0);
        }
        if (left instanceof Date && start instanceof Date && end instanceof Date) {
            return !(!((Date)left).after((Date)start) && !((Date)left).equals(start) || !((Date)left).before((Date)end) && !((Date)left).equals(end));
        }
        throw QueryException.cannotConformExpression();
    }

    public boolean conformLike(Object left, Object right) {
        if (right == null && left == null) {
            return true;
        }
        if (!(right instanceof String) || !(left instanceof String)) {
            throw QueryException.cannotConformExpression();
        }
        String likeString = (String)right;
        if (likeString.indexOf("_") != -1) {
            throw QueryException.cannotConformExpression();
        }
        String value = (String)left;
        if (likeString.indexOf("%") == -1) {
            return left.equals(right);
        }
        boolean strictStart = !likeString.startsWith("%");
        boolean strictEnd = !likeString.endsWith("%");
        StringTokenizer tokens = new StringTokenizer(likeString, "%");
        int lastPosition = 0;
        String lastToken = null;
        if (strictStart && !value.startsWith(lastToken = tokens.nextToken())) {
            return false;
        }
        while (tokens.hasMoreTokens()) {
            lastToken = tokens.nextToken();
            lastPosition = value.indexOf(lastToken, lastPosition);
            if (lastPosition >= 0) continue;
            return false;
        }
        if (strictEnd) {
            return value.endsWith(lastToken);
        }
        return true;
    }

    public static ExpressionOperator cos() {
        return ExpressionOperator.simpleFunction(56, "COS");
    }

    public static ExpressionOperator cosh() {
        return ExpressionOperator.simpleFunction(57, "COSH");
    }

    public static ExpressionOperator cot() {
        return ExpressionOperator.simpleFunction(95, "COT");
    }

    public static ExpressionOperator count() {
        return ExpressionOperator.simpleAggregate(19, "COUNT", "count");
    }

    public static ExpressionOperator dateDifference() {
        return ExpressionOperator.simpleThreeArgumentFunction(94, "DATEDIFF");
    }

    public static ExpressionOperator dateName() {
        return ExpressionOperator.simpleTwoArgumentFunction(92, "DATENAME");
    }

    public static ExpressionOperator oracleDateName() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(92);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("TO_CHAR(");
        ((Vector)v).addElement(", '");
        ((Vector)v).addElement("')");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator datePart() {
        return ExpressionOperator.simpleTwoArgumentFunction(93, "DATEPART");
    }

    public static ExpressionOperator dateToString() {
        return ExpressionOperator.simpleFunction(48, "TO_CHAR");
    }

    public static ExpressionOperator toChar() {
        return ExpressionOperator.simpleFunction(114, "TO_CHAR");
    }

    public static ExpressionOperator toCharWithFormat() {
        return ExpressionOperator.simpleTwoArgumentFunction(115, "TO_CHAR");
    }

    public static ExpressionOperator decode() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(105);
        exOperator.setNodeClass(FunctionExpression.class);
        exOperator.setType(5);
        exOperator.bePrefix();
        return exOperator;
    }

    public static ExpressionOperator deref() {
        return ExpressionOperator.simpleFunction(82, "DEREF");
    }

    public static ExpressionOperator descending() {
        return ExpressionOperator.simpleOrdering(27, "DESC", "descending");
    }

    public static ExpressionOperator difference() {
        return ExpressionOperator.simpleTwoArgumentFunction(98, "DIFFERENCE");
    }

    public static ExpressionOperator distinct() {
        return ExpressionOperator.simpleFunction(87, "DISTINCT", "distinct");
    }

    public boolean doesRelationConform(Object left, Object right) {
        if (this.selector == 4) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof Number && right instanceof Number && left.getClass() != right.getClass()) {
                return ((Number)left).doubleValue() == ((Number)right).doubleValue();
            }
            return left.equals(right);
        }
        if (this.selector == 5) {
            if (left == null && right == null) {
                return false;
            }
            if (left == null || right == null) {
                return true;
            }
            return !left.equals(right);
        }
        if (this.selector == 17) {
            return left == null;
        }
        if (this.selector == 18) {
            return left != null;
        }
        if (this.selector == 7) {
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof Number && right instanceof Number) {
                return ((Number)left).doubleValue() < ((Number)right).doubleValue();
            }
            if (left instanceof String && right instanceof String) {
                return ((String)left).compareTo((String)right) < 0;
            }
            if (left instanceof Date && right instanceof Date) {
                return ((Date)left).before((Date)right);
            }
        } else if (this.selector == 8) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof Number && right instanceof Number) {
                return ((Number)left).doubleValue() <= ((Number)right).doubleValue();
            }
            if (left instanceof String && right instanceof String) {
                int compareValue = ((String)left).compareTo((String)right);
                return compareValue < 0 || compareValue == 0;
            }
            if (left instanceof Date && right instanceof Date) {
                return ((Date)left).equals(right) || ((Date)left).before((Date)right);
            }
        } else if (this.selector == 9) {
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof Number && right instanceof Number) {
                return ((Number)left).doubleValue() > ((Number)right).doubleValue();
            }
            if (left instanceof String && right instanceof String) {
                int compareValue = ((String)left).compareTo((String)right);
                return compareValue > 0;
            }
            if (left instanceof Date && right instanceof Date) {
                return ((Date)left).after((Date)right);
            }
        } else if (this.selector == 10) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof Number && right instanceof Number) {
                return ((Number)left).doubleValue() >= ((Number)right).doubleValue();
            }
            if (left instanceof String && right instanceof String) {
                int compareValue = ((String)left).compareTo((String)right);
                return compareValue > 0 || compareValue == 0;
            }
            if (left instanceof Date && right instanceof Date) {
                return ((Date)left).equals(right) || ((Date)left).after((Date)right);
            }
        } else {
            Boolean doesLikeConform;
            if (this.selector == 15 && right instanceof Vector && ((Vector)right).size() == 2) {
                return this.conformBetween(left, right);
            }
            if (this.selector == 16 && right instanceof Vector && ((Vector)right).size() == 2) {
                return !this.conformBetween(left, right);
            }
            if (this.selector == 13 && right instanceof Collection) {
                return ((Collection)right).contains(left);
            }
            if (this.selector == 14 && right instanceof Collection) {
                return !((Collection)right).contains(left);
            }
            if ((this.selector == 11 || this.selector == 12) && (doesLikeConform = JavaPlatform.conformLike(left, right)) != null) {
                if (doesLikeConform.booleanValue()) {
                    return this.selector == 11;
                }
                return this.selector != 11;
            }
        }
        throw QueryException.cannotConformExpression();
    }

    public static ExpressionOperator equalOuterJoin() {
        return ExpressionOperator.simpleRelation(6, "=*");
    }

    public static ExpressionOperator exists() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(86);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("EXISTS ");
        ((Vector)v).addElement(" ");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator exp() {
        return ExpressionOperator.simpleFunction(62, "EXP");
    }

    public Expression expressionFor(Expression base) {
        return this.expressionForArguments(base, NonSynchronizedVector.newInstance(0));
    }

    public Expression expressionFor(Expression base, Object value) {
        return this.newExpressionForArgument(base, value);
    }

    public Expression expressionForWithBaseLast(Expression base, Object value) {
        return this.newExpressionForArgumentWithBaseLast(base, value);
    }

    public Expression expressionForArguments(Expression base, Vector arguments) {
        return this.newExpressionForArguments(base, arguments);
    }

    public static ExpressionOperator extract() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement("extract(");
        ((Vector)v).addElement(",");
        ((Vector)v).addElement(")");
        result.printsAs(v);
        result.bePrefix();
        result.setSelector(106);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator extractValue() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement("extractValue(");
        ((Vector)v).addElement(",");
        ((Vector)v).addElement(")");
        result.printsAs(v);
        result.bePrefix();
        result.setSelector(107);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator existsNode() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement("existsNode(");
        ((Vector)v).addElement(",");
        ((Vector)v).addElement(")");
        result.printsAs(v);
        result.bePrefix();
        result.setSelector(108);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator getStringVal() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement(".getStringVal()");
        result.printsAs(v);
        result.bePostfix();
        result.setSelector(109);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator getNumberVal() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement(".getNumberVal()");
        result.printsAs(v);
        result.bePostfix();
        result.setSelector(110);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator isFragment() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement(".isFragment()");
        result.printsAs(v);
        result.bePostfix();
        result.setSelector(111);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator floor() {
        return ExpressionOperator.simpleFunction(64, "FLOOR");
    }

    public static Map getAllOperators() {
        return allOperators;
    }

    public String[] getDatabaseStrings() {
        return this.databaseStrings;
    }

    public String[] getJavaStrings() {
        return this.javaStrings;
    }

    public Class getNodeClass() {
        return this.nodeClass;
    }

    public static ExpressionOperator getOperator(Integer selector) {
        return (ExpressionOperator)ExpressionOperator.getAllOperators().get(selector);
    }

    public int getSelector() {
        return this.selector;
    }

    public int getType() {
        return this.type;
    }

    public static ExpressionOperator greatest() {
        return ExpressionOperator.simpleTwoArgumentFunction(76, "GREATEST");
    }

    public static ExpressionOperator hexToRaw() {
        return ExpressionOperator.simpleFunction(32, "HEXTORAW");
    }

    public static ExpressionOperator ifNull() {
        return ExpressionOperator.simpleTwoArgumentFunction(104, "NVL");
    }

    public static ExpressionOperator in() {
        return ExpressionOperator.simpleRelation(13, "IN");
    }

    public static ExpressionOperator inSubQuery() {
        ExpressionOperator result = new ExpressionOperator();
        result.setType(5);
        result.setSelector(129);
        Vector<String> v = new Vector<String>(1);
        v.addElement(" IN ");
        result.printsAs(v);
        result.bePostfix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator initcap() {
        return ExpressionOperator.simpleFunction(33, "INITCAP");
    }

    protected static void initializeAggregateFunctionOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.count());
        ExpressionOperator.addOperator(ExpressionOperator.sum());
        ExpressionOperator.addOperator(ExpressionOperator.average());
        ExpressionOperator.addOperator(ExpressionOperator.minimum());
        ExpressionOperator.addOperator(ExpressionOperator.maximum());
        ExpressionOperator.addOperator(ExpressionOperator.variance());
        ExpressionOperator.addOperator(ExpressionOperator.distinct());
    }

    protected static void initializeFunctionOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.notOperator());
        ExpressionOperator.addOperator(ExpressionOperator.ascending());
        ExpressionOperator.addOperator(ExpressionOperator.descending());
        ExpressionOperator.addOperator(ExpressionOperator.any());
        ExpressionOperator.addOperator(ExpressionOperator.some());
        ExpressionOperator.addOperator(ExpressionOperator.all());
        ExpressionOperator.addOperator(ExpressionOperator.in());
        ExpressionOperator.addOperator(ExpressionOperator.inSubQuery());
        ExpressionOperator.addOperator(ExpressionOperator.notIn());
        ExpressionOperator.addOperator(ExpressionOperator.notInSubQuery());
    }

    protected static void initializeLogicalOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.and());
        ExpressionOperator.addOperator(ExpressionOperator.or());
        ExpressionOperator.addOperator(ExpressionOperator.isNull());
        ExpressionOperator.addOperator(ExpressionOperator.notNull());
    }

    public static Map initializeOperators() {
        ExpressionOperator.resetOperators();
        ExpressionOperator.initializeFunctionOperators();
        ExpressionOperator.initializeRelationOperators();
        ExpressionOperator.initializeLogicalOperators();
        ExpressionOperator.initializeAggregateFunctionOperators();
        return allOperators;
    }

    public static String getPlatformOperatorName(int operator) {
        String name = (String)ExpressionOperator.getPlatformOperatorNames().get(new Integer(operator));
        if (name == null) {
            name = String.valueOf(operator);
        }
        return name;
    }

    public static Map getPlatformOperatorNames() {
        return platformOperatorNames;
    }

    public static Map initializePlatformOperatorNames() {
        HashMap<Integer, String> platformOperatorNames = new HashMap<Integer, String>();
        platformOperatorNames.put(new Integer(28), "ToUpperCase");
        platformOperatorNames.put(new Integer(29), "ToLowerCase");
        platformOperatorNames.put(new Integer(30), "Chr");
        platformOperatorNames.put(new Integer(31), "Concat");
        platformOperatorNames.put(new Integer(32), "HexToRaw");
        platformOperatorNames.put(new Integer(33), "Initcap");
        platformOperatorNames.put(new Integer(34), "Instring");
        platformOperatorNames.put(new Integer(35), "Soundex");
        platformOperatorNames.put(new Integer(36), "LeftPad");
        platformOperatorNames.put(new Integer(37), "LeftTrim");
        platformOperatorNames.put(new Integer(39), "RightPad");
        platformOperatorNames.put(new Integer(40), "RightTrim");
        platformOperatorNames.put(new Integer(41), "Substring");
        platformOperatorNames.put(new Integer(43), "Translate");
        platformOperatorNames.put(new Integer(45), "Ascii");
        platformOperatorNames.put(new Integer(46), "Length");
        platformOperatorNames.put(new Integer(96), "CharIndex");
        platformOperatorNames.put(new Integer(97), "CharLength");
        platformOperatorNames.put(new Integer(98), "Difference");
        platformOperatorNames.put(new Integer(99), "Reverse");
        platformOperatorNames.put(new Integer(100), "Replicate");
        platformOperatorNames.put(new Integer(101), "Right");
        platformOperatorNames.put(new Integer(112), "Locate");
        platformOperatorNames.put(new Integer(113), "Locate");
        platformOperatorNames.put(new Integer(42), "ToNumber");
        platformOperatorNames.put(new Integer(114), "ToChar");
        platformOperatorNames.put(new Integer(115), "ToChar");
        platformOperatorNames.put(new Integer(47), "AddMonths");
        platformOperatorNames.put(new Integer(48), "DateToString");
        platformOperatorNames.put(new Integer(50), "MonthsBetween");
        platformOperatorNames.put(new Integer(51), "NextDay");
        platformOperatorNames.put(new Integer(52), "RoundDate");
        platformOperatorNames.put(new Integer(90), "AddDate");
        platformOperatorNames.put(new Integer(92), "DateName");
        platformOperatorNames.put(new Integer(93), "DatePart");
        platformOperatorNames.put(new Integer(94), "DateDifference");
        platformOperatorNames.put(new Integer(102), "TruncateDate");
        platformOperatorNames.put(new Integer(103), "NewTime");
        platformOperatorNames.put(new Integer(104), "Nvl");
        platformOperatorNames.put(new Integer(103), "NewTime");
        platformOperatorNames.put(new Integer(55), "Ceil");
        platformOperatorNames.put(new Integer(56), "Cos");
        platformOperatorNames.put(new Integer(57), "Cosh");
        platformOperatorNames.put(new Integer(58), "Abs");
        platformOperatorNames.put(new Integer(59), "Acos");
        platformOperatorNames.put(new Integer(60), "Asin");
        platformOperatorNames.put(new Integer(61), "Atan");
        platformOperatorNames.put(new Integer(62), "Exp");
        platformOperatorNames.put(new Integer(63), "Sqrt");
        platformOperatorNames.put(new Integer(64), "Floor");
        platformOperatorNames.put(new Integer(65), "Ln");
        platformOperatorNames.put(new Integer(66), "Log");
        platformOperatorNames.put(new Integer(67), "Mod");
        platformOperatorNames.put(new Integer(68), "Power");
        platformOperatorNames.put(new Integer(69), "Round");
        platformOperatorNames.put(new Integer(70), "Sign");
        platformOperatorNames.put(new Integer(71), "Sin");
        platformOperatorNames.put(new Integer(72), "Sinh");
        platformOperatorNames.put(new Integer(73), "Tan");
        platformOperatorNames.put(new Integer(74), "Tanh");
        platformOperatorNames.put(new Integer(75), "Trunc");
        platformOperatorNames.put(new Integer(76), "Greatest");
        platformOperatorNames.put(new Integer(77), "Least");
        platformOperatorNames.put(new Integer(78), "Add");
        platformOperatorNames.put(new Integer(79), "Subtract");
        platformOperatorNames.put(new Integer(80), "Divide");
        platformOperatorNames.put(new Integer(81), "Multiply");
        platformOperatorNames.put(new Integer(91), "Atan2");
        platformOperatorNames.put(new Integer(95), "Cot");
        platformOperatorNames.put(new Integer(82), "Deref");
        platformOperatorNames.put(new Integer(83), "Ref");
        platformOperatorNames.put(new Integer(84), "RefToHex");
        platformOperatorNames.put(new Integer(85), "Value");
        platformOperatorNames.put(new Integer(106), "Extract");
        platformOperatorNames.put(new Integer(107), "ExtractValue");
        platformOperatorNames.put(new Integer(108), "ExistsNode");
        platformOperatorNames.put(new Integer(109), "GetStringVal");
        platformOperatorNames.put(new Integer(110), "GetNumberVal");
        platformOperatorNames.put(new Integer(111), "IsFragment");
        platformOperatorNames.put(new Integer(124), "MDSYS.SDO_WITHIN_DISTANCE");
        platformOperatorNames.put(new Integer(125), "MDSYS.SDO_RELATE");
        platformOperatorNames.put(new Integer(126), "MDSYS.SDO_FILTER");
        platformOperatorNames.put(new Integer(127), "MDSYS.SDO_NN");
        return platformOperatorNames;
    }

    protected static void initializeRelationOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(4, "=", "equal"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(5, "<>", "notEqual"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(7, "<", "lessThan"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(8, "<=", "lessThanEqual"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(9, ">", "greaterThan"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(10, ">=", "greaterThanEqual"));
        ExpressionOperator.addOperator(ExpressionOperator.like());
        ExpressionOperator.addOperator(ExpressionOperator.likeEscape());
        ExpressionOperator.addOperator(ExpressionOperator.notLike());
        ExpressionOperator.addOperator(ExpressionOperator.between());
        ExpressionOperator.addOperator(ExpressionOperator.exists());
        ExpressionOperator.addOperator(ExpressionOperator.notExists());
    }

    public static ExpressionOperator instring() {
        return ExpressionOperator.simpleTwoArgumentFunction(34, "INSTR");
    }

    public boolean isAggregateOperator() {
        return this.getType() == 3;
    }

    public boolean isComparisonOperator() {
        return this.getType() == 2;
    }

    public boolean isComplete() {
        return this.databaseStrings != null && this.databaseStrings.length != 0;
    }

    public boolean isFunctionOperator() {
        return this.getType() == 5;
    }

    public boolean isLogicalOperator() {
        return this.getType() == 1;
    }

    public static ExpressionOperator isNull() {
        ExpressionOperator result = new ExpressionOperator();
        result.setType(2);
        result.setSelector(17);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement("(");
        ((Vector)v).addElement(" IS NULL)");
        result.printsAs(v);
        result.bePrefix();
        result.printsJavaAs(".isNull()");
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public boolean isOrderOperator() {
        return this.getType() == 4;
    }

    public boolean isPrefix() {
        return this.isPrefix;
    }

    public static ExpressionOperator lastDay() {
        return ExpressionOperator.simpleFunction(49, "LAST_DAY");
    }

    public static ExpressionOperator least() {
        return ExpressionOperator.simpleTwoArgumentFunction(77, "LEAST");
    }

    public static ExpressionOperator leftPad() {
        return ExpressionOperator.simpleThreeArgumentFunction(36, "LPAD");
    }

    public static ExpressionOperator leftTrim() {
        return ExpressionOperator.simpleFunction(37, "LTRIM");
    }

    public static ExpressionOperator leftTrim2() {
        return ExpressionOperator.simpleTwoArgumentFunction(122, "LTRIM");
    }

    public static ExpressionOperator length() {
        return ExpressionOperator.simpleFunction(46, "LENGTH");
    }

    public static ExpressionOperator like() {
        return ExpressionOperator.simpleRelation(11, "LIKE", "like");
    }

    public static ExpressionOperator likeEscape() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(89);
        result.setType(2);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement("(");
        ((Vector)v).addElement(" LIKE ");
        ((Vector)v).addElement(" ESCAPE ");
        ((Vector)v).addElement(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator ln() {
        return ExpressionOperator.simpleFunction(65, "LN");
    }

    public static ExpressionOperator locate() {
        ExpressionOperator expOperator = ExpressionOperator.simpleTwoArgumentFunction(112, "LOCATE");
        int[] argumentIndices = new int[]{1, 0};
        expOperator.setArgumentIndices(argumentIndices);
        return expOperator;
    }

    public static ExpressionOperator locate2() {
        ExpressionOperator expOperator = ExpressionOperator.simpleThreeArgumentFunction(113, "LOCATE");
        int[] argumentIndices = new int[]{1, 0, 2};
        expOperator.setArgumentIndices(argumentIndices);
        return expOperator;
    }

    public static ExpressionOperator log() {
        return ExpressionOperator.simpleFunction(66, "LOG");
    }

    public static ExpressionOperator maximum() {
        return ExpressionOperator.simpleAggregate(22, "MAX", "maximum");
    }

    public static ExpressionOperator minimum() {
        return ExpressionOperator.simpleAggregate(23, "MIN", "minimum");
    }

    public static ExpressionOperator mod() {
        return ExpressionOperator.simpleTwoArgumentFunction(67, "MOD");
    }

    public static ExpressionOperator monthsBetween() {
        return ExpressionOperator.simpleTwoArgumentFunction(50, "MONTHS_BETWEEN");
    }

    public Expression newExpressionForArgument(Expression base, Object singleArgument) {
        if (singleArgument == null) {
            if (this.getSelector() == 4) {
                return base.isNull();
            }
            if (this.getSelector() == 5) {
                return base.notNull();
            }
        }
        Expression node = this.createNode();
        node.create(base, singleArgument, this);
        return node;
    }

    protected Expression createNode() {
        if (this.nodeClass == ClassConstants.FunctionExpression_Class) {
            return new FunctionExpression();
        }
        if (this.nodeClass == ClassConstants.RelationExpression_Class) {
            return new RelationExpression();
        }
        if (this.nodeClass == ClassConstants.LogicalExpression_Class) {
            return new LogicalExpression();
        }
        try {
            Expression node = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    node = (Expression)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getNodeClass()));
                }
                catch (PrivilegedActionException exception) {
                    return null;
                }
            } else {
                node = (Expression)PrivilegedAccessHelper.newInstanceFromClass(this.getNodeClass());
            }
            return node;
        }
        catch (InstantiationException exception) {
            throw new InternalError(exception.toString());
        }
        catch (IllegalAccessException exception) {
            throw new InternalError(exception.toString());
        }
    }

    public Expression newExpressionForArgumentWithBaseLast(Expression base, Object singleArgument) {
        if (singleArgument == null) {
            if (this.getSelector() == 4) {
                return base.isNull();
            }
            if (this.getSelector() == 5) {
                return base.notNull();
            }
        }
        Expression node = this.createNode();
        node.createWithBaseLast(base, singleArgument, this);
        return node;
    }

    public Expression newExpressionForArguments(Expression base, Vector arguments) {
        if (arguments.size() == 1 && arguments.get(0) == null) {
            if (this.getSelector() == 4) {
                return base.isNull();
            }
            if (this.getSelector() == 5) {
                return base.notNull();
            }
        }
        Expression node = this.createNode();
        node.create(base, arguments, this);
        return node;
    }

    public static ExpressionOperator newTime() {
        return ExpressionOperator.simpleThreeArgumentFunction(103, "NEW_TIME");
    }

    public static ExpressionOperator nextDay() {
        return ExpressionOperator.simpleTwoArgumentFunction(51, "NEXT_DAY");
    }

    public static ExpressionOperator notExists() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(88);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("NOT EXISTS ");
        ((Vector)v).addElement(" ");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator notIn() {
        return ExpressionOperator.simpleRelation(14, "NOT IN");
    }

    public static ExpressionOperator notInSubQuery() {
        ExpressionOperator result = new ExpressionOperator();
        result.setType(5);
        result.setSelector(130);
        Vector<String> v = new Vector<String>(1);
        v.addElement(" NOT IN ");
        result.printsAs(v);
        result.bePostfix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator notLike() {
        return ExpressionOperator.simpleRelation(12, "NOT LIKE", "notLike");
    }

    public static ExpressionOperator notNull() {
        ExpressionOperator result = new ExpressionOperator();
        result.setType(2);
        result.setSelector(18);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement("(");
        ((Vector)v).addElement(" IS NOT NULL)");
        result.printsAs(v);
        result.bePrefix();
        result.printsJavaAs(".notNull()");
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator notOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(3);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement("NOT (");
        ((Vector)v).addElement(")");
        result.printsAs(v);
        result.bePrefix();
        result.printsJavaAs(".not()");
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator or() {
        return ExpressionOperator.simpleLogical(2, "OR", "or");
    }

    public static ExpressionOperator power() {
        return ExpressionOperator.simpleTwoArgumentFunction(68, "POWER");
    }

    public void printCollection(Vector items, ExpressionSQLPrinter printer) {
        int dbStringIndex = 0;
        try {
            if (this.isPrefix()) {
                printer.getWriter().write(this.getDatabaseStrings()[0]);
                dbStringIndex = 1;
            } else {
                dbStringIndex = 0;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < items.size(); ++i) {
            int index = 0;
            index = this.argumentIndices == null ? i : this.argumentIndices[i];
            Expression item = (Expression)items.elementAt(index);
            if (this.getSelector() == 83 || this.getSelector() == 82 && item.isObjectExpression()) {
                DatabaseTable alias = ((ObjectExpression)item).aliasForTable(((ObjectExpression)item).getDescriptor().getTables().firstElement());
                printer.printString(alias.getName());
            } else if (this.getSelector() == 19 && item.isExpressionBuilder()) {
                printer.printString("*");
            } else if (this.getType() == 5) {
                item.printSQLWithoutConversion(printer);
            } else {
                item.printSQL(printer);
            }
            if (dbStringIndex >= this.getDatabaseStrings().length) continue;
            printer.printString(this.getDatabaseStrings()[dbStringIndex++]);
        }
    }

    public void printJavaCollection(Vector items, ExpressionJavaPrinter printer) {
        int javaStringIndex = 0;
        for (int i = 0; i < items.size(); ++i) {
            Expression item = (Expression)items.elementAt(i);
            item.printJava(printer);
            if (javaStringIndex >= this.getJavaStrings().length) continue;
            printer.printString(this.getJavaStrings()[javaStringIndex++]);
        }
    }

    public void printDuo(Expression first, Expression second, ExpressionSQLPrinter printer) {
        int dbStringIndex;
        if (this.isPrefix()) {
            printer.printString(this.getDatabaseStrings()[0]);
            dbStringIndex = 1;
        } else {
            dbStringIndex = 0;
        }
        first.printSQL(printer);
        if (dbStringIndex < this.getDatabaseStrings().length) {
            printer.printString(this.getDatabaseStrings()[dbStringIndex++]);
        }
        if (second != null) {
            second.printSQL(printer);
            if (dbStringIndex < this.getDatabaseStrings().length) {
                printer.printString(this.getDatabaseStrings()[dbStringIndex++]);
            }
        }
    }

    public void printJavaDuo(Expression first, Expression second, ExpressionJavaPrinter printer) {
        int javaStringIndex = 0;
        first.printJava(printer);
        if (javaStringIndex < this.getJavaStrings().length) {
            printer.printString(this.getJavaStrings()[javaStringIndex++]);
        }
        if (second != null) {
            second.printJava(printer);
            if (javaStringIndex < this.getJavaStrings().length) {
                printer.printString(this.getJavaStrings()[javaStringIndex]);
            }
        }
    }

    public void printsAs(String s) {
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(1);
        ((Vector)v).addElement(s);
        this.printsAs(v);
    }

    public void printsAs(Vector dbStrings) {
        this.databaseStrings = new String[dbStrings.size()];
        for (int i = 0; i < dbStrings.size(); ++i) {
            this.getDatabaseStrings()[i] = (String)dbStrings.elementAt(i);
        }
    }

    public void printsJavaAs(String s) {
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(1);
        ((Vector)v).addElement(s);
        this.printsJavaAs(v);
    }

    public void printsJavaAs(Vector dbStrings) {
        this.javaStrings = new String[dbStrings.size()];
        for (int i = 0; i < dbStrings.size(); ++i) {
            this.getJavaStrings()[i] = (String)dbStrings.elementAt(i);
        }
    }

    public static ExpressionOperator ref() {
        return ExpressionOperator.simpleFunction(83, "REF");
    }

    public static ExpressionOperator refToHex() {
        return ExpressionOperator.simpleFunction(84, "REFTOHEX");
    }

    public static ExpressionOperator replace() {
        return ExpressionOperator.simpleThreeArgumentFunction(38, "REPLACE");
    }

    public static ExpressionOperator replicate() {
        return ExpressionOperator.simpleTwoArgumentFunction(100, "REPLICATE");
    }

    public static void resetOperators() {
        allOperators = new HashMap();
    }

    public static ExpressionOperator reverse() {
        return ExpressionOperator.simpleFunction(99, "REVERSE");
    }

    public static ExpressionOperator right() {
        return ExpressionOperator.simpleTwoArgumentFunction(101, "RIGHT");
    }

    public static ExpressionOperator rightPad() {
        return ExpressionOperator.simpleThreeArgumentFunction(39, "RPAD");
    }

    public static ExpressionOperator rightTrim() {
        return ExpressionOperator.simpleFunction(40, "RTRIM");
    }

    public static ExpressionOperator rightTrim2() {
        return ExpressionOperator.simpleTwoArgumentFunction(116, "RTRIM");
    }

    public static ExpressionOperator round() {
        return ExpressionOperator.simpleTwoArgumentFunction(69, "ROUND");
    }

    public static ExpressionOperator roundDate() {
        return ExpressionOperator.simpleTwoArgumentFunction(52, "ROUND");
    }

    public void setArgumentIndices(int[] indices) {
        this.argumentIndices = indices;
    }

    public void setNodeClass(Class nodeClass) {
        this.nodeClass = nodeClass;
    }

    public void setSelector(int selector) {
        this.selector = selector;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static ExpressionOperator sign() {
        return ExpressionOperator.simpleFunction(70, "SIGN");
    }

    public static ExpressionOperator simpleAggregate(int selector, String databaseName, String javaName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(3);
        exOperator.setSelector(selector);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement(databaseName + "(");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.printsJavaAs("." + javaName + "()");
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleFunction(int selector, String databaseName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(selector);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement(databaseName + "(");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleFunctionNoParentheses(int selector, String databaseName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(selector);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(1);
        ((Vector)v).addElement(databaseName);
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleFunction(int selector, String databaseName, String javaName) {
        ExpressionOperator exOperator = ExpressionOperator.simpleFunction(selector, databaseName);
        exOperator.printsJavaAs("." + javaName + "()");
        return exOperator;
    }

    public static ExpressionOperator simpleLogical(int selector, String databaseName, String javaName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(1);
        exOperator.setSelector(selector);
        exOperator.printsAs(" " + databaseName + " ");
        exOperator.bePostfix();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("." + javaName + "(");
        ((Vector)v).addElement(")");
        exOperator.printsJavaAs(v);
        exOperator.setNodeClass(ClassConstants.LogicalExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleMath(int selector, String databaseName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(selector);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("(");
        ((Vector)v).addElement(" " + databaseName + " ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleOrdering(int selector, String databaseName, String javaName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(4);
        exOperator.setSelector(selector);
        exOperator.printsAs(" " + databaseName);
        exOperator.bePostfix();
        exOperator.printsJavaAs("." + javaName + "()");
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleRelation(int selector, String databaseName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(2);
        exOperator.setSelector(selector);
        exOperator.printsAs(" " + databaseName + " ");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.RelationExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleRelation(int selector, String databaseName, String javaName) {
        ExpressionOperator exOperator = ExpressionOperator.simpleRelation(selector, databaseName);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("." + javaName + "(");
        ((Vector)v).addElement(")");
        exOperator.printsJavaAs(v);
        return exOperator;
    }

    public static ExpressionOperator simpleThreeArgumentFunction(int selector, String dbString) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(selector);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(4);
        ((Vector)v).addElement(dbString + "(");
        ((Vector)v).addElement(", ");
        ((Vector)v).addElement(", ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleTwoArgumentFunction(int selector, String dbString) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(selector);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).addElement(dbString + "(");
        ((Vector)v).addElement(", ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleLogicalNoParens(int selector, String dbString) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(selector);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).addElement("");
        ((Vector)v).addElement(" " + dbString + " ");
        ((Vector)v).addElement("");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sin() {
        return ExpressionOperator.simpleFunction(71, "SIN");
    }

    public static ExpressionOperator sinh() {
        return ExpressionOperator.simpleFunction(72, "SINH");
    }

    public static ExpressionOperator soundex() {
        return ExpressionOperator.simpleFunction(35, "SOUNDEX");
    }

    public static ExpressionOperator sqrt() {
        return ExpressionOperator.simpleFunction(63, "SQRT");
    }

    public static ExpressionOperator standardDeviation() {
        return ExpressionOperator.simpleAggregate(24, "STDDEV", "standardDeviation");
    }

    public static ExpressionOperator substring() {
        return ExpressionOperator.simpleThreeArgumentFunction(41, "SUBSTR");
    }

    public static ExpressionOperator sum() {
        return ExpressionOperator.simpleAggregate(20, "SUM", "sum");
    }

    public static ExpressionOperator sybaseAddMonthsOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(47);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("DATEADD(month, ");
        ((Vector)v).addElement(", ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseAtan2Operator() {
        return ExpressionOperator.simpleTwoArgumentFunction(91, "ATN2");
    }

    public static ExpressionOperator sybaseInStringOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(34);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("CHARINDEX(");
        ((Vector)v).addElement(", ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseToNumberOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(42);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("CONVERT(NUMERIC, ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseToDateToStringOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(48);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("CONVERT(CHAR, ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseToDateOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(53);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("CONVERT(DATETIME, ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseToCharOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(114);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("CONVERT(CHAR, ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseToCharWithFormatOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(115);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).addElement("CONVERT(CHAR, ");
        ((Vector)v).addElement(",");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseLocateOperator() {
        ExpressionOperator result = ExpressionOperator.simpleTwoArgumentFunction(112, "CHARINDEX");
        int[] argumentIndices = new int[]{1, 0};
        result.setArgumentIndices(argumentIndices);
        return result;
    }

    public static ExpressionOperator tan() {
        return ExpressionOperator.simpleFunction(73, "TAN");
    }

    public static ExpressionOperator tanh() {
        return ExpressionOperator.simpleFunction(74, "TANH");
    }

    public static ExpressionOperator toDate() {
        return ExpressionOperator.simpleFunction(53, "TO_DATE");
    }

    public static ExpressionOperator today() {
        return ExpressionOperator.currentTimeStamp();
    }

    public static ExpressionOperator currentTimeStamp() {
        return ExpressionOperator.simpleFunctionNoParentheses(54, "CURRENT_TIMESTAMP");
    }

    public static ExpressionOperator currentDate() {
        return ExpressionOperator.simpleFunctionNoParentheses(123, "CURRENT_DATE");
    }

    public static ExpressionOperator currentTime() {
        return ExpressionOperator.simpleFunctionNoParentheses(128, "CURRENT_TIME");
    }

    public static ExpressionOperator toLowerCase() {
        return ExpressionOperator.simpleFunction(29, "LOWER", "toLowerCase");
    }

    public static ExpressionOperator toNumber() {
        return ExpressionOperator.simpleFunction(42, "TO_NUMBER");
    }

    public String toString() {
        if (this.getDatabaseStrings() == null || this.getDatabaseStrings().length == 0) {
            return "platform operator - " + ExpressionOperator.getPlatformOperatorName(this.getSelector());
        }
        return "operator " + this.getDatabaseStrings()[0];
    }

    public static ExpressionOperator toUpperCase() {
        return ExpressionOperator.simpleFunction(28, "UPPER", "toUpperCase");
    }

    public static ExpressionOperator translate() {
        return ExpressionOperator.simpleThreeArgumentFunction(43, "TRANSLATE");
    }

    public static ExpressionOperator trim() {
        return ExpressionOperator.simpleFunction(44, "TRIM");
    }

    public static ExpressionOperator trim2() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(121);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).addElement("TRIM(");
        ((Vector)v).addElement(" FROM ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator trunc() {
        return ExpressionOperator.simpleTwoArgumentFunction(75, "TRUNC");
    }

    public static ExpressionOperator truncateDate() {
        return ExpressionOperator.simpleTwoArgumentFunction(102, "TRUNC");
    }

    public static ExpressionOperator value() {
        return ExpressionOperator.simpleFunction(85, "VALUE");
    }

    public static ExpressionOperator variance() {
        return ExpressionOperator.simpleAggregate(25, "VARIANCE", "variance");
    }

    public static ExpressionOperator any() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(118);
        exOperator.printsAs("ANY");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator some() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(119);
        exOperator.printsAs("SOME");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator all() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(120);
        exOperator.printsAs("ALL");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public boolean isAny() {
        return this.selector == 118 || this.selector == 119;
    }

    public boolean isAll() {
        return this.selector == 120;
    }

    public boolean isAnyOrAll() {
        return this.isAny() || this.isAll();
    }
}

