/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.config;

import com.sun.appserv.management.util.misc.TypeCast;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.glassfish.admin.amx.config.NameMappingHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CreateConfigArgSupport {
    private final String mOperationName;
    private final Map<String, Object> mAttrs;
    private final Map<String, String> mProperties;
    private final Map<String, String> mSystemProperties;
    private final Object[] mArgs;

    private static void debug(String s) {
        System.out.println(s);
    }

    public CreateConfigArgSupport(String operationName, Map<String, Object> params) {
        this.mOperationName = operationName;
        this.mArgs = null;
        HashMap<String, Object> attrs = params == null ? new HashMap<String, Object>() : new HashMap<String, Object>(params);
        this.mProperties = this.extractProperties(attrs, "property.");
        this.mSystemProperties = this.extractProperties(attrs, "system-property.");
        this.mAttrs = this.stringifyMap(attrs);
    }

    public CreateConfigArgSupport(String operationName, Object[] argsIn, String[] types) {
        Object lastArg;
        this.mOperationName = operationName;
        if (argsIn == null) {
            throw new IllegalArgumentException();
        }
        boolean haveOptionalAttrsArg = false;
        Map optionalAttrs = null;
        if (argsIn.length >= 1 && ((lastArg = argsIn[argsIn.length - 1]) instanceof Map || types[types.length - 1].equals(Map.class.getName()))) {
            optionalAttrs = TypeCast.checkMap((Map)TypeCast.asMap((Object)lastArg), String.class, Object.class);
            haveOptionalAttrsArg = true;
        }
        if (haveOptionalAttrsArg) {
            this.mArgs = new Object[argsIn.length - 1];
            System.arraycopy(argsIn, 0, this.mArgs, 0, this.mArgs.length);
        } else {
            this.mArgs = argsIn;
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (optionalAttrs != null) {
            attrs.putAll(optionalAttrs);
        }
        this.mProperties = this.extractProperties(attrs, "property.");
        this.mSystemProperties = this.extractProperties(attrs, "system-property.");
        this.mAttrs = this.stringifyMap(attrs);
    }

    public int numArgs() {
        return this.mArgs == null ? 0 : this.mArgs.length;
    }

    public Map<String, Object> getAttrs() {
        return this.mAttrs;
    }

    public Map<String, String> getProperties() {
        return this.mProperties;
    }

    public Map<String, String> getSystemProperties() {
        return this.mSystemProperties;
    }

    public void addExplicitAttrs(String[] names) {
        if (names.length < this.mArgs.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.mArgs.length; ++i) {
            if (this.mAttrs.containsKey(names[i])) {
                throw new IllegalArgumentException();
            }
            this.mAttrs.put(names[i], NameMappingHelper.asStringType(this.mArgs[i]));
        }
    }

    private Map<String, String> extractProperties(Map<String, Object> optionalAttrs, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (optionalAttrs != null) {
            HashSet<String> toRemove = new HashSet<String>();
            for (String key : optionalAttrs.keySet()) {
                if (!key.startsWith(prefix)) continue;
                String propertyName = key.substring(prefix.length(), key.length());
                if (propertyName.length() == 0) {
                    throw new IllegalArgumentException("Property names must be non-zero length");
                }
                result.put(propertyName, "" + optionalAttrs.get(key));
                toRemove.add(key);
            }
            optionalAttrs.keySet().removeAll(toRemove);
        }
        return result;
    }

    private Map<String, Object> stringifyMap(Map<String, Object> m) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (m != null) {
            for (String attrName : m.keySet()) {
                Object value = NameMappingHelper.asStringType(m.get(attrName));
                result.put(attrName, value);
            }
        }
        return result;
    }
}

