/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.management.base.SystemStatus;
import com.sun.appserv.management.base.UnprocessedConfigChange;
import com.sun.appserv.management.config.JDBCConnectionPoolConfig;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;
import org.glassfish.admin.mbeanserver.UnprocessedConfigListener;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemStatusImpl
extends AMXNonConfigImplBase
implements SystemStatus {
    public SystemStatusImpl(ObjectName parentObjectName) {
        super("X-SystemStatus", "X-SystemStatus", parentObjectName, SystemStatus.class, null);
    }

    private Habitat getHabitat() {
        return Globals.getDefaultHabitat();
    }

    public Map<String, Object> pingJDBCConnectionPool(String poolName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Habitat habitat = this.getHabitat();
        ConnectorRuntime connRuntime = null;
        result.put("PingSucceededKey", false);
        if (habitat == null) {
            result.put("MessageKey", "Habitat is null");
            return result;
        }
        JDBCConnectionPoolConfig cfg = (JDBCConnectionPoolConfig)this.getDomainRoot().getDomainConfig().getResourcesConfig().getJDBCConnectionPoolConfigMap().get(poolName);
        if (cfg == null) {
            result.put("MessageKey", "The pool name " + poolName + " does not exist");
            return result;
        }
        try {
            connRuntime = (ConnectorRuntime)habitat.getComponent(ConnectorRuntime.class, null);
        }
        catch (ComponentException e) {
            result.putAll(ExceptionUtil.toMap((Throwable)e));
            result.put("MessageKey", ExceptionUtil.toString((Throwable)e));
            return result;
        }
        try {
            boolean pingable = connRuntime.pingConnectionPool(poolName);
            result.put("PingSucceededKey", pingable);
        }
        catch (ResourceException e) {
            result.putAll(ExceptionUtil.toMap((Throwable)e));
            assert ("MessageKey".equals("MessageKey"));
            return result;
        }
        return result;
    }

    private static void xdebug(String s) {
        System.out.println("### " + s);
    }

    private static String str(Object o) {
        return o == null ? null : "" + o;
    }

    private ObjectName sourceToObjectName(Object source) {
        ObjectName objectName = null;
        if (source instanceof ConfigBean) {
            objectName = ((ConfigBean)source).getObjectName();
        } else if (source instanceof ConfigBeanProxy) {
            objectName = ((ConfigBean)Dom.unwrap((ConfigBeanProxy)((ConfigBeanProxy)source))).getObjectName();
        } else {
            SystemStatusImpl.xdebug("UnprocessedConfigChange.sourceToObjectName: source is something else");
        }
        return objectName;
    }

    public List<Object[]> getRestartRequiredChanges() {
        UnprocessedConfigListener unp = (UnprocessedConfigListener)this.getHabitat().getComponent(UnprocessedConfigListener.class);
        List items = unp.getUnprocessedChangeEvents();
        ArrayList<Object[]> changesObjects = new ArrayList<Object[]>();
        for (UnprocessedChangeEvents events : items) {
            for (UnprocessedChangeEvent event : events.getUnprocessed()) {
                String reason = event.getReason();
                PropertyChangeEvent pce = event.getEvent();
                long when = event.getWhen();
                ObjectName objectName = this.sourceToObjectName(pce.getSource());
                UnprocessedConfigChange ucc = new UnprocessedConfigChange(pce.getPropertyName(), SystemStatusImpl.str(pce.getOldValue()), SystemStatusImpl.str(pce.getNewValue()), (Object)objectName, reason);
                changesObjects.add(ucc.toArray());
            }
        }
        return changesObjects;
    }
}

