/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.glassfish;

import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.glassfish.RegistrationUtil;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.SystemInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="PingService")
@Async
public class PingService
implements Startup,
PostConstruct {
    @Inject
    Logger logger;
    private static final long ONE_DAY = 86400000L;
    private static final String JVM_OPTION = "com.sun.enterprise.registration.PING_TIMER_INTERVAL";
    private static final long TIMER_INTERVAL = Long.getLong("com.sun.enterprise.registration.PING_TIMER_INTERVAL", 10080L) * 60L * 1000L;
    private static final String UC_PING_TIME_STAMP_FILE = ".ping";

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        if (TIMER_INTERVAL <= 0L) {
            this.logger.finer("Ping disabled : com.sun.enterprise.registration.PING_TIMER_INTERVAL <= 0");
            return;
        }
        SystemInfo.UpdateCheckFrequency frequency = SystemInfo.getUpdateCheckFrequency();
        if (frequency.equals((Object)SystemInfo.UpdateCheckFrequency.NEVER)) {
            this.logger.finer("Ping disabled by Update Center option");
            return;
        }
        try {
            RegistrationUtil.synchUUID();
        }
        catch (RegistrationException ex) {
            this.logger.fine("Ping disabled");
            this.logger.fine(ex.getMessage());
            return;
        }
        Timer pingTimer = new Timer("ping", true);
        TimerTask pingTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Image img = RegistrationUtil.getUpdateCenterImage();
                    img.refreshCatalogs();
                    List list = img.getInventory(null, false);
                    ArrayList<String> pkgs = new ArrayList<String>();
                    for (Image.FmriState fs : list) {
                        pkgs.add(fs.fmri.getName());
                    }
                    Image.ImagePlan ip = img.makeInstallPlan(pkgs.toArray(new String[0]));
                    int numUpdates = ip.getProposedFmris().length;
                    int numNewUpdates = 0;
                    long lastPing = PingService.this.getTimeStamp();
                    Date lastPingDate = new Date(PingService.this.getTimeStamp());
                    PingService.this.logger.info("Total number of available updates : " + numUpdates);
                    if (numUpdates > 0) {
                        StringBuffer sb = new StringBuffer();
                        for (Fmri fmri : ip.getProposedFmris()) {
                            Date pkgDate = fmri.getVersion().getPublishDate();
                            if (!pkgDate.after(lastPingDate)) continue;
                            sb.append(System.getProperty("line.separator"));
                            sb.append(fmri.getName() + " " + fmri.getVersion() + " " + fmri.getVersion().getPublishDate());
                            ++numNewUpdates;
                        }
                        if (lastPing > 0L) {
                            PingService.this.logger.info("Number of available updates since " + lastPingDate + " : " + numNewUpdates);
                        }
                        if (numNewUpdates > 0) {
                            if (lastPing > 0L) {
                                sb.insert(0, "Available updates since " + lastPingDate + " : " + System.getProperty("line.separator"));
                            } else {
                                sb.insert(0, "Available updates : " + System.getProperty("line.separator"));
                            }
                            PingService.this.logger.info(sb.toString());
                        }
                    }
                }
                catch (Exception e) {
                    PingService.this.logger.fine(e.getMessage());
                }
                finally {
                    try {
                        PingService.this.setTimeStamp();
                    }
                    catch (Exception ex) {
                        PingService.this.logger.fine(ex.getMessage());
                    }
                }
            }
        };
        long nextPing = 0L;
        try {
            long current = System.currentTimeMillis();
            long lastPing = this.getTimeStamp();
            if (current - lastPing <= 86400000L) {
                nextPing = lastPing - current + 86400000L;
            }
            if (nextPing < 0L) {
                nextPing = 0L;
            }
        }
        catch (Exception ex) {
            this.logger.fine(ex.getMessage());
            nextPing = 0L;
        }
        this.logger.finer("next ping after : " + nextPing / 60000L + " minutes");
        pingTimer.schedule(pingTask, nextPing, TIMER_INTERVAL);
    }

    private void setTimeStamp() throws Exception {
        File f = new File(RegistrationUtil.getRegistrationHome(), UC_PING_TIME_STAMP_FILE);
        if (!f.createNewFile()) {
            f.setLastModified(System.currentTimeMillis());
        }
    }

    private long getTimeStamp() throws Exception {
        File f = new File(RegistrationUtil.getRegistrationHome(), UC_PING_TIME_STAMP_FILE);
        if (!f.exists()) {
            return 0L;
        }
        return f.lastModified();
    }
}

