/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.taglibs.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.web.taglibs.cache.CacheUtil;
import com.sun.enterprise.web.logging.pwc.LogDomains;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class FlushTag
extends TagSupport {
    private String _key;
    private int _scope = 4;
    private static Logger _logger = null;
    private static boolean _debugLog;
    private static ResourceBundle _rb;

    public FlushTag() {
        if (_logger == null) {
            _logger = LogDomains.getLogger(FlushTag.class, "javax.enterprise.system.container.web.pwc");
            _rb = _logger.getResourceBundle();
            _debugLog = _logger.isLoggable(Level.FINE);
        }
    }

    public int doStartTag() throws JspException {
        Cache cache = CacheUtil.getCache(this.pageContext, this._scope);
        if (this._key != null) {
            String key = CacheUtil.generateKey(this._key, this.pageContext);
            cache.remove((Object)key);
            if (_debugLog) {
                _logger.fine("FlushTag: clear [" + key + "]");
            }
        } else {
            cache.clear();
            if (_debugLog) {
                _logger.fine("FlushTag: clear cache");
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this._key = null;
        this._scope = 4;
        return 6;
    }

    public void setKey(String key) {
        if (key != null && key.length() > 0) {
            this._key = key;
        }
    }

    public void setScope(String scope) {
        this._scope = CacheUtil.convertScope(scope);
    }

    static {
        _rb = null;
    }
}

