/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Populator;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.v3.server.XMLStreamReaderFilter;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.GlassFishDocument;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

@Service
public class DomainXml
implements Populator {
    @Inject
    StartupContext context;
    @Inject
    Logger logger;
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry registry;
    @Inject
    XMLInputFactory xif;
    @Inject
    ServerEnvironmentImpl env;

    public void run(ConfigParser parser) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Startup class : " + this.getClass().getName());
        }
        this.habitat.addComponent("parent-class-loader", (Object)new ExistingSingletonInhabitant(ClassLoader.class, (Object)this.registry.getParentClassLoader()));
        try {
            this.parseDomainXml(parser, this.getDomainXml(this.env), this.getInstanceName());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse domain.xml", e);
        }
    }

    protected URL getDomainXml(ServerEnvironmentImpl env) throws IOException {
        return new File(env.getConfigDirPath(), "domain.xml").toURI().toURL();
    }

    protected String getInstanceName() {
        String instanceName = this.context.getArguments().getProperty("-instancename");
        if (instanceName == null || instanceName.length() == 0) {
            instanceName = "server";
        }
        return instanceName;
    }

    protected void parseDomainXml(ConfigParser parser, URL domainXml, String serverName) {
        try {
            DomainXmlReader xsr = new DomainXmlReader(domainXml, serverName);
            parser.parse((XMLStreamReader)xsr, (DomDocument)new GlassFishDocument(this.habitat, Executors.newCachedThreadPool(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    t.setContextClassLoader(((ClassLoaderHierarchy)DomainXml.this.habitat.getComponent(ClassLoaderHierarchy.class)).getCommonClassLoader());
                    return t;
                }
            })));
            xsr.close();
            if (!xsr.foundConfig) {
                throw new RuntimeException("No <config> seen for name=" + xsr.configName);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to parse " + domainXml, e);
        }
    }

    private class DomainXmlReader
    extends XMLStreamReaderFilter {
        private String configName;
        private final URL domainXml;
        private final String serverName;
        private boolean foundConfig;
        private InputStream stream;

        public DomainXmlReader(URL domainXml2, String serverName) throws XMLStreamException {
            try {
                this.stream = domainXml2.openStream();
                this.setParent(DomainXml.this.xif.createXMLStreamReader(domainXml2.toExternalForm(), this.stream));
                this.domainXml = domainXml2;
                this.serverName = serverName;
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        public void close() throws XMLStreamException {
            super.close();
            try {
                this.stream.close();
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        boolean filterOut() throws XMLStreamException {
            this.checkConfigRef(this.getParent());
            if (this.getLocalName().equals("config")) {
                if (this.configName == null) {
                    this.parse2ndTime();
                    assert (this.configName != null);
                }
                if (this.configName.equals(this.getAttributeValue(null, "name"))) {
                    this.foundConfig = true;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void parse2ndTime() throws XMLStreamException {
            DomainXml.this.logger.info("Forced to parse " + this.domainXml + " twice because we didn't see <server> before <config>");
            try {
                InputStream stream = this.domainXml.openStream();
                XMLStreamReader xsr = DomainXml.this.xif.createXMLStreamReader(this.domainXml.toExternalForm(), stream);
                while (this.configName == null) {
                    switch (xsr.next()) {
                        case 1: {
                            this.checkConfigRef(xsr);
                            break;
                        }
                    }
                }
                xsr.close();
                stream.close();
                if (this.configName == null) {
                    throw new RuntimeException(this.domainXml + " contains no <server> element that matches " + this.serverName);
                }
            }
            catch (IOException e) {
                throw new XMLStreamException("Failed to parse " + this.domainXml, e);
            }
        }

        private void checkConfigRef(XMLStreamReader xsr) {
            String ln = xsr.getLocalName();
            if (this.configName == null && ln.equals("server") && this.serverName.equals(xsr.getAttributeValue(null, "name"))) {
                this.configName = xsr.getAttributeValue(null, "config-ref");
                if (this.configName == null) {
                    throw new RuntimeException("<server> element is missing @config-ref at " + this.formatLocation(xsr));
                }
            }
        }

        private String formatLocation(XMLStreamReader xsr) {
            return "line " + xsr.getLocation().getLineNumber() + " at " + xsr.getLocation().getSystemId();
        }
    }
}

