/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.bootstrap;

import com.sun.pkg.client.Image;
import com.sun.pkg.client.SystemInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Bootstrap {
    public static final String WIN_CONFIG_TOOL = "updatetoolconfig.bat";
    public static final String UNIX_CONFIG_TOOL = "updatetoolconfig";
    public static final String WIN_NOTIFIER_APP = "updatetool.exe";
    public static final String UNIX_NOTIFIER_APP = "updatetool";
    private static final String eol = System.getProperty("line.separator");
    static Properties defaultProperties = new Properties();

    public static void main(String[] argv) {
        ResourceBundle rb = ResourceBundle.getBundle("com/sun/pkg/bootstrap/messages");
        try {
            Properties props = new Properties(defaultProperties);
            if (argv.length > 0) {
                String propfilename = argv[0];
                props.load(new FileInputStream(propfilename));
            }
            Bootstrap._main(props);
        }
        catch (UnknownHostException e) {
            System.err.println(MessageFormat.format(rb.getString("unknownhost"), e.getMessage()));
            System.exit(4);
        }
        catch (FileNotFoundException e) {
            System.err.println(MessageFormat.format(rb.getString("cannotfindfile"), e.getMessage()));
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println(MessageFormat.format(rb.getString("ioexception"), e.getMessage()));
            System.exit(3);
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format(rb.getString("unrecognized"), e.getMessage()));
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void main(Properties mainprops, Logger log) throws Exception {
        Properties props = new Properties(defaultProperties);
        props.putAll((Map<?, ?>)mainprops);
        Bootstrap._main(props, log);
    }

    static void _main(Properties props) throws Exception {
        Bootstrap.loadSystemProperties(props);
        ConsoleHandler h = new ConsoleHandler();
        h.setFormatter(new BootstrapFormatter());
        Logger cl = Logger.getLogger("com.sun.pkg.client");
        cl.setUseParentHandlers(false);
        cl.addHandler(h);
        Logger l = Logger.getLogger("com.sun.pkg.bootstrap.Bootstrap", "com/sun/pkg/bootstrap/messages");
        l.setUseParentHandlers(false);
        l.addHandler(h);
        Bootstrap._main(props, l);
    }

    static void _main(Properties props, Logger log) throws Exception {
        String imagedir = props.getProperty("image.path").trim();
        String[] pkg_list = new String[]{"pkg"};
        String[] updatetool_list = new String[]{UNIX_NOTIFIER_APP};
        String proxyStr = props.getProperty("proxy.URL").trim();
        if (proxyStr.length() > 0) {
            log.log(Level.INFO, "proxy", proxyStr);
            URL proxy = new URL(proxyStr);
            try {
                URLConnection uc = proxy.openConnection();
                uc.setDoOutput(true);
                uc.connect();
                uc.getOutputStream().close();
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "badproxy", proxyStr);
                throw ioe;
            }
        }
        SystemInfo.initUpdateToolProps(props);
        Image img = new Image(imagedir);
        img.setProxy(SystemInfo.getProxy());
        if (Boolean.parseBoolean(props.getProperty("optin.usage.reporting").trim())) {
            String uuid = props.getProperty("uuid").trim();
            for (String a : img.getAuthorityNames()) {
                img.setAuthority(a, null, uuid.length() > 0 ? uuid : UUID.randomUUID().toString());
            }
        }
        img.saveConfig();
        img.hideMetaDirectory();
        img.refreshCatalogs();
        log.log(Level.INFO, "imagepath", imagedir);
        if (Boolean.parseBoolean(props.getProperty("install.pkg").trim())) {
            log.log(Level.INFO, "installingpkg");
            img.installPackages(pkg_list);
        }
        if (Boolean.parseBoolean(props.getProperty("install.updatetool").trim())) {
            log.log(Level.INFO, "installingupdatetool");
            img.installPackages(updatetool_list);
        }
        if (Boolean.parseBoolean(props.getProperty("install.updatetool").trim()) && Boolean.parseBoolean(props.getProperty("optin.update.notification").trim()) && Bootstrap.registerNotifier(props, log)) {
            log.log(Level.INFO, "startingnotifier");
            Bootstrap.startNotifier(props, log);
        }
        log.log(Level.INFO, "completemsg");
    }

    public static void loadSystemProperties(Properties props) {
        Enumeration<Object> keys = defaultProperties.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = System.getProperty(name);
            if (value == null) continue;
            props.setProperty(name, value);
        }
    }

    public static void startNotifier(Properties props, Logger log) throws Exception {
        String osname = System.getProperty("os.name");
        String imagedir = props.getProperty("image.path").trim();
        String[] execApp = new String[]{osname.startsWith("Windows") ? new String(imagedir + File.separator + UNIX_NOTIFIER_APP + File.separator + "bin" + File.separator + WIN_NOTIFIER_APP) : new String(imagedir + File.separator + UNIX_NOTIFIER_APP + File.separator + "bin" + File.separator + UNIX_NOTIFIER_APP), new String("--notifier"), new String("--silentstart")};
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(execApp);
        }
        catch (Throwable t) {
            log.log(Level.INFO, "startingnotifierexception", t.getLocalizedMessage());
        }
    }

    public static boolean registerNotifier(Properties props, Logger log) throws Exception {
        String osname = System.getProperty("os.name");
        String imagedir = props.getProperty("image.path").trim();
        String[] execApp = new String[]{osname.startsWith("Windows") ? new String(imagedir + File.separator + UNIX_NOTIFIER_APP + File.separator + "bin" + File.separator + WIN_CONFIG_TOOL) : new String(imagedir + File.separator + UNIX_NOTIFIER_APP + File.separator + "bin" + File.separator + UNIX_CONFIG_TOOL), new String("--register")};
        try {
            File file = new File(execApp[0]);
            if (!file.exists()) {
                log.log(Level.INFO, "registeringnotifierexit3");
                return false;
            }
        }
        catch (SecurityException e) {
            log.log(Level.INFO, "registeringnotifierexception", e.getLocalizedMessage());
            return false;
        }
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(execApp);
            InputStream stdin = proc.getInputStream();
            InputStreamReader isr = new InputStreamReader(stdin);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
            }
            InputStream stderr = proc.getErrorStream();
            isr = new InputStreamReader(stderr);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
            }
            int exitVal = proc.waitFor();
            if (exitVal == 0) {
                log.log(Level.INFO, "registeringnotifierexit0");
            } else if (exitVal == 1) {
                log.log(Level.INFO, "registeringnotifierexit1");
            } else {
                log.log(Level.INFO, "registeringnotifierexit2", exitVal);
            }
            return exitVal <= 0;
        }
        catch (Throwable t) {
            log.log(Level.INFO, "registeringnotifierexception", t.getLocalizedMessage());
            return false;
        }
    }

    static {
        defaultProperties.setProperty("image.path", ".");
        defaultProperties.setProperty("install.pkg", "true");
        defaultProperties.setProperty("install.updatetool", "false");
        defaultProperties.setProperty("proxy.URL", "");
        defaultProperties.setProperty("optin.update.notification", "true");
        defaultProperties.setProperty("optin.usage.reporting", "true");
        defaultProperties.setProperty("uuid", "");
    }

    static class BootstrapFormatter
    extends SimpleFormatter {
        BootstrapFormatter() {
        }

        public String format(LogRecord record) {
            return this.formatMessage(record) + eol;
        }
    }
}

