#
# The contents of this file are subject to the terms
# of the Common Development and Distribution License
# (the License).  You may not use this file except in
# compliance with the License.
#
# You can obtain a copy of the license at
# https://glassfish.dev.java.net/public/CDDLv1.0.html or
# glassfish/bootstrap/legal/CDDLv1.0.txt.
# See the License for the specific language governing
# permissions and limitations under the License.
#
# When distributing Covered Code, include this CDDL
# Header Notice in each file and include the License file
# at glassfish/bootstrap/legal/CDDLv1.0.txt.
# If applicable, add the following below the CDDL Header,
# with the fields enclosed by brackets [] replaced by
# you own identifying information:
# "Portions Copyrighted [year] [name of copyright owner]"
#
# Copyright 2006 Sun Microsystems, Inc. All rights reserved.
#
class Grizzlet
  def service(req, res)
    setup_logger
    #it is rails 2.3.2
    if (defined?ActionController::AbstractRequest).nil?
      #Rack is already available, it is rails 2.3.2 or greater
      env = env_hash
      populate req, env
      env['rack.input'] = $stdin
      env['rack.url_scheme'] = req.scheme
      app = Rack::Builder.new {
        map "/" do
            use Rails::Rack::Static
            run ActionController::Dispatcher.new
        end
        }.to_app
        @status, @headers, @body = app.call(env)
        respond res
    else
      populate req, ENV
      Dispatcher.dispatch
    end
  end

def respond(response)
    if fwd = @headers["Forward"]
      fwd.call(response)
    else
      write_status(response)
      write_headers(response)
      write_body(response)
    end
  end

  def write_status(response)
    response.setStatus(@status.to_i)
  end

  def write_headers(response)
    @headers.each do |k,v|
      case k
      when /^Content-Type$/i
        response.content_type = v.to_s
      when /^Content-Length$/i
        response.content_length = v.to_i
      else
          if v.respond_to?(:each)
            v.each {|val| response.addHeader(k.to_s, val.to_s) }
          else
            response.addHeader(k.to_s, v.to_s)
          end
      end
    end
  end

  def write_body(response)
    stream = response.output_stream
    @body.each do |el|
      stream.write(el.to_java_bytes)
    end
  end

  def populate(request, env)
    add_grizzly_request_attributes(request, env)
    add_variables(request, env)
    add_headers(request, env)
    if !$root.nil? && $root != "/"
      if ActionController::Base.respond_to?('relative_url_root=') #for rails < 2.2
        ActionController::Base.relative_url_root = $root
      else
        ActionController::AbstractRequest.relative_url_root = $root
      end
    end
  end

  def env_hash
    {  "rack.multithread" => true,
      "rack.multiprocess" => false, "rack.run_once" => false }
  end

  def add_grizzly_request_attributes(request, env)
    request.attribute_names.each do |k|
      env[k] = request.getAttribute(k)
    end
  end


  def add_variables(request, env)

      request_uri = request.request_uri
      path_translated = request_uri.sub(/#{$root}/, '')
      path_info = $root != "/" ? path_translated : request_uri
      env["REQUEST_METHOD"] ||= request.method || "GET"
      env["SCRIPT_NAME"] ||= ''
      env["REQUEST_URI"] ||= request_uri || ""
      env["PATH_INFO"] ||= path_info
      env['PATH_TRANSLATED']||= path_translated

      env["QUERY_STRING"] ||= request.query_string || ""
      env["SERVER_NAME"] ||= request.server_name || ""
      env["REMOTE_HOST"] ||= request.remote_host || ""
      env["REMOTE_ADDR"] ||= request.remote_addr || ""
      env["REMOTE_USER"] ||= request.remote_user || ""

      env["SERVER_PORT"] ||= request.server_port.to_s
  end

  def add_headers(request, env)
    env["CONTENT_TYPE"] ||= request.content_type
    env.delete("CONTENT_TYPE") unless env["CONTENT_TYPE"]
    env["CONTENT_LENGTH"] ||= request.content_length.to_s
    env["CONTENT_LENGTH"] = env["CONTENT_LENGTH"].to_s
    env.delete("CONTENT_LENGTH") unless env["CONTENT_LENGTH"] && env["CONTENT_LENGTH"].to_i >= 0
    request.header_names.each do |h|
      next if h =~ /^Content-(Type|Length)$/i
      env["HTTP_#{h.upcase.gsub(/-/, '_')}"] ||= request.getHeader(h)
    end
  end

  def setup_logger
    if defined?(::RAILS_DEFAULT_LOGGER)
      class << ::RAILS_DEFAULT_LOGGER # Make these accessible to wire in the log device
        public :instance_variable_get, :instance_variable_set
      end

      # use config.logger?
      if defined?(ActiveSupport::BufferedLogger) # Rails 2.x
        old_device = ::RAILS_DEFAULT_LOGGER.instance_variable_get "@log"
        old_device.close rescue nil
        ::RAILS_DEFAULT_LOGGER.instance_variable_set "@log", logdev
      else # Rails 1.x
        old_device = ::RAILS_DEFAULT_LOGGER.instance_variable_get "@logdev"
        old_device.close rescue nil
        ::RAILS_DEFAULT_LOGGER.instance_variable_set "@logdev", Logger::LogDevice.new(logdev)
      end
    end
  end

  class GrizzlyLog
      def initialize(context = $logger)
        @context = context
      end
      def puts(msg)
        write msg.to_s
      end
      def write(msg)
        @context.log(msg)
      end
      def flush; end
      def close; end
  end

  def logdev
    @logdev ||= GrizzlyLog.new $logger
  end

  def logger
    @logger ||= begin; require 'logger'; Logger.new(logdev); end
  end

end


Grizzlet.new
