/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.base.AMX;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;
import org.glassfish.admin.amx.mbean.AMXImplBase;
import org.glassfish.admin.amx.mbean.Delegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AMXNonConfigImplBase
extends AMXImplBase {
    private final Set<ObjectName> mChildren = new HashSet<ObjectName>();

    protected AMXNonConfigImplBase(String j2eeType, String fullType, ObjectName parentObjectName, Class<? extends AMX> theInterface, Delegate delegate) {
        super(j2eeType, fullType, parentObjectName, theInterface, delegate);
    }

    @Override
    protected void postRegisterHook(Boolean registrationSucceeded) {
        super.postRegisterHook(registrationSucceeded);
        if (registrationSucceeded.booleanValue()) {
            this.registerChildren();
        }
    }

    @Override
    protected void preDeregisterHook() throws Exception {
        super.preDeregisterHook();
        this.unregisterChildren();
    }

    @Override
    protected void postDeregisterHook() {
    }

    protected void registerChildren() {
    }

    protected synchronized ObjectName registerChild(Object mbean, ObjectName childObjectName) {
        try {
            ObjectName objectName = this.getMBeanServer().registerMBean(mbean, childObjectName).getObjectName();
            return objectName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected synchronized Set<ObjectName> getChildren() {
        return Collections.unmodifiableSet(this.mChildren);
    }

    protected synchronized void unregisterChildren() {
        for (ObjectName childObjectName : this.mChildren) {
            try {
                this.getMBeanServer().unregisterMBean(childObjectName);
                this.debug("unregisterSelfMgrChildren: ", childObjectName, " is now unregistered");
            }
            catch (Exception exception) {}
        }
        this.mChildren.clear();
    }
}

