/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.mappings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.mappings.EISMapping;
import org.eclipse.persistence.eis.mappings.EISOneToManyMappingHelper;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.EISOneToManyQueryBasedValueHolder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.w3c.dom.Element;

public class EISOneToManyMapping
extends CollectionMapping
implements EISMapping {
    protected boolean isForeignKeyRelationship = false;
    protected transient List targetForeignKeyFields;
    protected transient List sourceForeignKeyFields = new ArrayList(1);
    protected transient Map sourceForeignKeysToTargetKeys;
    protected XMLField foreignKeyGroupingElement;

    public EISOneToManyMapping() {
        this.targetForeignKeyFields = new ArrayList(1);
        this.sourceForeignKeysToTargetKeys = new HashMap(2);
        this.deleteAllQuery = new DeleteAllQuery();
    }

    public boolean isEISMapping() {
        return true;
    }

    public void addForeignKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getSourceForeignKeyFields().add(databaseField);
        this.getTargetForeignKeyFields().add(databaseField2);
        this.setIsForeignKeyRelationship(true);
    }

    public void addForeignKeyFieldName(String string, String string2) {
        this.addForeignKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    public boolean isForeignKeyRelationship() {
        return this.isForeignKeyRelationship;
    }

    public void setIsForeignKeyRelationship(boolean bl) {
        this.isForeignKeyRelationship = bl;
    }

    public XMLField getForeignKeyGroupingElement() {
        return this.foreignKeyGroupingElement;
    }

    public void setForeignKeyGroupingElement(String string) {
        this.setForeignKeyGroupingElement(new XMLField(string));
    }

    public boolean hasCustomDeleteAllQuery() {
        return this.hasCustomDeleteAllQuery;
    }

    public ModifyQuery getDeleteAllQuery() {
        if (this.deleteAllQuery == null) {
            this.deleteAllQuery = new DataModifyQuery();
        }
        return this.deleteAllQuery;
    }

    public void setDeleteAllCall(Call call) {
        DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
        deleteAllQuery.setCall(call);
        this.setDeleteAllQuery(deleteAllQuery);
        this.setHasCustomDeleteAllQuery(true);
    }

    public void setForeignKeyGroupingElement(XMLField xMLField) {
        this.foreignKeyGroupingElement = xMLField;
    }

    public List getSourceForeignKeyFields() {
        return this.sourceForeignKeyFields;
    }

    public void setSourceForeignKeyFields(List list) {
        this.sourceForeignKeyFields = list;
        if (list != null && list.size() > 0) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public List getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public void setTargetForeignKeyFields(List list) {
        this.targetForeignKeyFields = list;
    }

    public Map getSourceForeignKeysToTargetKeys() {
        return this.sourceForeignKeysToTargetKeys;
    }

    public void setSourceForeignKeysToTargetKeys(Map map) {
        this.sourceForeignKeysToTargetKeys = map;
        if (map != null && map.keySet() != null && map.keySet().size() > 0) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public boolean hasInverseConstraintDependency() {
        return true;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (!this.hasCustomSelectionQuery()) {
            throw DescriptorException.operationNotSupported("customSelectionQueryRequired");
        }
        if (this.getForeignKeyGroupingElement() == null && this.getSourceForeignKeysToTargetKeys().size() > 1) {
            throw EISException.groupingElementRequired();
        }
        if (this.getForeignKeyGroupingElement() != null) {
            DatabaseField databaseField = this.getDescriptor().buildField(this.getForeignKeyGroupingElement());
            this.setForeignKeyGroupingElement((XMLField)databaseField);
        }
        this.initializeSourceForeignKeysToTargetKeys();
        this.initializeDeleteAllQuery();
    }

    protected void initializeSourceForeignKeysToTargetKeys() throws DescriptorException {
        DatabaseField databaseField;
        int n;
        if (this.getSourceForeignKeyFields().size() != this.getTargetForeignKeyFields().size()) {
            throw DescriptorException.sizeMismatchOfForeignKeys(this);
        }
        for (n = 0; n < this.getTargetForeignKeyFields().size(); ++n) {
            databaseField = this.getReferenceDescriptor().buildField((DatabaseField)this.getTargetForeignKeyFields().get(n));
            this.getTargetForeignKeyFields().set(n, databaseField);
        }
        for (n = 0; n < this.getSourceForeignKeyFields().size(); ++n) {
            databaseField = this.getReferenceDescriptor().buildField((DatabaseField)this.getSourceForeignKeyFields().get(n));
            this.getSourceForeignKeyFields().set(n, databaseField);
            this.getSourceForeignKeysToTargetKeys().put(databaseField, this.getTargetForeignKeyFields().get(n));
        }
    }

    protected void initializeDeleteAllQuery() {
        ((DeleteAllQuery)this.getDeleteAllQuery()).setReferenceClass(this.getReferenceClass());
        if (!this.hasCustomDeleteAllQuery()) {
            this.getDeleteAllQuery().setSelectionCriteria(this.getSelectionCriteria());
        }
    }

    protected boolean mustDeleteReferenceObjectsOneByOne() {
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        return classDescriptor.hasDependencyOnParts() || classDescriptor.usesOptimisticLocking() || classDescriptor.hasInheritance() && classDescriptor.getInheritancePolicy().shouldReadSubclasses() || classDescriptor.hasMultipleTables();
    }

    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery objectLevelModifyQuery) {
        if (this.isForeignKeyRelationship()) {
            return super.shouldObjectModifyCascadeToParts(objectLevelModifyQuery);
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return objectLevelModifyQuery.shouldCascadeAllParts();
    }

    public boolean verifyDelete(Object object, AbstractSession abstractSession) throws DatabaseException {
        if (this.isPrivateOwned()) {
            Object object2 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object3 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object3)) {
                if (abstractSession.verifyDelete(containerPolicy.next(object3, abstractSession))) continue;
                return false;
            }
        }
        return true;
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            WriteObjectQuery writeObjectQuery2;
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            if (this.isPrivateOwned()) {
                writeObjectQuery2 = new InsertObjectQuery();
                writeObjectQuery2.setIsExecutionClone(true);
                writeObjectQuery2.setObject(object3);
                writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
                continue;
            }
            if (writeObjectQuery.getSession().getCommitManager().isCommitInPreModify(object3)) continue;
            writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object3);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    public void postDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        if (this.hasCustomDeleteAllQuery()) {
            this.deleteAll(deleteObjectQuery, object);
        } else {
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object2 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object2)) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
            if (!deleteObjectQuery.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(deleteObjectQuery);
            }
        }
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object object2 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object2)) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
            if (!deleteObjectQuery.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(deleteObjectQuery);
            }
        } else {
            this.deleteAll(deleteObjectQuery);
        }
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            UnitOfWorkChangeSet unitOfWorkChangeSet;
            WriteObjectQuery writeObjectQuery2;
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            if (this.isPrivateOwned()) {
                writeObjectQuery2 = new InsertObjectQuery();
                writeObjectQuery2.setIsExecutionClone(true);
                writeObjectQuery2.setObject(object3);
                writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
                continue;
            }
            if (writeObjectQuery.getSession().getCommitManager().isCommitInPreModify(object3)) continue;
            writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            if (writeObjectQuery.getSession().isUnitOfWork() && (unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet()) != null) {
                writeObjectQuery2.setObjectChangeSet((ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object3));
            }
            writeObjectQuery2.setObject(object3);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    public Object buildAddedElementFromChangeSet(Object object, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)object;
        if (this.shouldMergeCascadeParts(mergeManager)) {
            Object object2 = null;
            object2 = mergeManager.shouldMergeChangesIntoDistributedCache() ? objectChangeSet.getTargetVersionOfSourceObject(mergeManager.getSession(), true) : objectChangeSet.getUnitOfWorkClone();
            mergeManager.mergeChanges(object2, objectChangeSet);
        }
        return this.buildElementFromChangeSet(object, mergeManager);
    }

    public Object buildChangeSet(Object object, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        ObjectBuilder objectBuilder = abstractSession.getDescriptor(object).getObjectBuilder();
        return objectBuilder.createObjectChangeSet(object, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), abstractSession);
    }

    protected Object buildElementFromChangeSet(Object object, MergeManager mergeManager) {
        return ((ObjectChangeSet)object).getTargetVersionOfSourceObject(mergeManager.getSession());
    }

    public Object buildElementFromElement(Object object, MergeManager mergeManager) {
        if (this.shouldMergeCascadeParts(mergeManager)) {
            Object object2;
            ObjectChangeSet objectChangeSet = null;
            if (mergeManager.getSession().isUnitOfWork() && (object2 = (UnitOfWorkChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet()) != null) {
                objectChangeSet = (ObjectChangeSet)((UnitOfWorkChangeSet)object2).getObjectChangeSetForClone(object);
            }
            object2 = mergeManager.getObjectToMerge(object);
            mergeManager.mergeChanges(object2, objectChangeSet);
        }
        return mergeManager.getTargetVersionOfSourceObject(object);
    }

    public Object buildRemovedElementFromChangeSet(Object object, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)object;
        if (!mergeManager.shouldMergeChangesIntoDistributedCache()) {
            mergeManager.registerRemovedNewObjectIfRequired(objectChangeSet.getUnitOfWorkClone());
        }
        return this.buildElementFromChangeSet(object, mergeManager);
    }

    public Object clone() {
        EISOneToManyMapping eISOneToManyMapping = (EISOneToManyMapping)super.clone();
        eISOneToManyMapping.setSourceForeignKeysToTargetKeys((Map)((HashMap)this.getSourceForeignKeysToTargetKeys()).clone());
        return eISOneToManyMapping;
    }

    protected Vector collectFields() {
        if (this.isForeignKeyRelationship()) {
            if (this.getForeignKeyGroupingElement() != null) {
                Vector<XMLField> vector = new Vector<XMLField>(1);
                vector.addElement(this.getForeignKeyGroupingElement());
                return vector;
            }
            return NO_FIELDS;
        }
        return NO_FIELDS;
    }

    public boolean compareElements(Object object, Object object2, AbstractSession abstractSession) {
        Vector vector;
        CacheKey cacheKey;
        if (!this.isForeignKeyRelationship()) {
            return false;
        }
        Vector vector2 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, abstractSession);
        CacheKey cacheKey2 = new CacheKey(vector2);
        if (!cacheKey2.equals(cacheKey = new CacheKey(vector = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object2, abstractSession)))) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return abstractSession.compareObjects(object, object2);
        }
        return true;
    }

    public boolean mapKeyHasChanged(Object object, AbstractSession abstractSession) {
        return !this.getContainerPolicy().compareKeys(object, abstractSession);
    }

    public boolean compareElementsForChange(Object object, Object object2, AbstractSession abstractSession) {
        return object == object2;
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        if (this.isForeignKeyRelationship()) {
            if (this.getAttributeValueFromObject(object) != null && !this.isAttributeValueInstantiatedOrChanged(object)) {
                return null;
            }
            return new EISOneToManyMappingHelper(this).compareForChange(object, object2, objectChangeSet, abstractSession);
        }
        return super.compareForChange(object, object2, objectChangeSet, abstractSession);
    }

    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        if (this.isForeignKeyRelationship()) {
            return new EISOneToManyMappingHelper(this).compareObjects(object, object2, abstractSession);
        }
        return super.compareObjects(object, object2, abstractSession);
    }

    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        new EISOneToManyMappingHelper(this).simpleAddToCollectionChangeRecord(object, object2, objectChangeSet, abstractSession);
    }

    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        new EISOneToManyMappingHelper(this).simpleRemoveFromCollectionChangeRecord(object, object2, objectChangeSet, abstractSession);
    }

    protected void deleteAll(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException {
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(deleteObjectQuery.getSession().getSessionForClass(this.getReferenceClass()), deleteObjectQuery.getTranslationRow(), this.getContainerPolicy().vectorFor(object, deleteObjectQuery.getSession()));
    }

    protected void deleteAll(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        this.deleteAll(deleteObjectQuery, object);
    }

    protected void deleteReferenceObjectsLeftOnDatabase(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object = this.readPrivateOwnedForObject(deleteObjectQuery);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            deleteObjectQuery.getSession().deleteObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    protected XMLRecord extractKeyRowFromReferenceObject(Object object, AbstractSession abstractSession, XMLRecord xMLRecord) {
        Element element = XPathEngine.getInstance().createUnownedElement(xMLRecord.getDOM(), this.getForeignKeyGroupingElement());
        DOMRecord dOMRecord = new DOMRecord(element);
        dOMRecord.setSession(abstractSession);
        for (int i = 0; i < this.getSourceForeignKeyFields().size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getSourceForeignKeyFields().get(i);
            if (object == null) {
                ((AbstractRecord)dOMRecord).add(databaseField, null);
                continue;
            }
            DatabaseField databaseField2 = (DatabaseField)this.getSourceForeignKeysToTargetKeys().get(databaseField);
            Object object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField2, abstractSession);
            ((AbstractRecord)dOMRecord).add(databaseField, object2);
        }
        return dOMRecord;
    }

    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        if (((EISDescriptor)this.getDescriptor()).getDataFormat() == "xml") {
            ((XMLRecord)abstractRecord).setSession(abstractSession);
        }
        ReadQuery readQuery = this.getSelectionQuery();
        if (!this.isForeignKeyRelationship) {
            if (readQuery.isObjectLevelReadQuery() && (objectBuildingQuery.shouldCascadeAllParts() || objectBuildingQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || objectBuildingQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
                readQuery = (ObjectLevelReadQuery)readQuery.clone();
                ((ObjectLevelReadQuery)readQuery).setShouldRefreshIdentityMapResult(objectBuildingQuery.shouldRefreshIdentityMapResult());
                readQuery.setCascadePolicy(objectBuildingQuery.getCascadePolicy());
                readQuery.setQueryId(objectBuildingQuery.getQueryId());
                if (readQuery.shouldMaintainCache()) {
                    readQuery.setShouldMaintainCache(objectBuildingQuery.shouldMaintainCache());
                }
            }
            return this.getIndirectionPolicy().valueFromQuery(readQuery, abstractRecord, objectBuildingQuery.getSession());
        }
        if (this.getIndirectionPolicy().usesIndirection()) {
            EISOneToManyQueryBasedValueHolder eISOneToManyQueryBasedValueHolder = new EISOneToManyQueryBasedValueHolder(this, readQuery, abstractRecord, objectBuildingQuery.getSession());
            return eISOneToManyQueryBasedValueHolder;
        }
        Vector vector = this.getForeignKeyRows(abstractRecord);
        if (vector == null) {
            return null;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object = containerPolicy.containerInstance(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            Iterator<Object> iterator;
            XMLRecord xMLRecord = (XMLRecord)vector.elementAt(i);
            xMLRecord.setSession(abstractSession);
            Object object2 = this.getIndirectionPolicy().valueFromQuery(readQuery, xMLRecord, objectBuildingQuery.getSession());
            if (object2 instanceof Collection) {
                iterator = ((Collection)object2).iterator();
                while (iterator.hasNext()) {
                    containerPolicy.addInto(iterator.next(), object, abstractSession);
                }
                continue;
            }
            if (object2 instanceof Map) {
                iterator = ((Map)object2).values().iterator();
                while (iterator.hasNext()) {
                    containerPolicy.addInto(iterator.next(), object, abstractSession);
                }
                continue;
            }
            containerPolicy.addInto(object2, object, abstractSession);
        }
        if (containerPolicy.sizeFor(object) == 0) {
            return null;
        }
        return object;
    }

    public Vector getForeignKeyRows(AbstractRecord abstractRecord) {
        Vector vector = new Vector();
        if (this.getForeignKeyGroupingElement() == null) {
            Object object;
            if (this.getSourceForeignKeyFields().size() > 0 && (object = abstractRecord.getValues((DatabaseField)this.getSourceForeignKeyFields().get(0))) != null) {
                if (object instanceof Vector) {
                    int n = ((Vector)object).size();
                    for (int i = 0; i < n; ++i) {
                        DOMRecord dOMRecord = new DOMRecord("test");
                        dOMRecord.setSession(((XMLRecord)abstractRecord).getSession());
                        dOMRecord.put(this.getSourceForeignKeyFields().get(0), ((Vector)object).get(i));
                        vector.add(dOMRecord);
                    }
                } else {
                    DOMRecord dOMRecord = new DOMRecord("test");
                    dOMRecord.setSession(((XMLRecord)abstractRecord).getSession());
                    dOMRecord.put(this.getSourceForeignKeyFields().get(0), object);
                    vector.add(dOMRecord);
                }
            }
        } else {
            vector = (Vector)abstractRecord.getValues(this.getForeignKeyGroupingElement());
        }
        return vector;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (!this.isForeignKeyRelationship) {
            return;
        }
        if (this.getSourceForeignKeysToTargetKeys() == null || this.getSourceForeignKeysToTargetKeys().size() == 0) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        AbstractRecord abstractRecord2 = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (abstractRecord2 != null) {
            if (this.getForeignKeyGroupingElement() != null) {
                abstractRecord.put(this.getForeignKeyGroupingElement(), abstractRecord2.getValues(this.getForeignKeyGroupingElement()));
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                DatabaseField databaseField = (DatabaseField)this.getSourceForeignKeyFields().get(0);
                abstractRecord.put(databaseField, abstractRecord2.getValues(databaseField));
            }
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
        Vector<XMLRecord> vector = new Vector<XMLRecord>(containerPolicy.sizeFor(object2));
        if (this.getForeignKeyGroupingElement() != null) {
            Object object3 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object3)) {
                XMLRecord xMLRecord = this.extractKeyRowFromReferenceObject(containerPolicy.next(object3, abstractSession), abstractSession, (XMLRecord)abstractRecord);
                vector.addElement(xMLRecord);
            }
            abstractRecord.add(this.getForeignKeyGroupingElement(), vector);
        } else {
            DatabaseField databaseField = (DatabaseField)this.getSourceForeignKeyFields().get(0);
            DatabaseField databaseField2 = (DatabaseField)this.getSourceForeignKeysToTargetKeys().get(databaseField);
            Object object4 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object4)) {
                Object object5 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(containerPolicy.next(object4, abstractSession), databaseField2, abstractSession);
                abstractRecord.add(databaseField, object5);
            }
        }
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                abstractRecord.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                abstractRecord.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeFromObjectIntoRowForShallowInsert(object, abstractRecord, abstractSession);
        }
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                abstractRecord.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                abstractRecord.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeFromObjectIntoRowForShallowInsertWithChangeRecord(changeRecord, abstractRecord, abstractSession);
        }
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, AbstractRecord abstractRecord) throws DescriptorException {
        Object object;
        Object object2;
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        AbstractSession abstractSession = writeObjectQuery.getSession();
        if (abstractSession.isUnitOfWork() && this.compareObjectsWithoutPrivateOwned(object2 = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), abstractSession), object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getBackupClone(), abstractSession), abstractSession)) {
            return;
        }
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), abstractRecord, abstractSession);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isForeignKeyRelationship()) {
            Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
            this.writeFromObjectIntoRow(object, abstractRecord, abstractSession);
        } else {
            super.writeFromObjectIntoRowWithChangeRecord(changeRecord, abstractRecord, abstractSession);
        }
    }

    public void writeInsertFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                abstractRecord.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                abstractRecord.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeInsertFieldsIntoRow(abstractRecord, abstractSession);
        }
    }

    protected Object executeBatchQueryForPessimisticLocking(DatabaseQuery databaseQuery, UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord) {
        throw DescriptorException.invalidMappingOperation(this, "executeBatchQueryForPessimisticLocking");
    }

    public void setSelectionSQLString(String string) {
        throw DescriptorException.invalidMappingOperation(this, "setSelectionSQLString");
    }

    public void setSelectionCriteria(Expression expression) {
        throw DescriptorException.invalidMappingOperation(this, "setSelectionCriteria");
    }

    public void setUsesBatchReading(boolean bl) {
        throw DescriptorException.invalidMappingOperation(this, "setUsesBatchReading");
    }

    public boolean shouldUseBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "shouldUseBatchReading");
    }

    public void useBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "useBatchReading");
    }

    public void dontUseBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "dontUseBatchReading");
    }

    public void addAscendingOrdering(String string) {
        throw DescriptorException.invalidMappingOperation(this, "addAscendingOrdering");
    }

    public void addDescendingOrdering(String string) {
        throw DescriptorException.invalidMappingOperation(this, "addDescendingOrdering");
    }

    public void setDeleteAllSQLString(String string) {
        throw DescriptorException.invalidMappingOperation(this, "setDeleteAllSQLString");
    }
}

