/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.AppendCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.platform.database.converters.StructConverter;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabasePlatform
extends DatasourcePlatform {
    protected transient Hashtable fieldTypes;
    protected boolean usesNativeSQL;
    protected boolean usesByteArrayBinding;
    protected boolean usesBatchWriting;
    protected boolean shouldBindAllParameters;
    protected boolean shouldCacheAllStatements;
    protected int statementCacheSize;
    protected boolean shouldForceFieldNamesToUpperCase;
    protected boolean shouldTrimStrings;
    protected boolean usesStreamsForBinding;
    protected int stringBindingSize;
    protected boolean usesStringBinding;
    protected int maxBatchWritingSize;
    protected boolean usesJDBCBatchWriting;
    protected boolean usesNativeBatchWriting;
    protected boolean printOuterJoinInWhereClause = false;
    protected int cursorCode;
    protected int transactionIsolation;
    protected boolean supportsAutoCommit;
    protected boolean shouldOptimizeDataConversion;
    protected transient Hashtable classTypes;
    protected static boolean shouldIgnoreCaseOnFieldComparisons = false;
    public static int DEFAULT_MAX_BATCH_WRITING_SIZE = 32000;
    public static int DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE = 100;
    protected String pingSQL;
    protected Map<String, StructConverter> structConverters = null;
    protected Map<Class, StructConverter> typeConverters = null;
    protected boolean useRownumFiltering = true;

    public DatabasePlatform() {
        this.tableQualifier = "";
        this.usesNativeSQL = false;
        this.usesByteArrayBinding = true;
        this.usesStringBinding = false;
        this.stringBindingSize = 255;
        this.shouldTrimStrings = true;
        this.shouldBindAllParameters = true;
        this.shouldCacheAllStatements = false;
        this.shouldOptimizeDataConversion = true;
        this.statementCacheSize = 50;
        this.shouldForceFieldNamesToUpperCase = false;
        this.maxBatchWritingSize = DEFAULT_MAX_BATCH_WRITING_SIZE;
        this.usesJDBCBatchWriting = true;
        this.transactionIsolation = -1;
        this.cursorCode = -10;
        this.supportsAutoCommit = true;
        this.usesNativeBatchWriting = false;
    }

    public Map<String, StructConverter> getStructConverters() {
        return this.structConverters;
    }

    public Map<Class, StructConverter> getTypeConverters() {
        if (this.typeConverters == null) {
            this.typeConverters = new HashMap<Class, StructConverter>();
        }
        return this.typeConverters;
    }

    public void addStructConverter(StructConverter structConverter) {
        if (this.structConverters == null) {
            this.structConverters = new HashMap<String, StructConverter>();
        }
        if (this.typeConverters == null) {
            this.typeConverters = new HashMap<Class, StructConverter>();
        }
        this.structConverters.put(structConverter.getStructName(), structConverter);
        this.typeConverters.put(structConverter.getJavaType(), structConverter);
    }

    public int addBatch(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.addBatch();
        return 0;
    }

    public boolean allowsSizeInProcedureArguments() {
        return true;
    }

    protected void appendBoolean(Boolean bl, Writer writer) throws IOException {
        if (bl.booleanValue()) {
            writer.write("1");
        } else {
            writer.write("0");
        }
    }

    protected void appendByteArray(byte[] byArray, Writer writer) throws IOException {
        writer.write("{b '");
        Helper.writeHexString(byArray, writer);
        writer.write("'}");
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        writer.write("{d '");
        writer.write(Helper.printDate(date));
        writer.write("'}");
    }

    protected void appendNumber(Number number, Writer writer) throws IOException {
        writer.write(number.toString());
    }

    public void appendLiteralToCall(Call call, Writer writer, Object object) {
        if (this.shouldBindLiterals()) {
            this.appendLiteralToCallWithBinding(call, writer, object);
        } else {
            int n = this.appendParameterInternal(call, writer, object);
            for (int i = 0; i < n; ++i) {
                ((DatabaseCall)call).getParameterTypes().addElement(DatabaseCall.LITERAL);
            }
        }
    }

    protected void appendLiteralToCallWithBinding(Call call, Writer writer, Object object) {
        ((DatabaseCall)call).appendLiteral(writer, object);
    }

    @Override
    public void appendParameter(Call call, Writer writer, Object object) {
        this.appendParameterInternal(call, writer, object);
    }

    public int appendParameterInternal(Call call, Writer writer, Object object) {
        int n = 0;
        DatabaseCall databaseCall = (DatabaseCall)call;
        try {
            if (object instanceof Calendar) {
                this.appendCalendar((Calendar)object, writer);
                return n;
            }
            Object object2 = this.convertToDatabaseType(object);
            if (object2 instanceof String) {
                if (this.usesStringBinding() && ((String)object2).length() >= this.getStringBindingSize()) {
                    databaseCall.bindParameter(writer, object2);
                    n = 1;
                } else {
                    this.appendString((String)object2, writer);
                }
            } else if (object2 instanceof Number) {
                this.appendNumber((Number)object2, writer);
            } else if (object2 instanceof Time) {
                this.appendTime((Time)object2, writer);
            } else if (object2 instanceof Timestamp) {
                this.appendTimestamp((Timestamp)object2, writer);
            } else if (object2 instanceof Date) {
                this.appendDate((Date)object2, writer);
            } else if (object2 == null) {
                writer.write("NULL");
            } else if (object2 instanceof Boolean) {
                this.appendBoolean((Boolean)object2, writer);
            } else if (object2 instanceof byte[]) {
                if (this.usesByteArrayBinding()) {
                    databaseCall.bindParameter(writer, object2);
                    n = 1;
                } else {
                    this.appendByteArray((byte[])object2, writer);
                }
            } else if (object2 instanceof Collection) {
                n = this.printValuelist((Collection)object2, databaseCall, writer);
            } else if (this.typeConverters != null && this.typeConverters.containsKey(object2.getClass())) {
                object2 = new BindCallCustomParameter(object2);
                databaseCall.bindParameter(writer, object2);
            } else if (object instanceof Struct || object instanceof Array || object instanceof Ref) {
                databaseCall.bindParameter(writer, object);
                n = 1;
            } else if (object2.getClass() == int[].class) {
                n = this.printValuelist((int[])object2, databaseCall, writer);
            } else if (object2 instanceof AppendCallCustomParameter) {
                ((AppendCallCustomParameter)object2).append(writer);
                n = 1;
            } else if (object2 instanceof BindCallCustomParameter) {
                databaseCall.bindParameter(writer, object2);
                n = 1;
            } else {
                writer.write(object2.toString());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return n;
    }

    protected void appendString(String string, Writer writer) throws IOException {
        writer.write(39);
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\'') {
                writer.write("''");
                continue;
            }
            writer.write(string.charAt(i));
        }
        writer.write(39);
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        writer.write("{t '");
        writer.write(Helper.printTime(time));
        writer.write("'}");
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("{ts '");
        writer.write(Helper.printTimestamp(timestamp));
        writer.write("'}");
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("{ts '");
        writer.write(Helper.printCalendar(calendar));
        writer.write("'}");
    }

    public void autoCommit(DatabaseAccessor databaseAccessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            databaseAccessor.getConnection().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(DatabaseAccessor databaseAccessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            Statement statement = databaseAccessor.getConnection().createStatement();
            try {
                statement.executeUpdate("BEGIN TRANSACTION");
            }
            finally {
                statement.close();
            }
        }
    }

    public DatabaseCall buildCallWithReturning(SQLCall sQLCall, Vector vector) {
        throw ValidationException.platformDoesNotSupportCallWithReturning(Helper.getShortClassName(this));
    }

    protected Hashtable buildClassTypes() {
        Hashtable<String, Class> hashtable = new Hashtable<String, Class>();
        hashtable.put("NUMBER", BigInteger.class);
        hashtable.put("DECIMAL", BigDecimal.class);
        hashtable.put("INTEGER", Integer.class);
        hashtable.put("INT", Integer.class);
        hashtable.put("NUMERIC", Long.class);
        hashtable.put("FLOAT(16)", Float.class);
        hashtable.put("FLOAT(32)", Double.class);
        hashtable.put("NUMBER(1) default 0", Boolean.class);
        hashtable.put("SHORT", Short.class);
        hashtable.put("BYTE", Byte.class);
        hashtable.put("DOUBLE", Double.class);
        hashtable.put("FLOAT", Float.class);
        hashtable.put("SMALLINT", Short.class);
        hashtable.put("BIT", Boolean.class);
        hashtable.put("SMALLINT DEFAULT 0", Boolean.class);
        hashtable.put("VARCHAR", String.class);
        hashtable.put("CHAR", Character.class);
        hashtable.put("LONGVARBINARY", Byte[].class);
        hashtable.put("TEXT", Character[].class);
        hashtable.put("LONGTEXT", Character[].class);
        hashtable.put("MEMO", Character[].class);
        hashtable.put("VARCHAR2", String.class);
        hashtable.put("LONG RAW", Byte[].class);
        hashtable.put("LONG", Character[].class);
        hashtable.put("DATE", Date.class);
        hashtable.put("TIMESTAMP", Timestamp.class);
        hashtable.put("TIME", Time.class);
        hashtable.put("DATETIME", Timestamp.class);
        hashtable.put("BIGINT", BigInteger.class);
        hashtable.put("DOUBLE PRECIS", Double.class);
        hashtable.put("IMAGE", Byte[].class);
        hashtable.put("LONGVARCHAR", Character[].class);
        hashtable.put("REAL", Float.class);
        hashtable.put("TINYINT", Short.class);
        hashtable.put("BLOB", Byte[].class);
        hashtable.put("CLOB", Character[].class);
        return hashtable;
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Number>, FieldTypeDefinition> hashtable = new Hashtable<Class<Number>, FieldTypeDefinition>();
        hashtable.put(Boolean.class, new FieldTypeDefinition("NUMBER", 1));
        hashtable.put(Integer.class, new FieldTypeDefinition("NUMBER", 10));
        hashtable.put(Long.class, new FieldTypeDefinition("NUMBER", 19));
        hashtable.put(Float.class, new FieldTypeDefinition("NUMBER", 12, 5).setLimits(19, 0, 19));
        hashtable.put(Double.class, new FieldTypeDefinition("NUMBER", 10, 5).setLimits(19, 0, 19));
        hashtable.put(Short.class, new FieldTypeDefinition("NUMBER", 5));
        hashtable.put(Byte.class, new FieldTypeDefinition("NUMBER", 3));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("NUMBER", 19));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("NUMBER", 19, 0).setLimits(19, 0, 19));
        hashtable.put(String.class, new FieldTypeDefinition("VARCHAR"));
        hashtable.put(Character.class, new FieldTypeDefinition("CHAR"));
        hashtable.put(Byte[].class, new FieldTypeDefinition("BLOB"));
        hashtable.put(Character[].class, new FieldTypeDefinition("CLOB"));
        hashtable.put(byte[].class, new FieldTypeDefinition("BLOB"));
        hashtable.put(char[].class, new FieldTypeDefinition("CLOB"));
        hashtable.put(Blob.class, new FieldTypeDefinition("BLOB"));
        hashtable.put(Clob.class, new FieldTypeDefinition("CLOB"));
        hashtable.put(Date.class, new FieldTypeDefinition("DATE"));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP"));
        hashtable.put(Time.class, new FieldTypeDefinition("TIME"));
        hashtable.put(Calendar.class, new FieldTypeDefinition("TIMESTAMP"));
        hashtable.put(java.util.Date.class, new FieldTypeDefinition("TIMESTAMP"));
        hashtable.put(Number.class, new FieldTypeDefinition("NUMBER", 10));
        return hashtable;
    }

    public String buildProcedureCallString(StoredProcedureCall storedProcedureCall, AbstractSession abstractSession) {
        int n;
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(storedProcedureCall.getCallHeader(this));
        stringWriter.write(storedProcedureCall.getProcedureName());
        if (this.requiresProcedureCallBrackets()) {
            stringWriter.write("(");
        } else {
            stringWriter.write(" ");
        }
        for (int i = n = storedProcedureCall.getFirstParameterIndexForCallString(); i < storedProcedureCall.getParameters().size(); ++i) {
            String string = (String)storedProcedureCall.getProcedureArgumentNames().elementAt(i);
            Integer n2 = (Integer)storedProcedureCall.getParameterTypes().elementAt(i);
            if (string != null && this.shouldPrintStoredProcedureArgumentNameInCall()) {
                stringWriter.write(this.getProcedureArgumentString());
                stringWriter.write(string);
                stringWriter.write(this.getProcedureArgumentSetter());
            }
            stringWriter.write("?");
            if (storedProcedureCall.isOutputParameterType(n2) && this.requiresProcedureCallOuputToken()) {
                stringWriter.write(" ");
                stringWriter.write(this.getOutputProcedureToken());
            }
            if (i + 1 >= storedProcedureCall.getParameters().size()) continue;
            stringWriter.write(", ");
        }
        storedProcedureCall.setProcedureArgumentNames(null);
        if (this.requiresProcedureCallBrackets()) {
            stringWriter.write(")");
        }
        stringWriter.write(this.getProcedureCallTail());
        return stringWriter.toString();
    }

    public boolean canBuildCallWithReturning() {
        return false;
    }

    public int computeMaxRowsForSQL(int n, int n2) {
        return n2;
    }

    public void commitTransaction(DatabaseAccessor databaseAccessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            databaseAccessor.getConnection().commit();
        }
    }

    public Object convertToDatabaseType(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass() == ClassConstants.UTILDATE) {
            return Helper.timestampFromDate((java.util.Date)object);
        }
        if (object instanceof Character) {
            return ((Character)object).toString();
        }
        if (object instanceof Calendar) {
            return Helper.timestampFromDate(((Calendar)object).getTime());
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object instanceof Character[]) {
            return this.convertObject(object, ClassConstants.STRING);
        }
        if (object instanceof Byte[]) {
            return this.convertObject(object, ClassConstants.APBYTE);
        }
        return object;
    }

    @Override
    public void copyInto(Platform platform) {
        super.copyInto(platform);
        if (!(platform instanceof DatabasePlatform)) {
            return;
        }
        DatabasePlatform databasePlatform = (DatabasePlatform)platform;
        databasePlatform.setShouldTrimStrings(this.shouldTrimStrings());
        databasePlatform.setUsesNativeSQL(this.usesNativeSQL());
        databasePlatform.setUsesByteArrayBinding(this.usesByteArrayBinding());
        databasePlatform.setUsesStringBinding(this.usesStringBinding());
        databasePlatform.setShouldBindAllParameters(this.shouldBindAllParameters());
        databasePlatform.setShouldCacheAllStatements(this.shouldCacheAllStatements());
        databasePlatform.setStatementCacheSize(this.getStatementCacheSize());
        databasePlatform.setTransactionIsolation(this.getTransactionIsolation());
        databasePlatform.setMaxBatchWritingSize(this.getMaxBatchWritingSize());
        databasePlatform.setShouldForceFieldNamesToUpperCase(this.shouldForceFieldNamesToUpperCase());
        databasePlatform.setShouldOptimizeDataConversion(this.shouldOptimizeDataConversion());
        databasePlatform.setStringBindingSize(this.getStringBindingSize());
        databasePlatform.setUsesBatchWriting(this.usesBatchWriting());
        databasePlatform.setUsesJDBCBatchWriting(this.usesJDBCBatchWriting());
        databasePlatform.setUsesNativeBatchWriting(this.usesNativeBatchWriting());
        databasePlatform.setUsesStreamsForBinding(this.usesStreamsForBinding());
    }

    public String getBatchBeginString() {
        return "";
    }

    public String getBatchDelimiterString() {
        return "; ";
    }

    public String getBatchEndString() {
        return "";
    }

    public Connection getConnection(AbstractSession abstractSession, Connection connection) {
        return connection;
    }

    public String getConstraintDeletionString() {
        return " DROP CONSTRAINT ";
    }

    public String getCreateViewString() {
        return "CREATE VIEW ";
    }

    @Override
    public Object getCustomModifyValueForCall(Call call, Object object, DatabaseField databaseField, boolean bl) {
        StructConverter structConverter;
        if (this.typeConverters != null && (structConverter = this.typeConverters.get(databaseField.getType())) != null) {
            Object object2 = object;
            if (object2 == null) {
                object2 = new ObjectRelationalDatabaseField(databaseField);
                ((ObjectRelationalDatabaseField)object2).setSqlType(2002);
                ((ObjectRelationalDatabaseField)object2).setSqlTypeName(structConverter.getStructName());
            }
            return new BindCallCustomParameter(object2);
        }
        return super.getCustomModifyValueForCall(call, object, databaseField, bl);
    }

    public String getProcedureEndString() {
        return this.getBatchEndString();
    }

    public String getProcedureBeginString() {
        return this.getBatchBeginString();
    }

    public String getProcedureAsString() {
        return " AS";
    }

    public Hashtable getClassTypes() {
        if (this.classTypes == null) {
            this.classTypes = this.buildClassTypes();
        }
        return this.classTypes;
    }

    public String getAssignmentString() {
        return "= ";
    }

    public String getCreationInOutputProcedureToken() {
        return this.getInOutputProcedureToken();
    }

    public String getCreationOutputProcedureToken() {
        return this.getOutputProcedureToken();
    }

    public int getCursorCode() {
        return this.cursorCode;
    }

    public FieldTypeDefinition getFieldTypeDefinition(Class clazz) {
        return (FieldTypeDefinition)this.getFieldTypes().get(clazz);
    }

    public Hashtable getFieldTypes() {
        if (this.fieldTypes == null) {
            this.fieldTypes = this.buildFieldTypes();
        }
        return this.fieldTypes;
    }

    public String getFunctionCallHeader() {
        return this.getProcedureCallHeader() + "? " + this.getAssignmentString();
    }

    @Override
    public String getIdentifierQuoteCharacter() {
        return "\"";
    }

    public String getInOutputProcedureToken() {
        return "IN OUT";
    }

    public String getJDBCOuterJoinString() {
        return "{oj ";
    }

    public int getJDBCType(DatabaseField databaseField) {
        if (databaseField != null) {
            if (databaseField.getSqlType() != -1) {
                return databaseField.getSqlType();
            }
            return this.getJDBCType(ConversionManager.getObjectClass(databaseField.getType()));
        }
        return this.getJDBCType((Class)null);
    }

    public int getJDBCType(Class clazz) {
        if (clazz == null) {
            return 12;
        }
        if (clazz == ClassConstants.STRING) {
            return 12;
        }
        if (clazz == ClassConstants.BIGDECIMAL) {
            return 3;
        }
        if (clazz == ClassConstants.BIGINTEGER) {
            return -5;
        }
        if (clazz == ClassConstants.BOOLEAN) {
            return -7;
        }
        if (clazz == ClassConstants.BYTE) {
            return -6;
        }
        if (clazz == ClassConstants.CHAR) {
            return 1;
        }
        if (clazz == ClassConstants.DOUBLE) {
            return 8;
        }
        if (clazz == ClassConstants.FLOAT) {
            return 6;
        }
        if (clazz == ClassConstants.INTEGER) {
            return 4;
        }
        if (clazz == ClassConstants.LONG) {
            return 4;
        }
        if (clazz == ClassConstants.NUMBER) {
            return 3;
        }
        if (clazz == ClassConstants.SHORT) {
            return 5;
        }
        if (clazz == ClassConstants.CALENDAR) {
            return 93;
        }
        if (clazz == ClassConstants.UTILDATE) {
            return 93;
        }
        if (clazz == ClassConstants.TIME) {
            return 92;
        }
        if (clazz == ClassConstants.SQLDATE) {
            return 91;
        }
        if (clazz == ClassConstants.TIMESTAMP || clazz == ClassConstants.UTILDATE) {
            return 93;
        }
        if (clazz == ClassConstants.ABYTE) {
            return -4;
        }
        if (clazz == ClassConstants.APBYTE) {
            return -4;
        }
        if (clazz == ClassConstants.BLOB) {
            return 2004;
        }
        if (clazz == ClassConstants.ACHAR) {
            return -1;
        }
        if (clazz == ClassConstants.APCHAR) {
            return -1;
        }
        if (clazz == ClassConstants.CLOB) {
            return 2005;
        }
        return 12;
    }

    public String getJdbcTypeName(int n) {
        return null;
    }

    public int getMaxBatchWritingSize() {
        return this.maxBatchWritingSize;
    }

    public int getMaxFieldNameSize() {
        return 50;
    }

    public int getMaxForeignKeyNameSize() {
        return this.getMaxFieldNameSize();
    }

    public int getMaxUniqueKeyNameSize() {
        return this.getMaxFieldNameSize();
    }

    public Object getObjectFromResultSet(ResultSet resultSet, int n, int n2, AbstractSession abstractSession) throws SQLException {
        Object object = resultSet.getObject(n);
        if (object != null && this.structConverters != null && n2 == 2002) {
            String string = ((Struct)object).getSQLTypeName();
            if (this.getStructConverters().containsKey(string)) {
                return this.getStructConverters().get(string).convertToObject((Struct)object);
            }
        }
        return object;
    }

    public String getInputProcedureToken() {
        return "";
    }

    public String getOutputProcedureToken() {
        return "OUT";
    }

    public String getPingSQL() {
        return this.pingSQL;
    }

    public String getProcedureArgumentSetter() {
        return " = ";
    }

    public String getProcedureArgumentString() {
        return "";
    }

    public String getProcedureCallHeader() {
        return "EXECUTE PROCEDURE ";
    }

    public String getProcedureCallTail() {
        return "";
    }

    public String getQualifiedSequenceTableName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            return this.getQualifiedName(((TableSequence)this.getDefaultSequence()).getTableName());
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getTableName");
    }

    public String getQualifiedName(String string) {
        if (this.getTableQualifier().equals("")) {
            return string;
        }
        return this.getTableQualifier() + "." + string;
    }

    public String getNoWaitString() {
        return " NOWAIT";
    }

    public String getSelectForUpdateNoWaitString() {
        return this.getSelectForUpdateString() + this.getNoWaitString();
    }

    public String getSelectForUpdateOfString() {
        return " FOR UPDATE OF ";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public String getSelectForUpdateWaitString(Integer n) {
        return " FOR UPDATE";
    }

    public String getSequenceCounterFieldName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            return ((TableSequence)this.getDefaultSequence()).getCounterFieldName();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getCounterFieldName");
    }

    public String getSequenceNameFieldName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            return ((TableSequence)this.getDefaultSequence()).getNameFieldName();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getNameFieldName");
    }

    @Override
    public int getSequencePreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    public String getSequenceTableName() {
        if (this.getDefaultSequence() instanceof TableSequence) {
            return ((TableSequence)this.getDefaultSequence()).getTableName();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getTableName");
    }

    public int getStatementCacheSize() {
        return this.statementCacheSize;
    }

    public String getStoredProcedureParameterPrefix() {
        return "";
    }

    public String getStoredProcedureTerminationToken() {
        return ";";
    }

    public int getStringBindingSize() {
        return this.stringBindingSize;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public boolean isInformixOuterJoin() {
        return false;
    }

    public boolean isLockTimeoutException(DatabaseException databaseException) {
        return false;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MAX_VALUE));
        hashtable.put(Long.class, new Long(Long.MAX_VALUE));
        hashtable.put(Double.class, new Double(Double.MAX_VALUE));
        hashtable.put(Short.class, new Short(Short.MAX_VALUE));
        hashtable.put(Byte.class, new Byte(127));
        hashtable.put(Float.class, new Float(Float.MAX_VALUE));
        hashtable.put(BigInteger.class, new BigInteger("999999999999999999999999999999999999999"));
        hashtable.put(BigDecimal.class, new BigDecimal("99999999999999999999.9999999999999999999"));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MIN_VALUE));
        hashtable.put(Long.class, new Long(Long.MIN_VALUE));
        hashtable.put(Double.class, new Double(Double.MIN_VALUE));
        hashtable.put(Short.class, new Short(Short.MIN_VALUE));
        hashtable.put(Byte.class, new Byte(-128));
        hashtable.put(Float.class, new Float(Float.MIN_VALUE));
        hashtable.put(BigInteger.class, new BigInteger("-99999999999999999999999999999999999999"));
        hashtable.put(BigDecimal.class, new BigDecimal("-9999999999999999999.9999999999999999999"));
        return hashtable;
    }

    public Statement prepareBatchStatement(Statement statement) throws SQLException {
        return statement;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
    }

    public void printFieldNotNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NOT NULL");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void printFieldNullClause(Writer writer) throws ValidationException {
    }

    public int printValuelist(int[] nArray, DatabaseCall databaseCall, Writer writer) throws IOException {
        int n = 0;
        writer.write("(");
        for (int i = 0; i < nArray.length; ++i) {
            n += this.appendParameterInternal(databaseCall, writer, new Integer(nArray[i]));
            if (i >= nArray.length - 1) continue;
            writer.write(", ");
        }
        writer.write(")");
        return n;
    }

    public int printValuelist(Collection collection, DatabaseCall databaseCall, Writer writer) throws IOException {
        int n = 0;
        writer.write("(");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            n += this.appendParameterInternal(databaseCall, writer, iterator.next());
            if (!iterator.hasNext()) continue;
            writer.write(", ");
        }
        writer.write(")");
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object processResultSet(ResultSet resultSet, DatabaseCall databaseCall, PreparedStatement preparedStatement, DatabaseAccessor databaseAccessor, AbstractSession abstractSession) throws SQLException {
        Cloneable cloneable = null;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        abstractSession.startOperationProfile("row fetch", databaseCall.getQuery(), Integer.MAX_VALUE);
        try {
            if (databaseCall.isOneRowReturned()) {
                if (resultSet.next()) {
                    cloneable = databaseAccessor.fetchRow(databaseCall.getFields(), resultSet, resultSetMetaData, abstractSession);
                    if (resultSet.next()) {
                        abstractSession.getEventManager().moreRowsDetected(databaseCall);
                    }
                } else {
                    cloneable = null;
                }
            } else {
                Vector<AbstractRecord> vector = new Vector<AbstractRecord>(20);
                while (resultSet.next()) {
                    vector.addElement(databaseAccessor.fetchRow(databaseCall.getFields(), resultSet, resultSetMetaData, abstractSession));
                }
                cloneable = vector;
            }
            resultSet.close();
        }
        finally {
            abstractSession.endOperationProfile("row fetch", databaseCall.getQuery(), Integer.MAX_VALUE);
        }
        return cloneable;
    }

    public void registerOutputParameter(CallableStatement callableStatement, int n, int n2) throws SQLException {
        callableStatement.registerOutParameter(n, n2);
    }

    public boolean requiresNamedPrimaryKeyConstraints() {
        return false;
    }

    public boolean requiresProcedureBrackets() {
        return false;
    }

    public boolean requiresProcedureCallBrackets() {
        return true;
    }

    public boolean requiresProcedureCallOuputToken() {
        return false;
    }

    public boolean requiresTypeNameToRegisterOutputParameter() {
        return false;
    }

    public void rollbackTransaction(DatabaseAccessor databaseAccessor) throws SQLException {
        if (!this.supportsAutoCommit()) {
            databaseAccessor.getConnection().rollback();
        }
    }

    protected void setClassTypes(Hashtable hashtable) {
        this.classTypes = hashtable;
    }

    public void setCursorCode(int n) {
        this.cursorCode = n;
    }

    protected void setFieldTypes(Hashtable hashtable) {
        this.fieldTypes = hashtable;
    }

    public void setMaxBatchWritingSize(int n) {
        this.maxBatchWritingSize = n;
    }

    public void setSequenceCounterFieldName(String string) {
        if (this.getDefaultSequence() instanceof TableSequence) {
            ((TableSequence)this.getDefaultSequence()).setCounterFieldName(string);
        } else if (!string.equals(new TableSequence().getCounterFieldName())) {
            ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setCounterFieldName");
        }
    }

    public void setSequenceNameFieldName(String string) {
        if (this.getDefaultSequence() instanceof TableSequence) {
            ((TableSequence)this.getDefaultSequence()).setNameFieldName(string);
        } else if (!string.equals(new TableSequence().getNameFieldName())) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setNameFieldName");
        }
    }

    public void setSequenceTableName(String string) {
        if (this.getDefaultSequence() instanceof TableSequence) {
            ((TableSequence)this.getDefaultSequence()).setTableName(string);
        } else if (!string.equals(new TableSequence().getTableName())) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setTableName");
        }
    }

    public void setShouldBindAllParameters(boolean bl) {
        this.shouldBindAllParameters = bl;
    }

    public void setShouldCacheAllStatements(boolean bl) {
        this.shouldCacheAllStatements = bl;
    }

    public void setShouldForceFieldNamesToUpperCase(boolean bl) {
        this.shouldForceFieldNamesToUpperCase = bl;
    }

    public static void setShouldIgnoreCaseOnFieldComparisons(boolean bl) {
        shouldIgnoreCaseOnFieldComparisons = bl;
    }

    public void setShouldOptimizeDataConversion(boolean bl) {
        this.shouldOptimizeDataConversion = bl;
    }

    public void setShouldTrimStrings(boolean bl) {
        this.shouldTrimStrings = bl;
    }

    public void setStatementCacheSize(int n) {
        this.statementCacheSize = n;
    }

    public void setStringBindingSize(int n) {
        this.stringBindingSize = n;
    }

    public void setSupportsAutoCommit(boolean bl) {
        this.supportsAutoCommit = bl;
    }

    public void setTransactionIsolation(int n) {
        this.transactionIsolation = n;
    }

    public void setUsesBatchWriting(boolean bl) {
        this.usesBatchWriting = bl;
    }

    public void setUsesByteArrayBinding(boolean bl) {
        this.usesByteArrayBinding = bl;
    }

    public void setUsesJDBCBatchWriting(boolean bl) {
        this.usesJDBCBatchWriting = bl;
    }

    public void setUsesNativeBatchWriting(boolean bl) {
        this.usesNativeBatchWriting = bl;
    }

    public void setUsesNativeSQL(boolean bl) {
        this.usesNativeSQL = bl;
    }

    public void setShouldUseRownumFiltering(boolean bl) {
        this.useRownumFiltering = bl;
    }

    public void setUsesStreamsForBinding(boolean bl) {
        this.usesStreamsForBinding = bl;
    }

    public void setPrintOuterJoinInWhereClause(boolean bl) {
        this.printOuterJoinInWhereClause = bl;
    }

    public void setUsesStringBinding(boolean bl) {
        this.usesStringBinding = bl;
    }

    public boolean shouldBindAllParameters() {
        return this.shouldBindAllParameters;
    }

    public boolean shouldCacheAllStatements() {
        return this.shouldCacheAllStatements;
    }

    public boolean shouldForceFieldNamesToUpperCase() {
        return this.shouldForceFieldNamesToUpperCase;
    }

    public static boolean shouldIgnoreCaseOnFieldComparisons() {
        return shouldIgnoreCaseOnFieldComparisons;
    }

    public boolean shouldIgnoreException(SQLException sQLException) {
        return false;
    }

    public boolean shouldOptimizeDataConversion() {
        return this.shouldOptimizeDataConversion;
    }

    public boolean shouldPrintStoredProcedureVariablesAfterBeginString() {
        return false;
    }

    public boolean shouldPrintConstraintNameAfter() {
        return false;
    }

    public boolean shouldPrintInOutputTokenBeforeType() {
        return true;
    }

    public boolean shouldPrintOuterJoinInWhereClause() {
        return this.printOuterJoinInWhereClause;
    }

    public boolean shouldPrintInputTokenAtStart() {
        return false;
    }

    public boolean shouldPrintOutputTokenBeforeType() {
        return true;
    }

    public boolean shouldPrintOutputTokenAtStart() {
        return false;
    }

    public boolean shouldPrintStoredProcedureArgumentNameInCall() {
        return true;
    }

    public boolean shouldTrimStrings() {
        return this.shouldTrimStrings;
    }

    @Override
    public boolean shouldUseCustomModifyForCall(DatabaseField databaseField) {
        return databaseField.getSqlType() == 2002 && this.typeConverters != null && this.typeConverters.containsKey(databaseField.getType()) || super.shouldUseCustomModifyForCall(databaseField);
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return true;
    }

    public boolean shouldUseRownumFiltering() {
        return this.useRownumFiltering;
    }

    public boolean supportsAutoCommit() {
        return this.supportsAutoCommit;
    }

    public boolean supportsForeignKeyConstraints() {
        return true;
    }

    public boolean supportsUniqueKeyConstraints() {
        return true;
    }

    public boolean supportsNativeSequenceNumbers() {
        return this.supportsSequenceObjects() || this.supportsIdentity();
    }

    public boolean supportsPrimaryKeyConstraint() {
        return true;
    }

    public boolean supportsStoredFunctions() {
        return false;
    }

    public int executeBatch(Statement statement, boolean bl) throws SQLException {
        statement.executeBatch();
        return 1;
    }

    public Object executeStoredProcedure(DatabaseCall databaseCall, PreparedStatement preparedStatement, DatabaseAccessor databaseAccessor, AbstractSession abstractSession) throws SQLException {
        Vector vector = null;
        ResultSet resultSet = null;
        if (!databaseCall.getReturnsResultSet()) {
            if (databaseCall.isCursorOutputProcedure()) {
                vector = databaseAccessor.executeNoSelect(databaseCall, preparedStatement, abstractSession);
                resultSet = (ResultSet)((CallableStatement)preparedStatement).getObject(databaseCall.getCursorOutIndex());
            } else {
                databaseAccessor.executeDirectNoSelect(preparedStatement, databaseCall, abstractSession);
                vector = databaseAccessor.buildOutputRow((CallableStatement)preparedStatement, databaseCall, abstractSession);
                if (databaseCall.areManyRowsReturned()) {
                    Vector vector2 = new Vector();
                    vector2.add(vector);
                    vector = vector2;
                }
            }
        } else {
            resultSet = databaseAccessor.executeSelect(databaseCall, preparedStatement, abstractSession);
        }
        if (resultSet != null) {
            databaseCall.matchFieldOrder(resultSet, databaseAccessor, abstractSession);
            if (databaseCall.isCursorReturned()) {
                databaseCall.setStatement(preparedStatement);
                databaseCall.setResult(resultSet);
                return databaseCall;
            }
            vector = this.processResultSet(resultSet, databaseCall, preparedStatement, databaseAccessor, abstractSession);
        }
        return vector;
    }

    public void setPingSQL(String string) {
        this.pingSQL = string;
    }

    public void setParameterValueInDatabaseCall(Object object, PreparedStatement preparedStatement, int n, AbstractSession abstractSession) throws SQLException {
        if (object instanceof String) {
            if (this.usesStringBinding() && ((String)object).length() > this.getStringBindingSize()) {
                CharArrayReader charArrayReader = new CharArrayReader(((String)object).toCharArray());
                preparedStatement.setCharacterStream(n, (Reader)charArrayReader, ((String)object).length());
            }
            preparedStatement.setString(n, (String)object);
        } else if (object instanceof Number) {
            Number number = (Number)object;
            if (number instanceof Integer) {
                preparedStatement.setInt(n, number.intValue());
            } else if (number instanceof Long) {
                preparedStatement.setLong(n, number.longValue());
            } else if (number instanceof BigDecimal) {
                preparedStatement.setBigDecimal(n, (BigDecimal)number);
            } else if (number instanceof Double) {
                preparedStatement.setDouble(n, number.doubleValue());
            } else if (number instanceof Float) {
                preparedStatement.setFloat(n, number.floatValue());
            } else if (number instanceof Short) {
                preparedStatement.setShort(n, number.shortValue());
            } else if (number instanceof Byte) {
                preparedStatement.setByte(n, number.byteValue());
            } else if (number instanceof BigInteger) {
                preparedStatement.setBigDecimal(n, new BigDecimal((BigInteger)number));
            } else {
                preparedStatement.setObject(n, object);
            }
        } else if (object instanceof Date) {
            preparedStatement.setDate(n, (Date)object);
        } else if (object instanceof Timestamp) {
            preparedStatement.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Time) {
            preparedStatement.setTime(n, (Time)object);
        } else if (object instanceof Boolean) {
            preparedStatement.setBoolean(n, (Boolean)object);
        } else if (object == null) {
            preparedStatement.setNull(n, this.getJDBCType((Class)null));
        } else if (object instanceof DatabaseField) {
            if (object instanceof ObjectRelationalDatabaseField) {
                ObjectRelationalDatabaseField objectRelationalDatabaseField = (ObjectRelationalDatabaseField)object;
                preparedStatement.setNull(n, objectRelationalDatabaseField.getSqlType(), objectRelationalDatabaseField.getSqlTypeName());
            } else {
                int n2 = this.getJDBCType((DatabaseField)object);
                preparedStatement.setNull(n, n2);
            }
        } else if (object instanceof byte[]) {
            if (this.usesStreamsForBinding()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, ((byte[])object).length);
            } else {
                preparedStatement.setBytes(n, (byte[])object);
            }
        } else if (object instanceof Calendar) {
            preparedStatement.setTimestamp(n, Helper.timestampFromDate(((Calendar)object).getTime()));
        } else if (object.getClass() == ClassConstants.UTILDATE) {
            preparedStatement.setTimestamp(n, Helper.timestampFromDate((java.util.Date)object));
        } else if (object instanceof Character) {
            preparedStatement.setString(n, ((Character)object).toString());
        } else if (object instanceof char[]) {
            preparedStatement.setString(n, new String((char[])object));
        } else if (object instanceof Character[]) {
            preparedStatement.setString(n, (String)this.convertObject(object, ClassConstants.STRING));
        } else if (object instanceof Byte[]) {
            preparedStatement.setBytes(n, (byte[])this.convertObject(object, ClassConstants.APBYTE));
        } else if (object instanceof BindCallCustomParameter) {
            ((BindCallCustomParameter)object).set(this, preparedStatement, n, abstractSession);
        } else if (this.typeConverters != null && this.typeConverters.containsKey(object.getClass())) {
            StructConverter structConverter = this.getTypeConverters().get(object.getClass());
            object = structConverter.convertToStruct(object, this.getConnection(abstractSession, preparedStatement.getConnection()));
            preparedStatement.setObject(n, object);
        } else {
            preparedStatement.setObject(n, object);
        }
    }

    public boolean usesBatchWriting() {
        return this.usesBatchWriting;
    }

    public boolean usesByteArrayBinding() {
        return this.usesByteArrayBinding;
    }

    public boolean usesSequenceTable() {
        return this.getDefaultSequence() instanceof TableSequence;
    }

    public boolean usesJDBCBatchWriting() {
        return this.usesJDBCBatchWriting;
    }

    public boolean usesNativeBatchWriting() {
        return this.usesNativeBatchWriting;
    }

    public boolean usesNativeSQL() {
        return this.usesNativeSQL;
    }

    public boolean usesStreamsForBinding() {
        return this.usesStreamsForBinding;
    }

    public boolean usesStringBinding() {
        return this.usesStringBinding;
    }

    public void writeLOB(DatabaseField databaseField, Object object, ResultSet resultSet, AbstractSession abstractSession) throws SQLException {
    }

    public boolean shouldNativeSequenceUseTransaction() {
        return false;
    }

    public boolean supportsIdentity() {
        return false;
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        return null;
    }

    public ValueReadQuery buildSelectQueryForIdentity(String string, Integer n) {
        return null;
    }

    public boolean supportsSequenceObjects() {
        return false;
    }

    public ValueReadQuery buildSelectQueryForSequenceObject() {
        return null;
    }

    public ValueReadQuery buildSelectQueryForSequenceObject(String string, Integer n) {
        return null;
    }

    @Override
    protected Sequence createPlatformDefaultSequence() {
        return new TableSequence();
    }

    public boolean supportsTempTables() {
        return this.supportsLocalTempTables() || this.supportsGlobalTempTables();
    }

    public boolean supportsLocalTempTables() {
        return false;
    }

    public boolean supportsGlobalTempTables() {
        return false;
    }

    protected String getCreateTempTableSqlPrefix() {
        throw ValidationException.platformDoesNotOverrideGetCreateTempTableSqlPrefix(Helper.getShortClassName(this));
    }

    public DatabaseTable getTempTableForTable(DatabaseTable databaseTable) {
        return new DatabaseTable("TL_" + databaseTable.getName(), databaseTable.getTableQualifier());
    }

    protected String getCreateTempTableSqlSuffix() {
        return "";
    }

    protected String getCreateTempTableSqlBodyForTable(DatabaseTable databaseTable) {
        return null;
    }

    protected boolean shouldTempTableSpecifyPrimaryKeys() {
        return true;
    }

    public void writeCreateTempTableSql(Writer writer, DatabaseTable databaseTable, AbstractSession abstractSession, Collection collection, Collection collection2, Collection collection3) throws IOException {
        String string = this.getCreateTempTableSqlBodyForTable(databaseTable);
        if (string == null) {
            TableDefinition tableDefinition = new TableDefinition();
            Collection collection4 = this.supportsLocalTempTables() ? collection2 : collection3;
            for (DatabaseField databaseField : collection4) {
                FieldDefinition fieldDefinition;
                if (databaseField.getColumnDefinition() != null && databaseField.getColumnDefinition().length() == 0) {
                    Class clazz = ConversionManager.getObjectClass(databaseField.getType());
                    if (clazz == null) {
                        clazz = ClassConstants.STRING;
                    }
                    fieldDefinition = new FieldDefinition(databaseField.getName(), clazz);
                } else {
                    fieldDefinition = new FieldDefinition(databaseField.getName(), databaseField.getColumnDefinition());
                }
                if (collection.contains(databaseField) && this.shouldTempTableSpecifyPrimaryKeys()) {
                    fieldDefinition.setIsPrimaryKey(true);
                }
                tableDefinition.addField(fieldDefinition);
            }
            tableDefinition.setCreationPrefix(this.getCreateTempTableSqlPrefix());
            tableDefinition.setName(this.getTempTableForTable(databaseTable).getQualifiedName());
            tableDefinition.setCreationSuffix(this.getCreateTempTableSqlSuffix());
            tableDefinition.buildCreationWriter(abstractSession, writer);
        } else {
            writer.write(this.getCreateTempTableSqlPrefix());
            writer.write(this.getTempTableForTable(databaseTable).getQualifiedName());
            writer.write(string);
            writer.write(this.getCreateTempTableSqlSuffix());
        }
    }

    public void writeInsertIntoTableSql(Writer writer, DatabaseTable databaseTable, Collection collection) throws IOException {
        writer.write("INSERT INTO ");
        writer.write(this.getTempTableForTable(databaseTable).getQualifiedName());
        writer.write(" (");
        DatabasePlatform.writeFieldsList(writer, collection);
        writer.write(") ");
    }

    public boolean isNullAllowedInSelectClause() {
        return true;
    }

    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable databaseTable, Collection collection, Collection collection2) throws IOException {
        writer.write("UPDATE ");
        String string = databaseTable.getQualifiedName();
        writer.write(string);
        writer.write(" SET (");
        DatabasePlatform.writeFieldsList(writer, collection2);
        writer.write(") = (SELECT ");
        DatabasePlatform.writeFieldsList(writer, collection2);
        writer.write(" FROM ");
        String string2 = this.getTempTableForTable(databaseTable).getQualifiedName();
        writer.write(string2);
        DatabasePlatform.writeAutoJoinWhereClause(writer, null, string, collection);
        writer.write(") WHERE EXISTS(SELECT ");
        writer.write(((DatabaseField)collection.iterator().next()).getName());
        writer.write(" FROM ");
        writer.write(string2);
        DatabasePlatform.writeAutoJoinWhereClause(writer, null, string, collection);
        writer.write(")");
    }

    public void writeDeleteFromTargetTableUsingTempTableSql(Writer writer, DatabaseTable databaseTable, DatabaseTable databaseTable2, Collection collection, Collection collection2) throws IOException {
        writer.write("DELETE FROM ");
        String string = databaseTable2.getQualifiedName();
        writer.write(string);
        writer.write(" WHERE EXISTS(SELECT ");
        writer.write(((DatabaseField)collection.iterator().next()).getName());
        writer.write(" FROM ");
        String string2 = this.getTempTableForTable(databaseTable).getQualifiedName();
        writer.write(string2);
        DatabasePlatform.writeJoinWhereClause(writer, null, string, collection, collection2);
        writer.write(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasFailureCommunicationBased(SQLException sQLException, Connection connection, AbstractSession abstractSession) {
        if (connection == null || this.pingSQL == null) {
            return false;
        }
        Statement statement = null;
        try {
            abstractSession.startOperationProfile("ConnectionHealthTest");
            if (abstractSession.shouldLog(3, "sql")) {
                abstractSession.log(3, "sql", this.getPingSQL(), null, null, false);
            }
            statement = connection.prepareStatement(this.getPingSQL());
            ResultSet resultSet = statement.executeQuery();
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException2) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException3) {
                // empty catch block
            }
            boolean bl = true;
            return bl;
        }
        finally {
            abstractSession.endOperationProfile("ConnectionHealthTest");
        }
        return false;
    }

    public void writeCleanUpTempTableSql(Writer writer, DatabaseTable databaseTable) throws IOException {
        if (this.supportsLocalTempTables()) {
            writer.write("DROP TABLE ");
        } else {
            writer.write("DELETE FROM ");
        }
        writer.write(this.getTempTableForTable(databaseTable).getQualifiedName());
    }

    public boolean shouldAlwaysUseTempStorageForModifyAll() {
        return false;
    }

    public boolean dontBindUpdateAllQueryUsingTempTables() {
        return false;
    }

    protected static void writeFieldsList(Writer writer, Collection collection) throws IOException {
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                writer.write(", ");
            }
            DatabaseField databaseField = (DatabaseField)iterator.next();
            writer.write(databaseField.getName());
        }
    }

    protected static void writeAutoAssignmentSetClause(Writer writer, String string, String string2, Collection collection) throws IOException {
        writer.write(" SET ");
        DatabasePlatform.writeFieldsAutoClause(writer, string, string2, collection, ", ");
    }

    protected static void writeAutoJoinWhereClause(Writer writer, String string, String string2, Collection collection) throws IOException {
        writer.write(" WHERE ");
        DatabasePlatform.writeFieldsAutoClause(writer, string, string2, collection, " AND ");
    }

    protected static void writeFieldsAutoClause(Writer writer, String string, String string2, Collection collection, String string3) throws IOException {
        DatabasePlatform.writeFields(writer, string, string2, collection, collection, string3);
    }

    protected static void writeJoinWhereClause(Writer writer, String string, String string2, Collection collection, Collection collection2) throws IOException {
        writer.write(" WHERE ");
        DatabasePlatform.writeFields(writer, string, string2, collection, collection2, " AND ");
    }

    protected static void writeFields(Writer writer, String string, String string2, Collection collection, Collection collection2, String string3) throws IOException {
        boolean bl = true;
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                writer.write(string3);
            }
            if (string != null) {
                writer.write(string);
                writer.write(".");
            }
            String string4 = ((DatabaseField)iterator.next()).getName();
            writer.write(string4);
            writer.write(" = ");
            if (string2 != null) {
                writer.write(string2);
                writer.write(".");
            }
            String string5 = ((DatabaseField)iterator2.next()).getName();
            writer.write(string5);
        }
    }

    public boolean shouldPrintFieldIdentityClause(AbstractSession abstractSession, String string) {
        if (!this.supportsIdentity()) {
            return false;
        }
        if (abstractSession.getSequencing() == null || abstractSession.getSequencing().whenShouldAcquireValueForAll() == -1) {
            return false;
        }
        boolean bl = false;
        DatabaseField databaseField = new DatabaseField(string);
        for (ClassDescriptor classDescriptor : abstractSession.getDescriptors().values()) {
            if (!classDescriptor.usesSequenceNumbers() || !classDescriptor.getSequenceNumberField().equals(databaseField)) continue;
            String string2 = classDescriptor.getSequenceNumberName();
            Sequence sequence = this.getSequence(string2);
            bl = sequence.shouldAcquireValueAfterInsert();
            break;
        }
        return bl;
    }

    public void printFieldTypeSize(Writer writer, FieldDefinition fieldDefinition, FieldTypeDefinition fieldTypeDefinition, boolean bl) throws IOException {
        this.printFieldTypeSize(writer, fieldDefinition, fieldTypeDefinition);
    }

    protected void printFieldTypeSize(Writer writer, FieldDefinition fieldDefinition, FieldTypeDefinition fieldTypeDefinition) throws IOException {
        writer.write(fieldTypeDefinition.getName());
        if (fieldTypeDefinition.isSizeAllowed() && (fieldDefinition.getSize() != 0 || fieldTypeDefinition.isSizeRequired())) {
            writer.write("(");
            if (fieldDefinition.getSize() == 0) {
                writer.write(new Integer(fieldTypeDefinition.getDefaultSize()).toString());
            } else {
                writer.write(new Integer(fieldDefinition.getSize()).toString());
            }
            if (fieldDefinition.getSubSize() != 0) {
                writer.write(",");
                writer.write(new Integer(fieldDefinition.getSubSize()).toString());
            } else if (fieldTypeDefinition.getDefaultSubSize() != 0) {
                writer.write(",");
                writer.write(new Integer(fieldTypeDefinition.getDefaultSubSize()).toString());
            }
            writer.write(")");
        }
    }

    public void printFieldUnique(Writer writer, boolean bl) throws IOException {
        this.printFieldUnique(writer);
    }

    protected void printFieldUnique(Writer writer) throws IOException {
        if (this.supportsPrimaryKeyConstraint()) {
            writer.write(" UNIQUE");
        }
    }

    public void writeParameterMarker(Writer writer, ParameterExpression parameterExpression) throws IOException {
        writer.write("?");
    }

    public Array createArray(String string, Object[] objectArray, AbstractSession abstractSession, Connection connection) throws SQLException {
        Connection connection2 = this.getConnection(abstractSession, connection);
        return this.createArray(string, objectArray, connection2);
    }

    public Struct createStruct(String string, Object[] objectArray, AbstractSession abstractSession, Connection connection) throws SQLException {
        Connection connection2 = this.getConnection(abstractSession, connection);
        return this.createStruct(string, objectArray, connection2);
    }

    public Array createArray(String string, Object[] objectArray, Connection connection) throws SQLException {
        return null;
    }

    public Struct createStruct(String string, Object[] objectArray, Connection connection) throws SQLException {
        return null;
    }

    public boolean isXDBDocument(Object object) {
        return false;
    }

    public boolean shouldBindLiterals() {
        return true;
    }

    public Object getRefValue(Ref ref, Connection connection) throws SQLException {
        return ref.getObject();
    }

    public Object getRefValue(Ref ref, AbstractSession abstractSession, Connection connection) throws SQLException {
        Connection connection2 = this.getConnection(abstractSession, connection);
        return this.getRefValue(ref, connection2);
    }

    public void printSQLSelectStatement(DatabaseCall databaseCall, ExpressionSQLPrinter expressionSQLPrinter, SQLSelectStatement sQLSelectStatement) {
        databaseCall.setFields(sQLSelectStatement.printSQL(expressionSQLPrinter));
    }

    public boolean shouldPrintLockingClauseAfterWhereClause() {
        return true;
    }

    public boolean shouldPrintAliasForUpdate() {
        return false;
    }

    public Writer buildSequenceObjectCreationWriter(Writer writer, String string, int n, int n2) throws IOException {
        return writer;
    }

    public Writer buildSequenceObjectDeletionWriter(Writer writer, String string) throws IOException {
        return writer;
    }

    public Writer buildSequenceObjectAlterIncrementWriter(Writer writer, String string, int n) throws IOException {
        return writer;
    }

    public boolean isAlterSequenceObjectSupported() {
        return false;
    }
}

