/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.sql.Connection;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.ConnectionCustomizer;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.sequencing.SequencingCallback;
import org.eclipse.persistence.internal.sequencing.SequencingCallbackFactory;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.sessions.Login;

public abstract class DatasourceAccessor
implements Accessor {
    protected Object datasourceConnection;
    protected Login login;
    protected int callCount = 0;
    public int storedProcedureStatementsCount;
    public int readStatementsCount;
    public int writeStatementsCount;
    public static final String READ_STATEMENTS_COUNT_PROPERTY = "Read_Statements_Count_Property";
    public static final String WRITE_STATEMENTS_COUNT_PROPERTY = "Write_Statements_Count_Property";
    public static final String STOREDPROCEDURE_STATEMENTS_COUNT_PROPERTY = "StoredProcedure_Statements_Count_Property";
    protected boolean isInTransaction = false;
    protected boolean isConnected = false;
    protected DatasourcePlatform platform;
    protected boolean isValid = true;
    protected transient SequencingCallback sequencingCallback;
    protected transient AbstractSession currentSession;
    protected boolean usesExternalConnectionPooling;
    public static boolean shouldCheckConnection = false;
    protected ConnectionCustomizer customizer;

    public Object clone() {
        try {
            DatasourceAccessor datasourceAccessor = (DatasourceAccessor)super.clone();
            if (datasourceAccessor.customizer != null) {
                datasourceAccessor.customizer.setAccessor(datasourceAccessor);
            }
            return datasourceAccessor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone not supported");
        }
    }

    public void closeJTSConnection() {
        if (this.usesExternalTransactionController()) {
            this.isInTransaction = false;
            if (this.usesExternalConnectionPooling) {
                this.closeConnection();
            }
        }
    }

    protected void setIsInTransaction(boolean bl) {
        this.isInTransaction = bl;
    }

    public void setIsValid(boolean bl) {
        this.isValid = bl;
    }

    public boolean isInTransaction() {
        return this.isInTransaction;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean usesExternalConnectionPooling() {
        return this.usesExternalConnectionPooling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(AbstractSession abstractSession) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (abstractSession.isExclusiveConnectionRequired() && !this.isInTransaction && this.usesExternalConnectionPooling) {
                this.closeConnection();
            }
            this.isInTransaction = true;
            return;
        }
        abstractSession.log(2, "transaction", "begin_transaction", (Object[])null, this);
        try {
            abstractSession.startOperationProfile("transactions");
            this.incrementCallCount(abstractSession);
            this.basicBeginTransaction(abstractSession);
            this.isInTransaction = true;
        }
        finally {
            this.decrementCallCount();
            abstractSession.endOperationProfile("transactions");
        }
    }

    protected abstract void basicBeginTransaction(AbstractSession var1);

    protected abstract void basicCommitTransaction(AbstractSession var1);

    protected abstract void basicRollbackTransaction(AbstractSession var1);

    public synchronized void decrementCallCount() {
        int n;
        if ((n = this.callCount--) <= 0) {
            return;
        }
        if (!(!this.usesExternalConnectionPooling || this.isInTransaction || this.currentSession != null && this.currentSession.isExclusiveConnectionRequired() || n != 1)) {
            try {
                this.closeConnection();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    public synchronized void incrementCallCount(AbstractSession abstractSession) {
        ++this.callCount;
        if (this.callCount == 1) {
            if (this.login == null) {
                throw DatabaseException.databaseAccessorNotConnected();
            }
            if (this.datasourceConnection != null) {
                if (shouldCheckConnection && !this.isConnected()) {
                    if (this.isInTransaction) {
                        throw DatabaseException.databaseAccessorNotConnected();
                    }
                    this.reconnect(abstractSession);
                }
            } else if (this.usesExternalConnectionPooling) {
                this.reconnect(abstractSession);
                abstractSession.postConnectExternalConnection(this);
                this.currentSession = abstractSession;
            } else {
                throw DatabaseException.databaseAccessorNotConnected();
            }
        }
    }

    public void reset() {
        this.readStatementsCount = 0;
        this.writeStatementsCount = 0;
        this.storedProcedureStatementsCount = 0;
    }

    protected void connectInternal(Login login, AbstractSession abstractSession) throws DatabaseException {
        this.datasourceConnection = login.connectToDatasource(this, abstractSession);
        this.isConnected = true;
        if (this.customizer != null) {
            this.customizer.customize();
        }
    }

    protected void setIsConnected(boolean bl) {
        this.isConnected = bl;
    }

    protected void setCallCount(int n) {
        this.callCount = n;
    }

    public int getCallCount() {
        return this.callCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(AbstractSession abstractSession) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (!abstractSession.isSynchronized()) {
                this.isInTransaction = false;
                if (this.usesExternalConnectionPooling) {
                    this.currentSession = abstractSession;
                    this.closeConnection();
                }
            }
            return;
        }
        abstractSession.log(2, "transaction", "commit_transaction", (Object[])null, this);
        try {
            abstractSession.startOperationProfile("transactions");
            this.incrementCallCount(abstractSession);
            this.basicCommitTransaction(abstractSession);
            if (this.sequencingCallback != null) {
                this.sequencingCallback.afterCommit(this);
            }
            this.isInTransaction = false;
        }
        finally {
            this.sequencingCallback = null;
            this.decrementCallCount();
            abstractSession.endOperationProfile("transactions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Login login, AbstractSession abstractSession) throws DatabaseException {
        abstractSession.startOperationProfile("connect");
        abstractSession.incrementProfile("ConnectCalls");
        try {
            if (abstractSession.shouldLog(4, "connection")) {
                abstractSession.log(4, "connection", "connecting", new Object[]{login}, this);
            }
            this.setLogin(login);
            this.setDatasourcePlatform((DatasourcePlatform)abstractSession.getDatasourceLogin().getDatasourcePlatform());
            this.createCustomizer(abstractSession);
            try {
                this.connectInternal(login, abstractSession);
                this.isInTransaction = false;
            }
            catch (RuntimeException runtimeException) {
                abstractSession.handleSevere(runtimeException);
            }
            abstractSession.getEventManager().postConnect(this);
            this.incrementCallCount(abstractSession);
            try {
                this.buildConnectLog(abstractSession);
            }
            finally {
                this.decrementCallCount();
            }
        }
        finally {
            abstractSession.endOperationProfile("connect");
        }
    }

    protected abstract void closeDatasourceConnection();

    protected abstract Object basicExecuteCall(Call var1, AbstractRecord var2, AbstractSession var3);

    protected abstract void buildConnectLog(AbstractSession var1);

    public Login getLogin() {
        return this.login;
    }

    protected void setLogin(Login login) {
        this.login = login;
        this.usesExternalConnectionPooling = login.shouldUseExternalConnectionPooling();
    }

    public void disconnect(AbstractSession abstractSession) throws DatabaseException {
        abstractSession.log(4, "connection", "disconnect", (Object[])null, this);
        if (this.datasourceConnection == null) {
            return;
        }
        abstractSession.incrementProfile("DisconnectCalls");
        abstractSession.startOperationProfile("connect");
        this.releaseCustomizer();
        this.closeDatasourceConnection();
        this.datasourceConnection = null;
        this.isInTransaction = true;
        abstractSession.endOperationProfile("connect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        try {
            if (this.datasourceConnection != null) {
                if (this.isDatasourceConnected()) {
                    if (this.currentSession != null) {
                        this.currentSession.preDisconnectExternalConnection(this);
                    }
                    if (this.customizer != null && this.customizer.isActive()) {
                        this.customizer.clear();
                    }
                    this.closeDatasourceConnection();
                }
                this.datasourceConnection = null;
            }
        }
        catch (DatabaseException databaseException) {
            this.datasourceConnection = null;
        }
        finally {
            this.currentSession = null;
        }
    }

    public Object executeCall(Call call, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DatabaseException {
        if (this.login == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        if (abstractSession.shouldLog(3, "sql")) {
            abstractSession.log(3, "sql", call.getLogString(this), null, this, false);
        }
        Object object = this.basicExecuteCall(call, abstractRecord, abstractSession);
        return object;
    }

    public void reestablishConnection(AbstractSession abstractSession) throws DatabaseException {
        if (abstractSession.shouldLog(4, "connection")) {
            Object[] objectArray = new Object[]{this.getLogin()};
            abstractSession.log(4, "connection", "reconnecting", objectArray, this);
        }
        this.reestablishCustomizer();
        this.reconnect(abstractSession);
        this.isInTransaction = false;
        this.isValid = true;
        abstractSession.getEventManager().postConnect(this);
    }

    protected void reconnect(AbstractSession abstractSession) throws DatabaseException {
        abstractSession.log(1, "connection", "reconnecting_to_external_connection_pool");
        abstractSession.startOperationProfile("connect");
        this.connectInternal(this.login, abstractSession);
        abstractSession.endOperationProfile("connect");
    }

    public DatasourcePlatform getDatasourcePlatform() {
        return this.platform;
    }

    public void setDatasourcePlatform(DatasourcePlatform datasourcePlatform) {
        this.platform = datasourcePlatform;
    }

    public Object getDatasourceConnection() {
        return this.datasourceConnection;
    }

    public Connection getConnection() {
        return (Connection)this.datasourceConnection;
    }

    public Vector getColumnInfo(String string, String string2, String string3, String string4, AbstractSession abstractSession) throws DatabaseException {
        return new Vector();
    }

    public int getReadStatementsCount() {
        return this.readStatementsCount;
    }

    public int getWriteStatementsCount() {
        return this.writeStatementsCount;
    }

    public int getStoredProcedureStatementsCount() {
        return this.storedProcedureStatementsCount;
    }

    public Vector getTableInfo(String string, String string2, String string3, String[] stringArray, AbstractSession abstractSession) throws DatabaseException {
        return new Vector();
    }

    protected void setDatasourceConnection(Object object) {
        this.datasourceConnection = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(AbstractSession abstractSession) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (!abstractSession.isSynchronized()) {
                this.isInTransaction = false;
                if (this.usesExternalConnectionPooling) {
                    this.currentSession = abstractSession;
                    this.closeConnection();
                }
            }
            return;
        }
        abstractSession.log(2, "transaction", "rollback_transaction", (Object[])null, this);
        try {
            abstractSession.startOperationProfile("transactions");
            this.incrementCallCount(abstractSession);
            this.basicRollbackTransaction(abstractSession);
        }
        finally {
            this.isInTransaction = false;
            this.sequencingCallback = null;
            this.decrementCallCount();
            abstractSession.endOperationProfile("transactions");
        }
    }

    public boolean usesExternalTransactionController() {
        if (this.login == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        return this.login.shouldUseExternalTransactionController();
    }

    public boolean isConnected() {
        if (this.datasourceConnection == null && this.login == null) {
            return false;
        }
        if (this.usesExternalConnectionPooling) {
            return true;
        }
        if (this.datasourceConnection == null) {
            return false;
        }
        return this.isDatasourceConnected();
    }

    protected abstract boolean isDatasourceConnected();

    public void flushSelectCalls(AbstractSession abstractSession) {
    }

    public void writesCompleted(AbstractSession abstractSession) {
    }

    public SequencingCallback getSequencingCallback(SequencingCallbackFactory sequencingCallbackFactory) {
        if (this.sequencingCallback == null) {
            this.sequencingCallback = sequencingCallbackFactory.createSequencingCallback();
        }
        return this.sequencingCallback;
    }

    public void createCustomizer(AbstractSession abstractSession) {
        if (this.customizer == null) {
            ConnectionCustomizer connectionCustomizer = this.platform != null ? this.platform.createConnectionCustomizer(this, abstractSession) : ((DatasourcePlatform)abstractSession.getDatasourcePlatform()).createConnectionCustomizer(this, abstractSession);
            if (connectionCustomizer != null) {
                this.setCustomizer(connectionCustomizer);
            }
        } else {
            if (this.customizer.getSession() == abstractSession) {
                return;
            }
            ConnectionCustomizer connectionCustomizer = this.platform != null ? this.platform.createConnectionCustomizer(this, abstractSession) : ((DatasourcePlatform)abstractSession.getDatasourcePlatform()).createConnectionCustomizer(this, abstractSession);
            if (connectionCustomizer == null) {
                if (this.customizer.isActive()) {
                    this.customizer.clear();
                }
                connectionCustomizer = ConnectionCustomizer.createEmptyCustomizer(abstractSession);
                connectionCustomizer.setPrevCustomizer(this.customizer);
                this.customizer = connectionCustomizer;
            } else if (!connectionCustomizer.equals(this.customizer)) {
                if (this.customizer.isActive()) {
                    this.customizer.clear();
                }
                connectionCustomizer.setPrevCustomizer(this.customizer);
                this.setCustomizer(connectionCustomizer);
            }
        }
    }

    protected void setCustomizer(ConnectionCustomizer connectionCustomizer) {
        this.customizer = connectionCustomizer;
        if (this.getDatasourceConnection() != null) {
            this.customizer.customize();
        }
    }

    public void releaseCustomizer() {
        if (this.customizer != null) {
            if (this.customizer.isActive()) {
                this.customizer.clear();
            }
            this.customizer = null;
        }
    }

    public void releaseCustomizer(AbstractSession abstractSession) {
        if (this.customizer != null && this.customizer.getSession() == abstractSession) {
            if (this.customizer.isActive()) {
                this.customizer.clear();
            }
            if (this.customizer.getPrevCustomizer() == null) {
                this.customizer = null;
            } else {
                this.setCustomizer(this.customizer.getPrevCustomizer());
            }
        }
    }

    protected void reestablishCustomizer() {
        if (this.customizer != null && this.customizer.isActive()) {
            if (this.isValid()) {
                this.customizer.clear();
            } else {
                AbstractSession abstractSession = (AbstractSession)this.customizer.getSession();
                this.customizer = this.customizer.getPrevCustomizer();
                this.createCustomizer(abstractSession);
            }
        }
    }
}

