/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public class ExpressionSQLPrinter {
    protected AbstractSession session;
    protected DatabasePlatform platform;
    protected SQLCall call;
    protected AbstractRecord translationRow;
    protected boolean shouldPrintQualifiedNames;
    protected Writer writer;
    protected boolean requiresDistinct;
    protected boolean isFirstElementPrinted;

    public ExpressionSQLPrinter(AbstractSession abstractSession, AbstractRecord abstractRecord, SQLCall sQLCall, boolean bl, ExpressionBuilder expressionBuilder) {
        this.session = abstractSession;
        this.translationRow = abstractRecord;
        this.call = sQLCall;
        this.shouldPrintQualifiedNames = bl;
        this.platform = expressionBuilder == null || expressionBuilder.getDescriptor() == null ? this.getSession().getPlatform() : (DatabasePlatform)this.getSession().getPlatform(expressionBuilder.getDescriptor().getJavaClass());
        this.requiresDistinct = false;
        this.isFirstElementPrinted = false;
    }

    protected SQLCall getCall() {
        return this.call;
    }

    public DatabasePlatform getPlatform() {
        return this.platform;
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    protected AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isFirstElementPrinted() {
        return this.isFirstElementPrinted;
    }

    public void printExpression(Expression expression) {
        this.translateExpression(expression);
    }

    public void printField(DatabaseField databaseField) {
        if (databaseField == null) {
            return;
        }
        try {
            if (this.shouldPrintQualifiedNames()) {
                this.getWriter().write(databaseField.getQualifiedName());
            } else {
                this.getWriter().write(databaseField.getName());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void printParameter(ParameterExpression parameterExpression) {
        try {
            this.getCall().appendTranslationParameter(this.getWriter(), parameterExpression, this.getPlatform());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void printParameter(DatabaseField databaseField) {
        this.getCall().appendTranslation(this.getWriter(), databaseField);
    }

    public void printPrimitive(Object object) {
        if (object instanceof Collection) {
            this.printValuelist((Collection)object);
            return;
        }
        this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), object);
    }

    public void printNull(ConstantExpression constantExpression) {
        if (this.session.getPlatform().shouldBindLiterals()) {
            DatabaseField databaseField = null;
            Expression expression = constantExpression.getLocalBase();
            if (expression.isFieldExpression()) {
                databaseField = ((FieldExpression)expression).getField();
            } else if (expression.isQueryKeyExpression()) {
                databaseField = ((QueryKeyExpression)expression).getField();
            }
            this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), databaseField);
        } else {
            this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), null);
        }
    }

    public void printString(String string) {
        try {
            this.getWriter().write(string);
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void printValuelist(Collection collection) {
        try {
            this.getWriter().write("(");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), e);
                if (!iterator.hasNext()) continue;
                this.getWriter().write(", ");
            }
            this.getWriter().write(")");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void printList(Collection collection) {
        try {
            this.getWriter().write("(");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Expression) {
                    ((Expression)e).printSQL(this);
                } else {
                    this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), e);
                }
                if (!iterator.hasNext()) continue;
                this.getWriter().write(", ");
            }
            this.getWriter().write(")");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public boolean requiresDistinct() {
        return this.requiresDistinct;
    }

    protected void setCall(SQLCall sQLCall) {
        this.call = sQLCall;
    }

    public void setIsFirstElementPrinted(boolean bl) {
        this.isFirstElementPrinted = bl;
    }

    public void setRequiresDistinct(boolean bl) {
        this.requiresDistinct = bl;
    }

    protected void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    protected void setShouldPrintQualifiedNames(boolean bl) {
        this.shouldPrintQualifiedNames = bl;
    }

    protected void setTranslationRow(AbstractRecord abstractRecord) {
        this.translationRow = abstractRecord;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean shouldPrintParameterValues() {
        return this.getTranslationRow() != null;
    }

    protected boolean shouldPrintQualifiedNames() {
        return this.shouldPrintQualifiedNames;
    }

    protected void translateExpression(Expression expression) {
        expression.printSQL(this);
    }
}

