/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.security.PrivilegedGetContextClassLoader;

public class ConversionManager
implements Serializable,
Cloneable {
    protected Map defaultNullValues;
    protected boolean shouldUseClassLoaderFromCurrentThread = false;
    protected static ConversionManager defaultManager;
    private static ClassLoader defaultLoader;
    protected ClassLoader loader;
    protected Hashtable dataTypesConvertedFromAClass = new Hashtable();
    protected Hashtable dataTypesConvertedToAClass = new Hashtable();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object convertObject(Object object, Class clazz) throws ConversionException {
        if (object == null) {
            if (clazz != null) {
                return this.getDefaultNullValue(clazz);
            }
            return null;
        }
        if (object.getClass() == clazz || clazz == null || clazz == ClassConstants.OBJECT || clazz == ClassConstants.BLOB || clazz == ClassConstants.CLOB) {
            return object;
        }
        if (clazz.isPrimitive() && (object instanceof Boolean && clazz == ClassConstants.PBOOLEAN || object instanceof Long && clazz == ClassConstants.PLONG || object instanceof Integer && clazz == ClassConstants.PINT || object instanceof Float && clazz == ClassConstants.PFLOAT || object instanceof Double && clazz == ClassConstants.PDOUBLE || object instanceof Byte && clazz == ClassConstants.PBYTE || object instanceof Character && clazz == ClassConstants.PCHAR || object instanceof Short && clazz == ClassConstants.PSHORT)) {
            return object;
        }
        try {
            if (clazz == ClassConstants.STRING) {
                return this.convertObjectToString(object);
            }
            if (clazz == ClassConstants.UTILDATE) {
                return this.convertObjectToUtilDate(object);
            }
            if (clazz == ClassConstants.SQLDATE) {
                return this.convertObjectToDate(object);
            }
            if (clazz == ClassConstants.TIME) {
                return this.convertObjectToTime(object);
            }
            if (clazz == ClassConstants.TIMESTAMP) {
                return this.convertObjectToTimestamp(object);
            }
            if (clazz == ClassConstants.CALENDAR || clazz == ClassConstants.GREGORIAN_CALENDAR) {
                return this.convertObjectToCalendar(object);
            }
            if (clazz == ClassConstants.CHAR || clazz == ClassConstants.PCHAR) {
                return this.convertObjectToChar(object);
            }
            if (clazz == ClassConstants.INTEGER || clazz == ClassConstants.PINT) {
                return this.convertObjectToInteger(object);
            }
            if (clazz == ClassConstants.DOUBLE || clazz == ClassConstants.PDOUBLE) {
                return this.convertObjectToDouble(object);
            }
            if (clazz == ClassConstants.FLOAT || clazz == ClassConstants.PFLOAT) {
                return this.convertObjectToFloat(object);
            }
            if (clazz == ClassConstants.LONG || clazz == ClassConstants.PLONG) {
                return this.convertObjectToLong(object);
            }
            if (clazz == ClassConstants.SHORT || clazz == ClassConstants.PSHORT) {
                return this.convertObjectToShort(object);
            }
            if (clazz == ClassConstants.BYTE || clazz == ClassConstants.PBYTE) {
                return this.convertObjectToByte(object);
            }
            if (clazz == ClassConstants.BIGINTEGER) {
                return this.convertObjectToBigInteger(object);
            }
            if (clazz == ClassConstants.BIGDECIMAL) {
                return this.convertObjectToBigDecimal(object);
            }
            if (clazz == ClassConstants.NUMBER) {
                return this.convertObjectToNumber(object);
            }
            if (clazz == ClassConstants.BOOLEAN || clazz == ClassConstants.PBOOLEAN) {
                return this.convertObjectToBoolean(object);
            }
            if (clazz == ClassConstants.APBYTE) {
                return this.convertObjectToByteArray(object);
            }
            if (clazz == ClassConstants.ABYTE) {
                return this.convertObjectToByteObjectArray(object);
            }
            if (clazz == ClassConstants.APCHAR) {
                return this.convertObjectToCharArray(object);
            }
            if (clazz == ClassConstants.ACHAR) {
                return this.convertObjectToCharacterArray(object);
            }
            if (object.getClass() == ClassConstants.STRING && clazz == ClassConstants.CLASS) {
                return this.convertObjectToClass(object);
            }
        }
        catch (ConversionException conversionException) {
            throw conversionException;
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConverted(object, clazz, exception);
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        if (ClassConstants.NOCONVERSION.isAssignableFrom(clazz)) {
            return object;
        }
        throw ConversionException.couldNotBeConverted(object, clazz);
    }

    protected BigDecimal convertObjectToBigDecimal(Object object) throws ConversionException {
        BigDecimal bigDecimal;
        block5: {
            bigDecimal = null;
            try {
                if (object instanceof String) {
                    bigDecimal = new BigDecimal((String)object);
                    break block5;
                }
                if (object instanceof BigInteger) {
                    bigDecimal = new BigDecimal((BigInteger)object);
                    break block5;
                }
                if (object instanceof Number) {
                    String string = String.valueOf(object);
                    bigDecimal = string.endsWith(".0") || string.contains(".0E+") ? new BigDecimal(((Number)object).doubleValue()) : new BigDecimal(string);
                    break block5;
                }
                throw ConversionException.couldNotBeConverted(object, ClassConstants.BIGDECIMAL);
            }
            catch (NumberFormatException numberFormatException) {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.BIGDECIMAL, numberFormatException);
            }
        }
        return bigDecimal;
    }

    protected BigInteger convertObjectToBigInteger(Object object) throws ConversionException {
        BigInteger bigInteger;
        block9: {
            bigInteger = null;
            try {
                if (object instanceof BigInteger) {
                    bigInteger = (BigInteger)object;
                    break block9;
                }
                if (object instanceof String) {
                    bigInteger = new BigInteger((String)object);
                    break block9;
                }
                if (object instanceof BigDecimal) {
                    bigInteger = ((BigDecimal)object).toBigInteger();
                    break block9;
                }
                if (object instanceof Number) {
                    bigInteger = new BigInteger(new Long(((Number)object).longValue()).toString());
                    break block9;
                }
                if (object instanceof Byte[]) {
                    Byte[] byteArray = (Byte[])object;
                    byte[] byArray = new byte[byteArray.length];
                    for (int i = 0; i < byteArray.length; ++i) {
                        byArray[i] = byteArray[i];
                    }
                    bigInteger = new BigInteger(byArray);
                    break block9;
                }
                if (object instanceof byte[]) {
                    bigInteger = new BigInteger((byte[])object);
                    break block9;
                }
                throw ConversionException.couldNotBeConverted(object, ClassConstants.BIGINTEGER);
            }
            catch (NumberFormatException numberFormatException) {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.BIGINTEGER, numberFormatException);
            }
        }
        return bigInteger;
    }

    protected Boolean convertObjectToBoolean(Object object) {
        if (object instanceof Character) {
            switch (Character.toLowerCase(((Character)object).charValue())) {
                case '1': 
                case 't': {
                    return new Boolean(true);
                }
                case '0': 
                case 'f': {
                    return new Boolean(false);
                }
            }
        }
        if (object instanceof String) {
            String string = ((String)object).toLowerCase();
            if (string.equals("t") || string.equals("true") || string.equals("1")) {
                return new Boolean(true);
            }
            if (string.equals("f") || string.equals("false") || string.equals("0")) {
                return new Boolean(false);
            }
        }
        if (object instanceof Number) {
            int n = ((Number)object).intValue();
            if (n != 0) {
                return new Boolean(true);
            }
            if (n == 0) {
                return new Boolean(false);
            }
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.BOOLEAN);
    }

    protected Byte convertObjectToByte(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Byte((String)object);
            }
            if (object instanceof Number) {
                return new Byte(((Number)object).byteValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.BYTE, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.BYTE);
    }

    protected byte[] convertObjectToByteArray(Object object) throws ConversionException {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Byte[]) {
            Byte[] byteArray = (Byte[])object;
            byte[] byArray = new byte[byteArray.length];
            for (int i = 0; i < byteArray.length; ++i) {
                byArray[i] = byteArray[i];
            }
            return byArray;
        }
        if (object instanceof String) {
            return Helper.buildBytesFromHexString((String)object);
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                return blob.getBytes(1L, (int)blob.length());
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException(sQLException);
            }
        }
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int n = inputStream.read();
                while (n != -1) {
                    byteArrayOutputStream.write(n);
                    n = inputStream.read();
                }
                return byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.APBYTE, iOException);
            }
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).toByteArray();
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.APBYTE);
    }

    protected Byte[] convertObjectToByteObjectArray(Object object) throws ConversionException {
        byte[] byArray = this.convertObjectToByteArray(object);
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = new Byte(byArray[i]);
        }
        return byteArray;
    }

    protected Calendar convertObjectToCalendar(Object object) throws ConversionException {
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        if (object instanceof java.util.Date) {
            return Helper.calendarFromUtilDate((java.util.Date)object);
        }
        return Helper.calendarFromUtilDate(this.convertObjectToUtilDate(object));
    }

    protected Character convertObjectToChar(Object object) throws ConversionException {
        if (object instanceof String) {
            if (((String)object).length() < 1) {
                return null;
            }
            return new Character(((String)object).charAt(0));
        }
        if (object instanceof Number) {
            return new Character((char)((Number)object).byteValue());
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.CHAR);
    }

    protected Character[] convertObjectToCharacterArray(Object object) throws ConversionException {
        String string = this.convertObjectToString(object);
        Character[] characterArray = new Character[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            characterArray[i] = new Character(string.charAt(i));
        }
        return characterArray;
    }

    protected char[] convertObjectToCharArray(Object object) throws ConversionException {
        if (object instanceof Character[]) {
            Character[] characterArray = (Character[])object;
            char[] cArray = new char[characterArray.length];
            for (int i = 0; i < characterArray.length; ++i) {
                cArray[i] = characterArray[i].charValue();
            }
            return cArray;
        }
        String string = this.convertObjectToString(object);
        char[] cArray = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            cArray[i] = string.charAt(i);
        }
        return cArray;
    }

    protected Class convertObjectToClass(Object object) throws ConversionException {
        Class<?> clazz = null;
        if (!(object instanceof String)) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.CLASS);
        }
        try {
            clazz = ConversionManager.getPrimitiveClass((String)object);
            if (clazz == null) {
                clazz = Class.forName((String)object, true, this.getLoader());
            }
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConvertedToClass(object, ClassConstants.CLASS, exception);
        }
        return clazz;
    }

    protected Date convertObjectToDate(Object object) throws ConversionException {
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
        } else if (object instanceof Timestamp) {
            date = Helper.dateFromTimestamp((Timestamp)object);
        } else if (object.getClass() == ClassConstants.UTILDATE) {
            date = Helper.sqlDateFromUtilDate((java.util.Date)object);
        } else {
            if (object instanceof Calendar) {
                return Helper.dateFromCalendar((Calendar)object);
            }
            if (object instanceof String) {
                date = Helper.dateFromString((String)object);
            } else if (object instanceof Long) {
                date = Helper.dateFromLong((Long)object);
            } else {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.SQLDATE);
            }
        }
        return date;
    }

    protected Double convertObjectToDouble(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Double((String)object);
            }
            if (object instanceof Number) {
                return new Double(((Number)object).doubleValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.DOUBLE, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.DOUBLE);
    }

    protected Float convertObjectToFloat(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Float((String)object);
            }
            if (object instanceof Number) {
                return new Float(((Number)object).floatValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.FLOAT, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.FLOAT);
    }

    protected Integer convertObjectToInteger(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Integer((String)object);
            }
            if (object instanceof Number) {
                return new Integer(((Number)object).intValue());
            }
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.INTEGER, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.INTEGER);
    }

    protected Long convertObjectToLong(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Long((String)object);
            }
            if (object instanceof Number) {
                return new Long(((Number)object).longValue());
            }
            if (object instanceof java.util.Date) {
                return new Long(((java.util.Date)object).getTime());
            }
            if (object instanceof Calendar) {
                return new Long(((Calendar)object).getTimeInMillis());
            }
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return new Long(1L);
                }
                return new Long(0L);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.LONG, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.LONG);
    }

    protected BigDecimal convertObjectToNumber(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new BigDecimal((String)object);
            }
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).doubleValue());
            }
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return new BigDecimal(1);
                }
                return new BigDecimal(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.NUMBER, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.NUMBER);
    }

    protected Short convertObjectToShort(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Short((String)object);
            }
            if (object instanceof Number) {
                return new Short(((Number)object).shortValue());
            }
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return new Short(1);
                }
                return new Short(0);
            }
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.SHORT, exception);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.SHORT);
    }

    protected String convertObjectToString(Object object) throws ConversionException {
        if (object.getClass() == ClassConstants.UTILDATE) {
            return Helper.printTimestamp(Helper.timestampFromDate((java.util.Date)object));
        }
        if (object instanceof Calendar) {
            return Helper.printCalendar((Calendar)object);
        }
        if (object instanceof Timestamp) {
            return Helper.printTimestamp((Timestamp)object);
        }
        if (object instanceof Date) {
            return Helper.printDate((Date)object);
        }
        if (object instanceof Time) {
            return Helper.printTime((Time)object);
        }
        if (object instanceof byte[]) {
            return Helper.buildHexStringFromBytes((byte[])object);
        }
        if (object instanceof Byte[]) {
            return Helper.buildHexStringFromBytes(this.convertObjectToByteArray(object));
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object instanceof Character[]) {
            return new String(this.convertObjectToCharArray(object));
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object instanceof Character) {
            return object.toString();
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            try {
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException(sQLException);
            }
        }
        return object.toString();
    }

    protected Time convertObjectToTime(Object object) throws ConversionException {
        Time time = null;
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof String) {
            time = Helper.timeFromString((String)object);
        } else if (object.getClass() == ClassConstants.UTILDATE) {
            time = Helper.timeFromDate((java.util.Date)object);
        } else if (object instanceof Timestamp) {
            time = Helper.timeFromTimestamp((Timestamp)object);
        } else {
            if (object instanceof Calendar) {
                return Helper.timeFromCalendar((Calendar)object);
            }
            if (object instanceof Long) {
                time = Helper.timeFromLong((Long)object);
            } else {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.TIME);
            }
        }
        return time;
    }

    protected Timestamp convertObjectToTimestamp(Object object) throws ConversionException {
        Timestamp timestamp = null;
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof String) {
            timestamp = Helper.timestampFromString((String)object);
        } else if (object instanceof java.util.Date) {
            timestamp = Helper.timestampFromDate((java.util.Date)object);
        } else {
            if (object instanceof Calendar) {
                return Helper.timestampFromCalendar((Calendar)object);
            }
            if (object instanceof Long) {
                timestamp = Helper.timestampFromLong((Long)object);
            } else {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.TIMESTAMP);
            }
        }
        return timestamp;
    }

    protected java.util.Date convertObjectToUtilDate(Object object) throws ConversionException {
        java.util.Date date = null;
        if (object.getClass() == java.util.Date.class) {
            date = (java.util.Date)object;
        } else if (object instanceof Date) {
            date = Helper.utilDateFromSQLDate((Date)object);
        } else if (object instanceof Time) {
            date = Helper.utilDateFromTime((Time)object);
        } else if (object instanceof String) {
            date = Helper.utilDateFromTimestamp(Helper.timestampFromString((String)object));
        } else if (object instanceof Timestamp) {
            date = Helper.utilDateFromTimestamp((Timestamp)object);
        } else {
            if (object instanceof Calendar) {
                return ((Calendar)object).getTime();
            }
            if (object instanceof Long) {
                date = Helper.utilDateFromLong((Long)object);
            } else {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.UTILDATE);
            }
        }
        return date;
    }

    public Class convertClassNameToClass(String string) throws ConversionException {
        return this.convertObjectToClass(string);
    }

    public static ConversionManager getDefaultManager() {
        if (defaultManager == null) {
            ConversionManager.setDefaultManager(new ConversionManager());
            defaultManager.setShouldUseClassLoaderFromCurrentThread(true);
        }
        return defaultManager;
    }

    public Object getDefaultNullValue(Class clazz) {
        if (this.defaultNullValues == null) {
            return null;
        }
        return this.getDefaultNullValues().get(clazz);
    }

    public Map getDefaultNullValues() {
        return this.defaultNullValues;
    }

    public ClassLoader getLoader() {
        if (this.shouldUseClassLoaderFromCurrentThread()) {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (ClassLoader)AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()));
                }
                catch (PrivilegedActionException privilegedActionException) {
                }
            } else {
                return PrivilegedAccessHelper.getContextClassLoader(Thread.currentThread());
            }
        }
        if (this.loader == null) {
            if (defaultLoader == null) {
                ClassLoader classLoader = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(ClassConstants.ConversionManager_Class));
                    }
                    catch (PrivilegedActionException privilegedActionException) {}
                } else {
                    classLoader = PrivilegedAccessHelper.getClassLoaderForClass(ClassConstants.ConversionManager_Class);
                }
                this.setLoader(classLoader);
            } else {
                this.setLoader(ConversionManager.getDefaultLoader());
            }
        }
        return this.loader;
    }

    public boolean hasDefaultNullValues() {
        return this.defaultNullValues != null;
    }

    public static Class loadClass(String string) {
        return (Class)ConversionManager.getDefaultManager().convertObject(string, ClassConstants.CLASS);
    }

    public static Class getObjectClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isPrimitive()) {
            if (clazz == ClassConstants.PCHAR) {
                return ClassConstants.CHAR;
            }
            if (clazz == ClassConstants.PINT) {
                return ClassConstants.INTEGER;
            }
            if (clazz == ClassConstants.PDOUBLE) {
                return ClassConstants.DOUBLE;
            }
            if (clazz == ClassConstants.PFLOAT) {
                return ClassConstants.FLOAT;
            }
            if (clazz == ClassConstants.PLONG) {
                return ClassConstants.LONG;
            }
            if (clazz == ClassConstants.PSHORT) {
                return ClassConstants.SHORT;
            }
            if (clazz == ClassConstants.PBYTE) {
                return ClassConstants.BYTE;
            }
            if (clazz == ClassConstants.PBOOLEAN) {
                return ClassConstants.BOOLEAN;
            }
        } else {
            if (clazz == ClassConstants.APBYTE) {
                return ClassConstants.APBYTE;
            }
            if (clazz == ClassConstants.APCHAR) {
                return ClassConstants.APCHAR;
            }
            return clazz;
        }
        return clazz;
    }

    public static Class getPrimitiveClass(String string) {
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        return null;
    }

    public static void setDefaultManager(ConversionManager conversionManager) {
        defaultManager = conversionManager;
    }

    public void setDefaultNullValue(Class clazz, Object object) {
        if (this.defaultNullValues == null) {
            this.defaultNullValues = new HashMap(5);
        }
        this.getDefaultNullValues().put(clazz, object);
    }

    public void setDefaultNullValues(Map map) {
        this.defaultNullValues = map;
    }

    public void setLoader(ClassLoader classLoader) {
        this.shouldUseClassLoaderFromCurrentThread = false;
        this.loader = classLoader;
    }

    public static void setDefaultLoader(ClassLoader classLoader) {
        defaultLoader = classLoader;
    }

    public static ClassLoader getDefaultLoader() {
        return defaultLoader;
    }

    public void setShouldUseClassLoaderFromCurrentThread(boolean bl) {
        this.shouldUseClassLoaderFromCurrentThread = bl;
    }

    public boolean shouldUseClassLoaderFromCurrentThread() {
        return this.shouldUseClassLoaderFromCurrentThread;
    }

    public Vector getDataTypesConvertedFrom(Class clazz) {
        if (this.dataTypesConvertedFromAClass.isEmpty()) {
            this.buildDataTypesConvertedFromAClass();
        }
        return (Vector)this.dataTypesConvertedFromAClass.get(clazz);
    }

    public Vector getDataTypesConvertedTo(Class clazz) {
        if (this.dataTypesConvertedToAClass.isEmpty()) {
            this.buildDataTypesConvertedToAClass();
        }
        return (Vector)this.dataTypesConvertedToAClass.get(clazz);
    }

    protected Vector buildNumberVec() {
        Vector<Class<Number>> vector = new Vector<Class<Number>>();
        vector.addElement(BigInteger.class);
        vector.addElement(BigDecimal.class);
        vector.addElement(Byte.class);
        vector.addElement(Double.class);
        vector.addElement(Float.class);
        vector.addElement(Integer.class);
        vector.addElement(Long.class);
        vector.addElement(Short.class);
        vector.addElement(Number.class);
        return vector;
    }

    protected Vector buildDateTimeVec() {
        Vector<Class<Calendar>> vector = new Vector<Class<Calendar>>();
        vector.addElement(java.util.Date.class);
        vector.addElement(Timestamp.class);
        vector.addElement(Calendar.class);
        return vector;
    }

    protected void buildDataTypesConvertedFromAClass() {
        this.dataTypesConvertedFromAClass.put(BigDecimal.class, this.buildFromBigDecimalVec());
        this.dataTypesConvertedFromAClass.put(BigInteger.class, this.buildFromBigIntegerVec());
        this.dataTypesConvertedFromAClass.put(Blob.class, this.buildFromBlobVec());
        this.dataTypesConvertedFromAClass.put(Boolean.class, this.buildFromBooleanVec());
        this.dataTypesConvertedFromAClass.put(byte[].class, this.buildFromByteArrayVec());
        this.dataTypesConvertedFromAClass.put(Byte.class, this.buildFromByteVec());
        this.dataTypesConvertedFromAClass.put(Calendar.class, this.buildFromCalendarVec());
        this.dataTypesConvertedFromAClass.put(Character.class, this.buildFromCharacterVec());
        this.dataTypesConvertedFromAClass.put(Clob.class, this.buildFromClobVec());
        this.dataTypesConvertedFromAClass.put(Date.class, this.buildFromDateVec());
        this.dataTypesConvertedFromAClass.put(Double.class, this.buildFromDoubleVec());
        this.dataTypesConvertedFromAClass.put(Float.class, this.buildFromFloatVec());
        this.dataTypesConvertedFromAClass.put(Integer.class, this.buildFromIntegerVec());
        this.dataTypesConvertedFromAClass.put(Long.class, this.buildFromLongVec());
        this.dataTypesConvertedFromAClass.put(Number.class, this.buildFromNumberVec());
        this.dataTypesConvertedFromAClass.put(Short.class, this.buildFromShortVec());
        this.dataTypesConvertedFromAClass.put(String.class, this.buildFromStringVec());
        this.dataTypesConvertedFromAClass.put(Timestamp.class, this.buildFromTimestampVec());
        this.dataTypesConvertedFromAClass.put(Time.class, this.buildFromTimeVec());
        this.dataTypesConvertedFromAClass.put(java.util.Date.class, this.buildFromUtilDateVec());
        this.dataTypesConvertedFromAClass.put(Byte[].class, this.buildFromByteObjectArraryVec());
        this.dataTypesConvertedFromAClass.put(char[].class, this.buildFromCharArrayVec());
        this.dataTypesConvertedFromAClass.put(Character[].class, this.buildFromCharacterArrayVec());
    }

    protected Vector buildFromBooleanVec() {
        Vector<Class<Comparable<Boolean>>> vector = new Vector<Class<Comparable<Boolean>>>();
        vector.addElement(String.class);
        vector.addElement(Boolean.class);
        vector.addElement(Integer.class);
        vector.addElement(Long.class);
        vector.addElement(Short.class);
        vector.addElement(Number.class);
        vector.addElement(Character[].class);
        vector.addElement(char[].class);
        vector.addElement(Boolean.TYPE);
        vector.addElement(Integer.TYPE);
        vector.addElement(Long.TYPE);
        vector.addElement(Short.TYPE);
        return vector;
    }

    protected Vector buildFromNumberVec() {
        Vector vector = this.buildNumberVec();
        vector.addElement(String.class);
        vector.addElement(Character.class);
        vector.addElement(Boolean.class);
        vector.addElement(Character[].class);
        vector.addElement(char[].class);
        vector.addElement(Character.TYPE);
        vector.addElement(Integer.TYPE);
        vector.addElement(Double.TYPE);
        vector.addElement(Float.TYPE);
        vector.addElement(Long.TYPE);
        vector.addElement(Short.TYPE);
        vector.addElement(Byte.TYPE);
        vector.addElement(Boolean.TYPE);
        return vector;
    }

    protected Vector buildFromBigDecimalVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromBigIntegerVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromIntegerVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromFloatVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromDoubleVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromShortVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromByteVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromLongVec() {
        Vector vector = this.buildFromNumberVec();
        vector.addAll(this.buildDateTimeVec());
        vector.addElement(Date.class);
        vector.addElement(Time.class);
        return vector;
    }

    protected Vector buildFromStringVec() {
        Vector vector = this.buildFromLongVec();
        vector.addElement(Byte[].class);
        vector.addElement(byte[].class);
        vector.addElement(Clob.class);
        return vector;
    }

    protected Vector buildFromCharacterVec() {
        Vector<Class<Boolean>> vector = new Vector<Class<Boolean>>();
        vector.addElement(String.class);
        vector.addElement(Boolean.class);
        vector.addElement(Character[].class);
        vector.addElement(Character.class);
        vector.addElement(char[].class);
        vector.addElement(Character.TYPE);
        vector.addElement(Boolean.TYPE);
        return vector;
    }

    protected Vector buildFromByteArrayVec() {
        Vector<Class<char[]>> vector = new Vector<Class<char[]>>();
        vector.addElement(String.class);
        vector.addElement(byte[].class);
        vector.addElement(Byte[].class);
        vector.addElement(Character[].class);
        vector.addElement(char[].class);
        return vector;
    }

    protected Vector buildFromClobVec() {
        Vector<Class<char[]>> vector = new Vector<Class<char[]>>();
        vector.addElement(String.class);
        vector.addElement(Character[].class);
        vector.addElement(char[].class);
        return vector;
    }

    protected Vector buildFromBlobVec() {
        Vector<Class<char[]>> vector = new Vector<Class<char[]>>();
        vector.addElement(String.class);
        vector.addElement(Byte[].class);
        vector.addElement(byte[].class);
        vector.addElement(Character[].class);
        vector.addElement(char[].class);
        return vector;
    }

    protected Vector buildFromUtilDateVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(String.class);
        vector.addElement(Long.class);
        vector.addElement(Date.class);
        vector.addElement(Time.class);
        vector.addElement(Long.TYPE);
        vector.addElement(Character[].class);
        vector.addElement(char[].class);
        return vector;
    }

    protected Vector buildFromTimestampVec() {
        return this.buildFromUtilDateVec();
    }

    protected Vector buildFromCalendarVec() {
        return this.buildFromUtilDateVec();
    }

    protected Vector buildFromDateVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(String.class);
        vector.addElement(Long.class);
        vector.addElement(Date.class);
        vector.addElement(Long.TYPE);
        vector.addElement(Character[].class);
        vector.addElement(char[].class);
        return vector;
    }

    protected Vector buildFromTimeVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(String.class);
        vector.addElement(Long.class);
        vector.addElement(Time.class);
        vector.addElement(Long.TYPE);
        vector.addElement(Character[].class);
        vector.addElement(char[].class);
        return vector;
    }

    protected Vector buildFromByteObjectArraryVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(Blob.class);
        vector.addElement(byte[].class);
        return vector;
    }

    protected Vector buildFromCharArrayVec() {
        Vector<Class<Clob>> vector = new Vector<Class<Clob>>();
        vector.addElement(Clob.class);
        return vector;
    }

    protected Vector buildFromCharacterArrayVec() {
        Vector<Class<Clob>> vector = new Vector<Class<Clob>>();
        vector.addElement(Clob.class);
        return vector;
    }

    protected void buildDataTypesConvertedToAClass() {
        this.dataTypesConvertedToAClass.put(BigDecimal.class, this.buildToBigDecimalVec());
        this.dataTypesConvertedToAClass.put(BigInteger.class, this.buildToBigIntegerVec());
        this.dataTypesConvertedToAClass.put(Boolean.class, this.buildToBooleanVec());
        this.dataTypesConvertedToAClass.put(Byte.class, this.buildToByteVec());
        this.dataTypesConvertedToAClass.put(byte[].class, this.buildToByteArrayVec());
        this.dataTypesConvertedToAClass.put(Byte[].class, this.buildToByteObjectArrayVec());
        this.dataTypesConvertedToAClass.put(Calendar.class, this.buildToCalendarVec());
        this.dataTypesConvertedToAClass.put(Character.class, this.buildToCharacterVec());
        this.dataTypesConvertedToAClass.put(Character[].class, this.buildToCharacterArrayVec());
        this.dataTypesConvertedToAClass.put(char[].class, this.buildToCharArrayVec());
        this.dataTypesConvertedToAClass.put(Date.class, this.buildToDateVec());
        this.dataTypesConvertedToAClass.put(Double.class, this.buildToDoubleVec());
        this.dataTypesConvertedToAClass.put(Float.class, this.buildToFloatVec());
        this.dataTypesConvertedToAClass.put(Integer.class, this.buildToIntegerVec());
        this.dataTypesConvertedToAClass.put(Long.class, this.buildToLongVec());
        this.dataTypesConvertedToAClass.put(Number.class, this.buildToNumberVec());
        this.dataTypesConvertedToAClass.put(Short.class, this.buildToShortVec());
        this.dataTypesConvertedToAClass.put(String.class, this.buildToStringVec());
        this.dataTypesConvertedToAClass.put(Timestamp.class, this.buildToTimestampVec());
        this.dataTypesConvertedToAClass.put(Time.class, this.buildToTimeVec());
        this.dataTypesConvertedToAClass.put(java.util.Date.class, this.buildToUtilDateVec());
        this.dataTypesConvertedToAClass.put(Clob.class, this.buildToClobVec());
        this.dataTypesConvertedToAClass.put(Blob.class, this.buildToBlobVec());
    }

    protected Vector buildAllTypesToAClassVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(String.class);
        vector.addElement(Integer.class);
        vector.addElement(java.util.Date.class);
        vector.addElement(Date.class);
        vector.addElement(Time.class);
        vector.addElement(Timestamp.class);
        vector.addElement(Calendar.class);
        vector.addElement(Character.class);
        vector.addElement(Double.class);
        vector.addElement(Float.class);
        vector.addElement(Long.class);
        vector.addElement(Short.class);
        vector.addElement(Byte.class);
        vector.addElement(BigInteger.class);
        vector.addElement(BigDecimal.class);
        vector.addElement(Number.class);
        vector.addElement(Boolean.class);
        vector.addElement(Character[].class);
        vector.addElement(Blob.class);
        vector.addElement(Clob.class);
        return vector;
    }

    protected Vector buildToBigDecimalVec() {
        Vector vector = this.buildNumberVec();
        vector.addElement(String.class);
        return vector;
    }

    protected Vector buildToBigIntegerVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToBooleanVec() {
        Vector vector = this.buildToBigDecimalVec();
        vector.addElement(Character.class);
        vector.addElement(Boolean.class);
        return vector;
    }

    protected Vector buildToByteVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToDoubleVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToFloatVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToIntegerVec() {
        Vector vector = this.buildToBigDecimalVec();
        vector.addElement(Boolean.class);
        return vector;
    }

    protected Vector buildToLongVec() {
        Vector vector = this.buildToIntegerVec();
        vector.addElement(Calendar.class);
        vector.addElement(java.util.Date.class);
        return vector;
    }

    protected Vector buildToNumberVec() {
        return this.buildToIntegerVec();
    }

    protected Vector buildToShortVec() {
        return this.buildToIntegerVec();
    }

    protected Vector buildToByteArrayVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(String.class);
        vector.addElement(Blob.class);
        vector.addElement(byte[].class);
        vector.addElement(Byte[].class);
        return vector;
    }

    protected Vector buildToByteObjectArrayVec() {
        Vector vector = this.buildToByteArrayVec();
        vector.addElement(Byte[].class);
        return vector;
    }

    protected Vector buildToCharacterVec() {
        Vector vector = this.buildToBigDecimalVec();
        vector.addElement(Character.class);
        return vector;
    }

    protected Vector buildToCharacterArrayVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected Vector buildToCharArrayVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected Vector buildToStringVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected Vector buildToCalendarVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(String.class);
        vector.addElement(Long.class);
        vector.addElement(Date.class);
        vector.addElement(Time.class);
        return vector;
    }

    protected Vector buildToTimestampVec() {
        return this.buildToCalendarVec();
    }

    protected Vector buildToUtilDateVec() {
        return this.buildToCalendarVec();
    }

    protected Vector buildToDateVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(String.class);
        vector.addElement(Long.class);
        vector.addElement(Date.class);
        return vector;
    }

    protected Vector buildToTimeVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(String.class);
        vector.addElement(Long.class);
        vector.addElement(Time.class);
        return vector;
    }

    protected Vector buildToBlobVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(Byte[].class);
        vector.addElement(byte[].class);
        return vector;
    }

    protected Vector buildToClobVec() {
        Vector<Class<Character[]>> vector = new Vector<Class<Character[]>>();
        vector.addElement(String.class);
        vector.addElement(char[].class);
        vector.addElement(Character[].class);
        return vector;
    }
}

