/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sessions.Session;

public class WriteLockManager {
    protected ExposedNodeLinkedList prevailingQueue = new ExposedNodeLinkedList();
    public static int MAXTRIES = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map acquireLocksForClone(Object object, ClassDescriptor classDescriptor, CacheKey cacheKey, AbstractSession abstractSession, UnitOfWorkImpl unitOfWorkImpl) {
        Object object2;
        boolean bl = false;
        IdentityHashMap identityHashMap = new IdentityHashMap();
        IdentityHashMap<Object, Object> identityHashMap2 = new IdentityHashMap<Object, Object>();
        try {
            object2 = this.acquireLockAndRelatedLocks(object, identityHashMap, identityHashMap2, cacheKey, classDescriptor, abstractSession, unitOfWorkImpl);
            int n = 0;
            while (object2 != null) {
                Object object3 = identityHashMap.values().iterator();
                while (object3.hasNext()) {
                    ((CacheKey)object3.next()).releaseReadLock();
                    object3.remove();
                }
                object3 = ((CacheKey)object2).getMutex();
                synchronized (object3) {
                    try {
                        if (((CacheKey)object2).isAcquired()) {
                            ((CacheKey)object2).getMutex().wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                object3 = ((CacheKey)object2).getObject();
                if (object3 != null) {
                    unitOfWorkImpl.checkInvalidObject(object3, (CacheKey)object2, abstractSession.getDescriptor(object3));
                    identityHashMap2.put(object3, object3);
                }
                if ((object2 = this.acquireLockAndRelatedLocks(object, identityHashMap, identityHashMap2, cacheKey, classDescriptor, abstractSession, unitOfWorkImpl)) == null || ++n <= MAXTRIES) continue;
                throw ConcurrencyException.maxTriesLockOnCloneExceded(object);
            }
            bl = true;
        }
        finally {
            if (!bl) {
                object2 = identityHashMap.values().iterator();
                while (object2.hasNext()) {
                    ((CacheKey)object2.next()).releaseReadLock();
                    object2.remove();
                }
            }
        }
        return identityHashMap;
    }

    public CacheKey acquireLockAndRelatedLocks(Object object, Map map, Map map2, CacheKey cacheKey, ClassDescriptor classDescriptor, AbstractSession abstractSession, UnitOfWorkImpl unitOfWorkImpl) {
        if (!map2.containsKey(object) && this.checkInvalidObject(object, cacheKey, classDescriptor, unitOfWorkImpl)) {
            return cacheKey;
        }
        if (cacheKey.acquireReadLockNoWait()) {
            if (cacheKey.getObject() == null) {
                map.put(object, cacheKey);
            } else {
                object = cacheKey.getObject();
                if (map.containsKey(object)) {
                    cacheKey.releaseReadLock();
                    return null;
                }
                map.put(object, cacheKey);
            }
            return this.traverseRelatedLocks(object, map, map2, classDescriptor, abstractSession, unitOfWorkImpl);
        }
        return cacheKey;
    }

    public boolean checkInvalidObject(Object object, CacheKey cacheKey, ClassDescriptor classDescriptor, UnitOfWorkImpl unitOfWorkImpl) {
        if (!unitOfWorkImpl.isNestedUnitOfWork() && cacheKey.getObject() != null) {
            CacheInvalidationPolicy cacheInvalidationPolicy = classDescriptor.getCacheInvalidationPolicy();
            return cacheInvalidationPolicy.shouldRefreshInvalidObjectsInUnitOfWork() && cacheInvalidationPolicy.isInvalidated(cacheKey);
        }
        return false;
    }

    public void transitionToDeferredLocks(MergeManager mergeManager) {
        try {
            if (mergeManager.isTransitionedToDeferredLocks()) {
                return;
            }
            for (CacheKey cacheKey : mergeManager.getAcquiredLocks()) {
                cacheKey.transitionToDeferredLock();
            }
            mergeManager.transitionToDeferredLocks();
        }
        catch (RuntimeException runtimeException) {
            for (CacheKey cacheKey : mergeManager.getAcquiredLocks()) {
                cacheKey.release();
            }
            ConcurrencyManager.getDeferredLockManager(Thread.currentThread()).setIsThreadComplete(true);
            ConcurrencyManager.removeDeferredLockManager(Thread.currentThread());
            mergeManager.getAcquiredLocks().clear();
            throw runtimeException;
        }
    }

    public CacheKey traverseRelatedLocks(Object object, Map map, Map map2, ClassDescriptor classDescriptor, AbstractSession abstractSession, UnitOfWorkImpl unitOfWorkImpl) {
        if (classDescriptor.shouldAcquireCascadedLocks()) {
            FetchGroupManager fetchGroupManager = classDescriptor.getFetchGroupManager();
            boolean bl = fetchGroupManager != null && fetchGroupManager.isPartialObject(object);
            for (DatabaseMapping databaseMapping : classDescriptor.getLockableMappings()) {
                Cloneable cloneable;
                if (bl && !fetchGroupManager.isAttributeFetched(object, databaseMapping.getAttributeName())) continue;
                Object object2 = databaseMapping.getAttributeValueFromObject(object);
                if (databaseMapping.isCollectionMapping()) {
                    if (object2 == null) continue;
                    cloneable = databaseMapping.getContainerPolicy();
                    Object object3 = ((ContainerPolicy)cloneable).iteratorFor(object2);
                    while (((ContainerPolicy)cloneable).hasNext(object3)) {
                        CacheKey cacheKey;
                        Object object4 = ((ContainerPolicy)cloneable).next(object3, abstractSession);
                        if (databaseMapping.getReferenceDescriptor().hasWrapperPolicy()) {
                            object4 = databaseMapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(object4, abstractSession);
                        }
                        if ((cacheKey = this.checkAndLockObject(object4, map, map2, databaseMapping, abstractSession, unitOfWorkImpl)) == null) continue;
                        return cacheKey;
                    }
                    continue;
                }
                if (databaseMapping.getReferenceDescriptor().hasWrapperPolicy()) {
                    object2 = databaseMapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(object2, abstractSession);
                }
                if ((cloneable = this.checkAndLockObject(object2, map, map2, databaseMapping, abstractSession, unitOfWorkImpl)) == null) continue;
                return cloneable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireRequiredLocks(MergeManager mergeManager, UnitOfWorkChangeSet unitOfWorkChangeSet) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        try {
            mergeManager.setLockThread(Thread.currentThread());
            Object object = mergeManager.getSession();
            if (((AbstractSession)object).isUnitOfWork()) {
                object = ((UnitOfWorkImpl)object).getParent();
            } else {
                bl2 = true;
            }
            block19: while (bl) {
                bl = false;
                for (String string : unitOfWorkChangeSet.getObjectChanges().keySet()) {
                    Hashtable hashtable = (Hashtable)unitOfWorkChangeSet.getObjectChanges().get(string);
                    Iterator iterator = hashtable.keySet().iterator();
                    Class clazz = null;
                    while (iterator.hasNext()) {
                        ClassDescriptor classDescriptor;
                        ObjectChangeSet objectChangeSet = (ObjectChangeSet)iterator.next();
                        if (objectChangeSet.getCacheKey() == null) continue;
                        if (clazz == null) {
                            clazz = objectChangeSet.getClassType((Session)object);
                        }
                        if ((classDescriptor = ((AbstractSession)object).getDescriptor(clazz)).shouldIsolateObjectsInUnitOfWork()) break;
                        CacheKey cacheKey = this.attemptToAcquireLock(clazz, objectChangeSet.getCacheKey(), (AbstractSession)object);
                        if (cacheKey == null) {
                            if (this.prevailingQueue.getFirst() == mergeManager) {
                                cacheKey = this.waitOnObjectLock(clazz, objectChangeSet.getCacheKey(), (AbstractSession)object, (int)Math.round(Math.random() * 500.0));
                            }
                            if (cacheKey == null) {
                                block33: {
                                    Object[] objectArray;
                                    this.releaseAllAcquiredLocks(mergeManager);
                                    cacheKey = ((AbstractSession)object).getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(objectChangeSet.getCacheKey().getKey(), clazz, classDescriptor);
                                    if (((AbstractSession)object).shouldLog(2, "cache")) {
                                        objectArray = new Object[]{clazz, objectChangeSet.getCacheKey() != null ? objectChangeSet.getCacheKey().getKey() : new Vector(), Thread.currentThread().getName()};
                                        ((AbstractSession)object).log(2, "cache", "dead_lock_encountered_on_write_no_cachekey", objectArray, null, true);
                                    }
                                    if (mergeManager.getWriteLockQueued() == null) {
                                        objectArray = this.prevailingQueue;
                                        synchronized (objectArray) {
                                            mergeManager.setQueueNode(this.prevailingQueue.addLast(mergeManager));
                                        }
                                    }
                                    mergeManager.setWriteLockQueued(objectChangeSet.getCacheKey());
                                    try {
                                        if (cacheKey == null) break block33;
                                        objectArray = cacheKey.getMutex();
                                        synchronized (objectArray) {
                                            if (cacheKey.getMutex().isAcquired() && cacheKey.getMutex().getActiveThread() != Thread.currentThread()) {
                                                cacheKey.getMutex().wait();
                                            }
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        throw ConcurrencyException.waitWasInterrupted(interruptedException.getMessage());
                                    }
                                }
                                bl = true;
                                break;
                            }
                            objectChangeSet.setActiveCacheKey(cacheKey);
                            mergeManager.getAcquiredLocks().add(cacheKey);
                            continue;
                        }
                        objectChangeSet.setActiveCacheKey(cacheKey);
                        mergeManager.getAcquiredLocks().add(cacheKey);
                    }
                    if (!bl) continue;
                    continue block19;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.releaseAllAcquiredLocks(mergeManager);
            throw runtimeException;
        }
        finally {
            if (mergeManager.getWriteLockQueued() != null) {
                ExposedNodeLinkedList exposedNodeLinkedList = this.prevailingQueue;
                synchronized (exposedNodeLinkedList) {
                    this.prevailingQueue.remove(mergeManager.getQueueNode());
                }
                mergeManager.setWriteLockQueued(null);
            }
        }
    }

    public Object appendLock(Vector vector, Object object, ClassDescriptor classDescriptor, MergeManager mergeManager, AbstractSession abstractSession) {
        CacheKey cacheKey = abstractSession.getIdentityMapAccessorInstance().acquireLockNoWait(vector, classDescriptor.getJavaClass(), true, classDescriptor);
        if (cacheKey == null) {
            abstractSession.getIdentityMapAccessorInstance().getWriteLockManager().transitionToDeferredLocks(mergeManager);
            cacheKey = abstractSession.getIdentityMapAccessorInstance().acquireDeferredLock(vector, classDescriptor.getJavaClass(), classDescriptor);
            Object object2 = cacheKey.getObject();
            if (object2 == null) {
                object2 = cacheKey.waitForObject();
            }
            cacheKey.releaseDeferredLock();
            return object2;
        }
        if (cacheKey.getObject() == null) {
            cacheKey.setObject(object);
        }
        mergeManager.getAcquiredLocks().add(cacheKey);
        return cacheKey.getObject();
    }

    protected CacheKey attemptToAcquireLock(Class clazz, CacheKey cacheKey, AbstractSession abstractSession) {
        return abstractSession.getIdentityMapAccessorInstance().acquireLockNoWait(cacheKey.getKey(), clazz, true, abstractSession.getDescriptor(clazz));
    }

    protected CacheKey checkAndLockObject(Object object, Map map, Map map2, DatabaseMapping databaseMapping, AbstractSession abstractSession, UnitOfWorkImpl unitOfWorkImpl) {
        if (object != null && !map.containsKey(object)) {
            Vector vector = null;
            ClassDescriptor classDescriptor = null;
            classDescriptor = databaseMapping.getReferenceDescriptor().hasInheritance() || databaseMapping.getReferenceDescriptor().isDescriptorForInterface() ? abstractSession.getDescriptor(object) : databaseMapping.getReferenceDescriptor();
            if (classDescriptor.isDescriptorTypeAggregate()) {
                this.traverseRelatedLocks(object, map, map2, classDescriptor, abstractSession, unitOfWorkImpl);
            } else {
                CacheKey cacheKey;
                vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, abstractSession);
                CacheKey cacheKey2 = abstractSession.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(vector, object.getClass(), classDescriptor);
                if (cacheKey2 == null) {
                    cacheKey2 = new CacheKey(vector);
                    cacheKey2.setReadTime(System.currentTimeMillis());
                }
                if ((cacheKey = this.acquireLockAndRelatedLocks(object, map, map2, cacheKey2, classDescriptor, abstractSession, unitOfWorkImpl)) != null) {
                    return cacheKey;
                }
            }
        }
        return null;
    }

    public void releaseAllAcquiredLocks(MergeManager mergeManager) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        Iterator<CacheKey> iterator = mergeManager.getAcquiredLocks().iterator();
        while (iterator.hasNext()) {
            CacheKey cacheKey = iterator.next();
            if (cacheKey.getObject() == null) {
                cacheKey.removeFromOwningMap();
            }
            if (mergeManager.isTransitionedToDeferredLocks()) {
                cacheKey.releaseDeferredLock();
            } else {
                cacheKey.release();
            }
            iterator.remove();
        }
    }

    protected CacheKey waitOnObjectLock(Class clazz, CacheKey cacheKey, AbstractSession abstractSession, int n) {
        return abstractSession.getIdentityMapAccessorInstance().acquireLockWithWait(cacheKey.getKey(), clazz, true, abstractSession.getDescriptor(clazz), n);
    }
}

