/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class ContainerIndirectionPolicy
extends BasicIndirectionPolicy {
    private Class containerClass;
    private String containerClassName;
    private Constructor containerConstructor;

    public Object backupCloneAttribute(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl) {
        IndirectContainer indirectContainer = (IndirectContainer)object;
        ValueHolderInterface valueHolderInterface = indirectContainer.getValueHolder();
        ValueHolderInterface valueHolderInterface2 = (ValueHolderInterface)super.backupCloneAttribute(valueHolderInterface, object2, object3, unitOfWorkImpl);
        return this.buildContainer(valueHolderInterface2);
    }

    protected IndirectContainer buildContainer(ValueHolderInterface valueHolderInterface) {
        try {
            IndirectContainer indirectContainer = null;
            if (this.getContainerConstructor().getParameterTypes().length == 0) {
                indirectContainer = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (IndirectContainer)AccessController.doPrivileged(new PrivilegedInvokeConstructor(this.getContainerConstructor(), new Object[0])) : (IndirectContainer)PrivilegedAccessHelper.invokeConstructor(this.getContainerConstructor(), new Object[0]);
                indirectContainer.setValueHolder(valueHolderInterface);
            } else {
                indirectContainer = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (IndirectContainer)AccessController.doPrivileged(new PrivilegedInvokeConstructor(this.getContainerConstructor(), new Object[]{valueHolderInterface})) : (IndirectContainer)PrivilegedAccessHelper.invokeConstructor(this.getContainerConstructor(), new Object[]{valueHolderInterface});
            }
            return indirectContainer;
        }
        catch (Exception exception) {
            throw DescriptorException.invalidIndirectionPolicyOperation(this, "buildContainer constructor (" + this.getContainerConstructor() + ") Failed: " + exception);
        }
    }

    public Object buildIndirectObject(ValueHolderInterface valueHolderInterface) {
        return this.buildContainer(valueHolderInterface);
    }

    public Object cloneAttribute(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        IndirectContainer indirectContainer = (IndirectContainer)object;
        ValueHolderInterface valueHolderInterface = indirectContainer.getValueHolder();
        ValueHolderInterface valueHolderInterface2 = (ValueHolderInterface)super.cloneAttribute(valueHolderInterface, object2, object3, unitOfWorkImpl, bl);
        return this.buildContainer(valueHolderInterface2);
    }

    public AbstractRecord extractReferenceRow(Object object) {
        if (this.objectIsInstantiated(object)) {
            return null;
        }
        return ((DatabaseValueHolder)((IndirectContainer)object).getValueHolder()).getRow();
    }

    public Class getContainerClass() {
        return this.containerClass;
    }

    public String getContainerClassName() {
        if (this.containerClassName == null && this.containerClass != null) {
            this.containerClassName = this.containerClass.getName();
        }
        return this.containerClassName;
    }

    protected Constructor getContainerConstructor() {
        return this.containerConstructor;
    }

    public Object getOriginalIndirectionObject(Object object, AbstractSession abstractSession) {
        IndirectContainer indirectContainer = (IndirectContainer)object;
        if (indirectContainer.getValueHolder() instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolderInterface = ((UnitOfWorkValueHolder)indirectContainer.getValueHolder()).getWrappedValueHolder();
            if (valueHolderInterface == null && abstractSession.isRemoteUnitOfWork()) {
                RemoteSessionController remoteSessionController = ((RemoteUnitOfWork)abstractSession).getParentSessionController();
                valueHolderInterface = (ValueHolderInterface)remoteSessionController.getRemoteValueHolders().get(((UnitOfWorkValueHolder)indirectContainer.getValueHolder()).getWrappedValueHolderRemoteID());
            }
            return this.buildContainer(valueHolderInterface);
        }
        return indirectContainer;
    }

    public Object getRealAttributeValueFromObject(Object object, Object object2) {
        return ((IndirectContainer)object2).getValueHolder().getValue();
    }

    public void initialize() {
        if (!ClassConstants.IndirectContainer_Class.isAssignableFrom(this.containerClass)) {
            throw DescriptorException.invalidIndirectionContainerClass(this, this.containerClass);
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    this.containerConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.ValueHolderInterface_Class}, false));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getCause() instanceof NoSuchMethodException) {
                        throw (NoSuchMethodException)privilegedActionException.getCause();
                    }
                    throw (RuntimeException)privilegedActionException.getCause();
                }
            } else {
                this.containerConstructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.ValueHolderInterface_Class}, false);
            }
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.containerConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), new Class[0], false));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (privilegedActionException.getCause() instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)privilegedActionException.getCause();
                        }
                        throw (RuntimeException)privilegedActionException.getCause();
                    }
                } else {
                    this.containerConstructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), new Class[0], false);
                }
                return;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw DescriptorException.noConstructorIndirectionContainerClass(this, this.containerClass);
            }
        }
    }

    public void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        super.iterateOnAttributeValue(descriptorIterator, ((IndirectContainer)object).getValueHolder());
    }

    public Object nullValueFromRow() {
        return this.buildContainer(new ValueHolder());
    }

    public void reset(Object object) {
        this.getMapping().setAttributeValueInObject(object, this.buildContainer(new ValueHolder()));
    }

    public boolean objectIsInstantiated(Object object) {
        return ((IndirectContainer)object).getValueHolder().isInstantiated();
    }

    public void setContainerClass(Class clazz) {
        this.containerClass = clazz;
    }

    public void setContainterClassName(String string) {
        this.containerClassName = string;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) {
        IndirectContainer indirectContainer = (IndirectContainer)this.getMapping().getAttributeValueFromObject(object);
        indirectContainer.getValueHolder().setValue(object2);
        this.getMapping().setAttributeValueInObject(object, indirectContainer);
    }

    protected boolean typeIsValid(Class clazz) {
        return ClassConstants.IndirectContainer_Class.isAssignableFrom(clazz) || clazz.isAssignableFrom(this.getContainerClass());
    }

    public Object validateAttributeOfInstantiatedObject(Object object) {
        if (!this.getContainerClass().isInstance(object)) {
            throw DescriptorException.valueHolderInstantiationMismatch(object, this.getMapping());
        }
        return object;
    }

    public Object valueFromBatchQuery(ReadQuery readQuery, AbstractRecord abstractRecord, ObjectLevelReadQuery objectLevelReadQuery) {
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)super.valueFromBatchQuery(readQuery, abstractRecord, objectLevelReadQuery);
        return this.buildContainer(valueHolderInterface);
    }

    public Object valueFromMethod(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)super.valueFromMethod(object, abstractRecord, abstractSession);
        return this.buildContainer(valueHolderInterface);
    }

    public Object valueFromQuery(ReadQuery readQuery, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        ValueHolderInterface valueHolderInterface = (ValueHolderInterface)super.valueFromQuery(readQuery, abstractRecord, abstractSession);
        return this.buildContainer(valueHolderInterface);
    }

    public Object valueFromRow(Object object) {
        return this.buildContainer(new ValueHolder(object));
    }
}

