/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.IdentificationVariableDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.QueryNode;
import org.eclipse.persistence.queries.DatabaseQuery;

public abstract class ModifyNode
extends QueryNode {
    private String abstractSchemaIdentifier;
    private String abstractSchemaName;

    public void applyToQuery(DatabaseQuery databaseQuery, GenerationContext generationContext) {
    }

    public void validate(ParseTreeContext parseTreeContext) {
        String string = this.getCanonicalAbstractSchemaIdentifier();
        parseTreeContext.setBaseVariable(string);
        super.validate(parseTreeContext);
    }

    public Expression generateExpression(GenerationContext generationContext) {
        return null;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public void setAbstractSchemaName(String string) {
        this.abstractSchemaName = string;
    }

    public String getAbstractSchemaIdentifier() {
        return this.abstractSchemaIdentifier;
    }

    public void setAbstractSchemaIdentifier(String string) {
        this.abstractSchemaIdentifier = string;
    }

    public String getCanonicalAbstractSchemaIdentifier() {
        String string = this.abstractSchemaIdentifier != null ? this.abstractSchemaIdentifier : this.abstractSchemaName;
        return IdentificationVariableDeclNode.calculateCanonicalName(string);
    }

    public Class resolveClass(GenerationContext generationContext) {
        String string = this.abstractSchemaName;
        ClassDescriptor classDescriptor = generationContext.getSession().getDescriptorForAlias(string);
        if (classDescriptor == null) {
            throw JPQLException.entityTypeNotFound2(generationContext.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), string);
        }
        Class clazz = classDescriptor.getJavaClass();
        if (clazz == null) {
            throw JPQLException.resolutionClassNotFoundException2(generationContext.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), string);
        }
        return clazz;
    }
}

