/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;

public class ReferenceResolver {
    public static final String KEY = "REFERENCE_RESOLVER";
    private ArrayList references = new ArrayList();

    public static ReferenceResolver getInstance(Session session) {
        if (session == null) {
            return null;
        }
        return (ReferenceResolver)session.getProperty(KEY);
    }

    public void addReference(Reference reference) {
        this.references.add(reference);
    }

    private void createPKVectorsFromMap(Reference reference) {
        XMLCollectionReferenceMapping xMLCollectionReferenceMapping = (XMLCollectionReferenceMapping)reference.getMapping();
        Vector vector = new Vector();
        Vector<String> vector2 = xMLCollectionReferenceMapping.getReferenceDescriptor().getPrimaryKeyFieldNames();
        if (vector2.size() <= 0) {
            return;
        }
        boolean bl = true;
        Iterator<String> iterator = vector2.iterator();
        while (iterator.hasNext()) {
            int n;
            Vector vector3 = (Vector)reference.getPrimaryKeyMap().get(iterator.next());
            if (vector3 == null) {
                return;
            }
            if (bl) {
                for (n = 0; n < vector3.size(); ++n) {
                    vector.add(new Vector());
                }
                bl = false;
            }
            for (n = 0; n < vector3.size(); ++n) {
                Object e = vector3.get(n);
                ((Vector)vector.get(n)).add(e);
            }
        }
        reference.primaryKeys = vector;
    }

    public Reference getReference(XMLObjectReferenceMapping xMLObjectReferenceMapping, Object object) {
        for (int i = 0; i < this.references.size(); ++i) {
            Reference reference = (Reference)this.references.get(i);
            if (reference.getMapping() != xMLObjectReferenceMapping || reference.getSourceObject() != object) continue;
            return reference;
        }
        return null;
    }

    public void resolveReferences(AbstractSession abstractSession) {
        for (int i = 0; i < this.references.size(); ++i) {
            Object object;
            Reference reference = (Reference)this.references.get(i);
            if (reference.getMapping() instanceof XMLCollectionReferenceMapping) {
                object = (XMLCollectionReferenceMapping)reference.getMapping();
                ContainerPolicy containerPolicy = ((XMLCollectionReferenceMapping)object).getContainerPolicy();
                Object object2 = containerPolicy.containerInstance();
                this.createPKVectorsFromMap(reference);
                for (Vector vector : reference.getPrimaryKeys()) {
                    Object object3 = abstractSession.getIdentityMapAccessor().getFromIdentityMap(vector, reference.getTargetClass());
                    if (object3 == null) continue;
                    containerPolicy.addInto(object3, object2, abstractSession);
                }
                ((DatabaseMapping)object).setAttributeValueInObject(reference.getSourceObject(), object2);
                continue;
            }
            if (!(reference.getMapping() instanceof XMLObjectReferenceMapping)) continue;
            object = abstractSession.getIdentityMapAccessor().getFromIdentityMap(reference.getPrimaryKeys(), reference.getTargetClass());
            if (object != null) {
                ((XMLObjectReferenceMapping)reference.getMapping()).setAttributeValueInObject(reference.getSourceObject(), object);
            }
            if (null == reference.getSetting()) continue;
            reference.getSetting().setValue(object);
        }
        if (abstractSession.isUnitOfWork()) {
            ((UnitOfWork)((Object)abstractSession)).release();
        }
        this.references = new ArrayList();
    }
}

