/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.Securable;

public class JCEEncryptor
implements Securable {
    private Cipher encryptCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
    private Cipher decryptCipher;

    public JCEEncryptor() throws Exception {
        this.encryptCipher.init(1, Synergizer.getMultitasker("DES"));
        this.decryptCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        this.decryptCipher.init(2, Synergizer.getMultitasker("DES"));
    }

    public String encryptPassword(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, this.encryptCipher);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(cipherOutputStream);
            objectOutputStream.writeObject(string);
            objectOutputStream.flush();
            objectOutputStream.close();
            return Helper.buildHexStringFromBytes(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw ValidationException.errorEncryptingPassword(exception);
        }
    }

    public String decryptPassword(String string) {
        String string2 = "";
        try {
            byte[] byArray = Helper.buildBytesFromHexString(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, this.decryptCipher);
            ObjectInputStream objectInputStream = new ObjectInputStream(cipherInputStream);
            string2 = (String)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            string2 = string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string2 = string;
        }
        catch (ConversionException conversionException) {
            string2 = string;
        }
        catch (Exception exception) {
            throw ValidationException.errorDecryptingPassword(exception);
        }
        return string2;
    }

    private static class Synergizer {
        private Synergizer() {
        }

        private static SecretKey getMultitasker(String string) throws Exception {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
            return secretKeyFactory.generateSecret(new DESKeySpec(Helper.buildBytesFromHexString("E60B80C7AEC78038")));
        }
    }
}

