/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.sessions.Record;

public abstract class AbstractRecord
implements Record,
Cloneable,
Serializable,
Map {
    protected Vector fields;
    protected Vector values;
    protected DatabaseField lookupField;
    protected int size;
    public static final NoEntry noEntry = new NoEntry();

    public AbstractRecord() {
        this.fields = new NonSynchronizedVector();
        this.values = new NonSynchronizedVector();
        this.size = 0;
    }

    public AbstractRecord(int n) {
        this.fields = new NonSynchronizedVector(n);
        this.values = new NonSynchronizedVector(n);
        this.size = 0;
    }

    public AbstractRecord(Vector vector, Vector vector2) {
        this.fields = vector;
        this.values = vector2;
        this.resetSize();
    }

    protected void resetSize() {
        this.size = this.fields == null ? 0 : this.fields.size();
    }

    public void add(DatabaseField databaseField, Object object) {
        this.fields.add(databaseField);
        this.values.add(object);
        ++this.size;
    }

    public void clear() {
        this.fields = new Vector();
        this.values = new Vector();
        this.resetSize();
    }

    public Object clone() {
        try {
            AbstractRecord abstractRecord = (AbstractRecord)super.clone();
            abstractRecord.setFields((Vector)this.getFields().clone());
            abstractRecord.setValues((Vector)this.getValues().clone());
            return abstractRecord;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsKey(Object object) {
        if (object instanceof String) {
            return this.containsKey((String)object);
        }
        if (object instanceof DatabaseField) {
            return this.containsKey((DatabaseField)object);
        }
        return false;
    }

    public boolean containsKey(String string) {
        if (this.lookupField == null) {
            this.lookupField = new DatabaseField(string);
        } else {
            this.lookupField.resetQualifiedName(string);
        }
        return this.containsKey(this.lookupField);
    }

    public boolean containsKey(DatabaseField databaseField) {
        DatabaseField databaseField2;
        int n = databaseField.getIndex();
        if (n >= 0 && n < this.size && ((databaseField2 = (DatabaseField)this.fields.get(n)) == databaseField || databaseField2.equals(databaseField))) {
            return true;
        }
        return this.fields.contains(databaseField);
    }

    public boolean containsValue(Object object) {
        return this.getValues().contains(object);
    }

    public Enumeration elements() {
        return this.getValues().elements();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public Object get(Object object) {
        if (object instanceof String) {
            return this.get((String)object);
        }
        if (object instanceof DatabaseField) {
            return this.get((DatabaseField)object);
        }
        return null;
    }

    public Object get(String string) {
        Object object = this.getIndicatingNoEntry(string);
        if (object == noEntry) {
            return null;
        }
        return object;
    }

    public Object getIndicatingNoEntry(String string) {
        if (this.lookupField == null) {
            this.lookupField = new DatabaseField(string);
        } else {
            this.lookupField.resetQualifiedName(string);
        }
        return this.getIndicatingNoEntry(this.lookupField);
    }

    public Object get(DatabaseField databaseField) {
        DatabaseField databaseField2;
        int n = databaseField.getIndex();
        if (n >= 0 && n < this.size && ((databaseField2 = (DatabaseField)this.fields.get(n)) == databaseField || databaseField2.equals(databaseField))) {
            return this.values.get(n);
        }
        n = this.fields.indexOf(databaseField);
        if (n >= 0) {
            if (n == -1) {
                databaseField.setIndex(n);
            }
            return this.values.get(n);
        }
        return null;
    }

    public Object getValues(DatabaseField databaseField) {
        return this.get(databaseField);
    }

    public Object getValues(String string) {
        return this.get(string);
    }

    public Object getIndicatingNoEntry(DatabaseField databaseField) {
        DatabaseField databaseField2;
        int n = databaseField.getIndex();
        if (n >= 0 && n < this.size && ((databaseField2 = (DatabaseField)this.fields.get(n)) == databaseField || databaseField2.equals(databaseField))) {
            return this.values.get(n);
        }
        n = this.fields.indexOf(databaseField);
        if (n >= 0) {
            if (n == -1) {
                databaseField.setIndex(n);
            }
            return this.values.get(n);
        }
        return noEntry;
    }

    public DatabaseField getField(DatabaseField databaseField) {
        DatabaseField databaseField2;
        int n = databaseField.getIndex();
        if (n >= 0 && n < this.getFields().size() && ((databaseField2 = (DatabaseField)this.getFields().elementAt(n)) == databaseField || databaseField2.equals(databaseField))) {
            return databaseField2;
        }
        for (n = 0; n < this.getFields().size(); ++n) {
            databaseField2 = (DatabaseField)this.getFields().elementAt(n);
            if (databaseField2 != databaseField && !databaseField2.equals(databaseField)) continue;
            return databaseField2;
        }
        return null;
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration keys() {
        return this.getFields().elements();
    }

    public Set keySet() {
        return new KeySet();
    }

    public void mergeFrom(AbstractRecord abstractRecord) {
        for (int i = 0; i < abstractRecord.size(); ++i) {
            this.put(abstractRecord.getFields().get(i), abstractRecord.getValues().get(i));
        }
    }

    public Object put(Object object, Object object2) throws ValidationException {
        if (object instanceof String) {
            return this.put((String)object, object2);
        }
        if (object instanceof DatabaseField) {
            return this.put((DatabaseField)object, object2);
        }
        throw ValidationException.onlyFieldsAreValidKeysForDatabaseRows();
    }

    public Object put(String string, Object object) {
        return this.put(new DatabaseField(string), object);
    }

    public Object put(DatabaseField databaseField, Object object) {
        int n = this.fields.indexOf(databaseField);
        if (n >= 0) {
            return this.values.set(n, object);
        }
        this.add(databaseField, object);
        return null;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        if (object instanceof String) {
            return this.remove((String)object);
        }
        if (object instanceof DatabaseField) {
            return this.remove((DatabaseField)object);
        }
        return null;
    }

    public Object remove(String string) {
        return this.remove(new DatabaseField(string));
    }

    public Object remove(DatabaseField databaseField) {
        int n = this.getFields().indexOf(databaseField);
        if (n >= 0) {
            this.getFields().removeElementAt(n);
            Object e = this.getValues().elementAt(n);
            this.getValues().removeElementAt(n);
            this.resetSize();
            return e;
        }
        return null;
    }

    public void replaceAt(Object object, int n) {
        this.values.set(n, object);
    }

    protected void setFields(Vector vector) {
        this.fields = vector;
        this.resetSize();
    }

    protected void setValues(Vector vector) {
        this.values = vector;
    }

    public int size() {
        return this.fields.size();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Helper.getShortClassName(this.getClass()));
        stringWriter.write("(");
        for (int i = 0; i < this.getFields().size(); ++i) {
            stringWriter.write(Helper.cr());
            stringWriter.write("\t");
            stringWriter.write(String.valueOf(this.getFields().elementAt(i)));
            stringWriter.write(" => ");
            stringWriter.write(String.valueOf(this.getValues().elementAt(i)));
        }
        stringWriter.write(")");
        return stringWriter.toString();
    }

    public Collection values() {
        return new ValuesSet();
    }

    protected class EntrySet
    extends AbstractSet {
        protected EntrySet() {
        }

        public Iterator iterator() {
            return new RecordEntryIterator();
        }

        public int size() {
            return AbstractRecord.this.size();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            return AbstractRecord.this.containsKey(((Map.Entry)object).getKey());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            AbstractRecord.this.remove(((Map.Entry)object).getKey());
            return true;
        }

        public void clear() {
            AbstractRecord.this.clear();
        }
    }

    protected class KeySet
    extends EntrySet {
        protected KeySet() {
        }

        public Iterator iterator() {
            return new RecordKeyIterator();
        }

        public boolean contains(Object object) {
            return AbstractRecord.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return AbstractRecord.this.remove(object) != null;
        }
    }

    public static class NoEntry {
        private NoEntry() {
        }
    }

    protected static class RecordEntry
    implements Map.Entry {
        Object key;
        Object value;

        public RecordEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.compare(this.key, entry.getKey()) && this.compare(this.value, entry.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private boolean compare(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }

    protected class RecordEntryIterator
    implements Iterator {
        int index = 0;

        RecordEntryIterator() {
        }

        public boolean hasNext() {
            return this.index < AbstractRecord.this.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return new RecordEntry(AbstractRecord.this.getFields().get(this.index - 1), AbstractRecord.this.getValues().get(this.index - 1));
        }

        public void remove() {
            if (this.index >= AbstractRecord.this.size()) {
                throw new IllegalStateException();
            }
            AbstractRecord.this.remove(AbstractRecord.this.getFields().get(this.index));
        }
    }

    protected class RecordKeyIterator
    extends RecordEntryIterator {
        protected RecordKeyIterator() {
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return AbstractRecord.this.getFields().get(this.index - 1);
        }
    }

    protected class RecordValuesIterator
    extends RecordEntryIterator {
        protected RecordValuesIterator() {
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return AbstractRecord.this.getValues().get(this.index - 1);
        }
    }

    protected class ValuesSet
    extends EntrySet {
        protected ValuesSet() {
        }

        public Iterator iterator() {
            return new RecordValuesIterator();
        }

        public boolean contains(Object object) {
            return AbstractRecord.this.contains(object);
        }

        public boolean remove(Object object) {
            int n = AbstractRecord.this.getValues().indexOf(object);
            if (n == -1) {
                return false;
            }
            AbstractRecord.this.remove(AbstractRecord.this.getFields().get(n));
            return true;
        }
    }
}

