/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.factories.ReferenceMode;

public class RepeatableWriteUnitOfWork
extends UnitOfWorkImpl {
    protected UnitOfWorkChangeSet cumulativeUOWChangeSet;
    protected boolean shouldTerminateTransaction = true;
    protected transient String flushClearCache;
    protected boolean isWithinFlush;
    protected transient Set<Class> classesToBeInvalidated;

    public RepeatableWriteUnitOfWork(AbstractSession abstractSession, ReferenceMode referenceMode) {
        super(abstractSession, referenceMode);
        this.shouldNewObjectsBeCached = true;
        this.isWithinFlush = false;
    }

    public void clear(boolean bl) {
        super.clear(bl);
        if (this.cumulativeUOWChangeSet != null) {
            if (this.flushClearCache == "Drop") {
                this.cumulativeUOWChangeSet = null;
                this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
            } else if (this.flushClearCache == "DropInvalidate") {
                Set<Class> set = this.cumulativeUOWChangeSet.findUpdatedObjectsClasses();
                if (set != null) {
                    if (this.classesToBeInvalidated == null) {
                        this.classesToBeInvalidated = set;
                    } else {
                        this.classesToBeInvalidated.addAll(set);
                    }
                }
                if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null && !this.unregisteredDeletedObjectsCloneToBackupAndOriginal.isEmpty()) {
                    if (this.classesToBeInvalidated == null) {
                        this.classesToBeInvalidated = new HashSet<Class>();
                    }
                    Iterator iterator = this.unregisteredDeletedObjectsCloneToBackupAndOriginal.keySet().iterator();
                    while (iterator.hasNext()) {
                        this.classesToBeInvalidated.add(iterator.next().getClass());
                    }
                }
                this.cumulativeUOWChangeSet = null;
                this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
            }
        }
    }

    public void clearForClose(boolean bl) {
        this.cumulativeUOWChangeSet = null;
        this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
        super.clearForClose(bl);
    }

    public boolean shouldClearForCloseOnRelease() {
        return true;
    }

    protected ClassDescriptor checkHierarchyForDescriptor(Class clazz) {
        ClassDescriptor classDescriptor = this.getDescriptor(clazz.getSuperclass());
        if (classDescriptor != null && classDescriptor.getInheritancePolicy().getDescribesNonPersistentSubclasses()) {
            return classDescriptor;
        }
        return null;
    }

    public void commitRootUnitOfWork() throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithChangeSet(false);
        if (this.cumulativeUOWChangeSet != null) {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
            this.setUnitOfWorkChangeSet(this.cumulativeUOWChangeSet);
        }
        this.commitTransactionAfterWriteChanges();
        this.mergeChangesIntoParent();
    }

    public void discoverUnregisteredNewObjects(Map map, Map map2, Map map3, Map map4) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            this.discoverAndPersistUnregisteredNewObjects(iterator.next(), false, map2, map3, map4);
        }
    }

    public boolean isAfterWriteChangesButBeforeCommit() {
        return this.getLifecycle() == 2;
    }

    public boolean isObjectDeleted(Object object) {
        if (super.isObjectDeleted(object)) {
            return true;
        }
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null && this.unregisteredDeletedObjectsCloneToBackupAndOriginal.containsKey(object)) {
            return true;
        }
        if (this.hasObjectsDeletedDuringCommit()) {
            return this.getObjectsDeletedDuringCommit().containsKey(object);
        }
        return false;
    }

    public void issueSQLbeforeCompletion() {
        super.issueSQLbeforeCompletion(false);
        if (this.cumulativeUOWChangeSet != null) {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
            this.setUnitOfWorkChangeSet(this.cumulativeUOWChangeSet);
        }
        this.commitTransactionAfterWriteChanges();
    }

    protected void mergeChangesIntoParent() {
        if (this.classesToBeInvalidated != null) {
            IdentityMapAccessor identityMapAccessor = this.getParentIdentityMapSession(null, false, true).getIdentityMapAccessor();
            Iterator<Class> iterator = this.classesToBeInvalidated.iterator();
            while (iterator.hasNext()) {
                identityMapAccessor.invalidateClass(iterator.next(), false);
            }
            this.classesToBeInvalidated = null;
        }
        super.mergeChangesIntoParent();
    }

    public Object mergeCloneWithReferences(Object object, MergeManager mergeManager) {
        Object object2 = super.mergeCloneWithReferences(object, mergeManager);
        IdentityHashMap identityHashMap = mergeManager.getMergedNewObjects();
        if (!identityHashMap.isEmpty()) {
            for (Object v : identityHashMap.values()) {
                ClassDescriptor classDescriptor;
                if (this.assignSequenceNumber(v, classDescriptor = this.getDescriptor(v)) == null) continue;
                this.registerNewObjectInIdentityMap(v, null, classDescriptor);
            }
        }
        return object2;
    }

    public void updateChangeTrackersIfRequired(Object object, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
        classDescriptor.getObjectChangePolicy().updateWithChanges(object, objectChangeSet, unitOfWorkImpl, classDescriptor);
    }

    public void writeChanges() {
        if (this.isWithinFlush()) {
            AbstractSessionLog.getLog().log(6, "nested_entity_manager_flush_not_executed_pre_query_changes_may_be_pending", this.getClass().getSimpleName());
            return;
        }
        if (this.unitOfWorkChangeSet == null) {
            this.unitOfWorkChangeSet = new UnitOfWorkChangeSet(this);
        }
        this.isWithinFlush = true;
        UnitOfWorkChangeSet unitOfWorkChangeSet = this.unitOfWorkChangeSet;
        this.calculateChanges(this.getCloneMapping(), unitOfWorkChangeSet, false);
        if (!(unitOfWorkChangeSet.hasChanges() || unitOfWorkChangeSet.hasForcedChanges() || this.hasDeletedObjects() || this.hasModifyAllQueries())) {
            this.isWithinFlush = false;
            return;
        }
        try {
            try {
                this.commitToDatabaseWithPreBuiltChangeSet(unitOfWorkChangeSet, false);
                this.writesCompleted();
            }
            catch (RuntimeException runtimeException) {
                this.clearFlushClearCache();
                this.setLifecycle(3);
                throw runtimeException;
            }
            Object var4_2 = null;
            this.isWithinFlush = false;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.isWithinFlush = false;
            throw throwable;
        }
        if (this.cumulativeUOWChangeSet == null) {
            this.cumulativeUOWChangeSet = unitOfWorkChangeSet;
        } else {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet(unitOfWorkChangeSet, this, true);
        }
        this.resumeUnitOfWork();
    }

    protected void registerNotRegisteredNewObjectForPersist(Object object, ClassDescriptor classDescriptor) {
        Object[] objectArray;
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null && (objectArray = (Object[])this.unregisteredDeletedObjectsCloneToBackupAndOriginal.remove(object)) != null) {
            this.getCloneMapping().put(object, objectArray[0]);
            this.registerNewObjectClone(object, objectArray[1], classDescriptor);
            this.registerNewObjectInIdentityMap(object, object, classDescriptor);
            return;
        }
        super.registerNotRegisteredNewObjectForPersist(object, classDescriptor);
    }

    public void rollbackTransaction() throws DatabaseException {
        if (this.shouldTerminateTransaction || this.getParent().getTransactionMutex().isNested()) {
            super.rollbackTransaction();
        } else {
            this.setWasTransactionBegunPrematurely(true);
        }
    }

    public void synchronizeAndResume() {
        this.cumulativeUOWChangeSet = null;
        this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
        super.synchronizeAndResume();
    }

    public boolean wasDeleted(Object object) {
        return this.getUnregisteredDeletedCloneForOriginal(object) != null;
    }

    protected Object cloneAndRegisterNewObject(Object object) {
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        if (this.isNestedUnitOfWork() && classDescriptor.getObjectChangePolicy() instanceof AttributeChangeTrackingPolicy) {
            throw ValidationException.nestedUOWNotSupportedForAttributeTracking();
        }
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object2 = objectBuilder.instantiateWorkingCopyClone(object, this);
        Object object3 = objectBuilder.buildNewInstance();
        this.getNewObjectsOriginalToClone().put(object, object2);
        this.getCloneMapping().put(object2, object2);
        objectBuilder.populateAttributesForClone(object, object2, this);
        this.registerNewObjectClone(object2, object3, classDescriptor);
        Object object4 = classDescriptor.getObjectChangePolicy().buildBackupClone(object2, objectBuilder, this);
        this.getCloneMapping().put(object2, object4);
        return object2;
    }

    public Object getUnregisteredDeletedCloneForOriginal(Object object) {
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null) {
            Iterator iterator = this.unregisteredDeletedObjectsCloneToBackupAndOriginal.keySet().iterator();
            Iterator iterator2 = this.unregisteredDeletedObjectsCloneToBackupAndOriginal.values().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object[] objectArray = (Object[])iterator2.next();
                Object object2 = objectArray[1];
                if (object != object2) continue;
                return k;
            }
        }
        return null;
    }

    protected void commitToDatabase(boolean bl) {
        try {
            super.commitToDatabase(bl);
        }
        catch (OptimisticLockException optimisticLockException) {
            throw new javax.persistence.OptimisticLockException((Throwable)optimisticLockException);
        }
    }

    public void commitTransaction() throws DatabaseException {
        if (this.shouldTerminateTransaction || this.getParent().getTransactionMutex().isNested()) {
            super.commitTransaction();
        }
    }

    public void setShouldTerminateTransaction(boolean bl) {
        this.shouldTerminateTransaction = bl;
    }

    public void clearFlushClearCache() {
        this.classesToBeInvalidated = null;
    }

    public String getFlushClearCache() {
        return this.flushClearCache;
    }

    public void setFlushClearCache(String string) {
        this.flushClearCache = string;
    }

    public boolean isWithinFlush() {
        return this.isWithinFlush;
    }
}

