/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.weaving.AttributeDetails;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDetails {
    protected Class describedClass;
    protected String className;
    protected String superClassName;
    protected ClassDetails superClassDetails;
    protected boolean shouldWeaveValueHolders = false;
    protected boolean shouldWeaveChangeTracking = false;
    protected boolean shouldWeaveFetchGroups = false;
    protected boolean shouldWeaveInternal = false;
    protected Map<String, AttributeDetails> attributesMap;
    protected Map<String, AttributeDetails> getterMethodToAttributeDetails;
    protected Map<String, AttributeDetails> setterMethodToAttributeDetails;
    protected List<DatabaseMapping> lazyMappings;
    protected boolean isMappedSuperClass = false;
    protected boolean isEmbedable = false;
    protected Boolean usesAttributeAccess = null;
    protected boolean implementsCloneMethod = false;

    public Class getDescribedClass() {
        return this.describedClass;
    }

    public String getClassName() {
        return this.className;
    }

    public void setDescribedClass(Class clazz) {
        this.describedClass = clazz;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String string) {
        this.superClassName = string;
    }

    public ClassDetails getSuperClassDetails() {
        return this.superClassDetails;
    }

    public void setSuperClassDetails(ClassDetails classDetails) {
        this.superClassDetails = classDetails;
    }

    public boolean shouldWeaveValueHolders() {
        return this.shouldWeaveValueHolders;
    }

    public void setShouldWeaveValueHolders(boolean bl) {
        this.shouldWeaveValueHolders = bl;
    }

    public boolean shouldWeaveChangeTracking() {
        return this.shouldWeaveChangeTracking;
    }

    public void setShouldWeaveChangeTracking(boolean bl) {
        this.shouldWeaveChangeTracking = bl;
    }

    public boolean shouldWeaveFetchGroups() {
        return this.shouldWeaveFetchGroups;
    }

    public void setShouldWeaveFetchGroups(boolean bl) {
        this.shouldWeaveFetchGroups = bl;
    }

    public boolean shouldWeaveInternal() {
        return this.shouldWeaveInternal;
    }

    public void setShouldWeaveInternal(boolean bl) {
        this.shouldWeaveInternal = bl;
    }

    public Map<String, AttributeDetails> getAttributesMap() {
        return this.attributesMap;
    }

    public Map<String, AttributeDetails> getGetterMethodToAttributeDetails() {
        return this.getterMethodToAttributeDetails;
    }

    public List<DatabaseMapping> getLazyMappings() {
        return this.lazyMappings;
    }

    public Map<String, AttributeDetails> getSetterMethodToAttributeDetails() {
        return this.setterMethodToAttributeDetails;
    }

    public void setAttributesMap(Map<String, AttributeDetails> map) {
        this.attributesMap = map;
    }

    public void setGetterMethodToAttributeDetails(Map<String, AttributeDetails> map) {
        this.getterMethodToAttributeDetails = map;
    }

    public void setLazyMappings(List<DatabaseMapping> list) {
        this.lazyMappings = list;
    }

    public boolean getImplementsCloneMethod() {
        return this.implementsCloneMethod;
    }

    public void setImplementsCloneMethod(boolean bl) {
        this.implementsCloneMethod = bl;
    }

    public String getNameOfSuperclassImplementingCloneMethod() {
        if (this.superClassDetails == null) {
            return null;
        }
        if (this.superClassDetails.getImplementsCloneMethod()) {
            return this.superClassDetails.getClassName();
        }
        return this.superClassDetails.getNameOfSuperclassImplementingCloneMethod();
    }

    public boolean isMappedSuperClass() {
        return this.isMappedSuperClass;
    }

    public void setIsMappedSuperClass(boolean bl) {
        this.isMappedSuperClass = bl;
    }

    public boolean isEmbedable() {
        return this.isEmbedable;
    }

    public void setIsEmbedable(boolean bl) {
        this.isEmbedable = bl;
    }

    public void setSetterMethodToAttributeDetails(Map map) {
        this.setterMethodToAttributeDetails = map;
    }

    public boolean usesAttributeAccess() {
        if (this.usesAttributeAccess != null) {
            return this.usesAttributeAccess;
        }
        for (AttributeDetails attributeDetails : this.attributesMap.values()) {
            if (!attributeDetails.isMappedWithAttributeAccess()) continue;
            this.usesAttributeAccess = Boolean.TRUE;
            return true;
        }
        if (this.getSuperClassDetails() != null) {
            return this.getSuperClassDetails().usesAttributeAccess();
        }
        this.usesAttributeAccess = Boolean.FALSE;
        return false;
    }

    public AttributeDetails getAttributeDetailsFromClassOrSuperClass(String string) {
        AttributeDetails attributeDetails = this.attributesMap.get(string);
        if (attributeDetails == null && this.superClassDetails != null) {
            return this.superClassDetails.getAttributeDetailsFromClassOrSuperClass(string);
        }
        return attributeDetails;
    }

    public boolean doesSuperclassWeaveChangeTracking() {
        if (this.getSuperClassDetails() == null) {
            return false;
        }
        if (this.getSuperClassDetails().shouldWeaveChangeTracking()) {
            return true;
        }
        return this.getSuperClassDetails().doesSuperclassWeaveChangeTracking();
    }

    public boolean canWeaveChangeTracking() {
        if (this.getSuperClassDetails() == null || !this.shouldWeaveChangeTracking()) {
            return this.shouldWeaveChangeTracking();
        }
        return this.getSuperClassDetails().canWeaveChangeTracking();
    }

    public boolean isInMetadataHierarchy(String string) {
        if (string.equals(Object.class.getName().replace('.', '/'))) {
            return true;
        }
        if (string.equals(this.className) || this.superClassName != null && string.equals(this.superClassName)) {
            return true;
        }
        if (this.superClassDetails != null) {
            return this.superClassDetails.isInMetadataHierarchy(string);
        }
        return false;
    }

    public boolean isInSuperclassHierarchy(String string) {
        if (string.equals(Object.class.getName().replace('.', '/'))) {
            return true;
        }
        if (this.superClassName != null && string.equals(this.superClassName)) {
            return true;
        }
        if (this.superClassDetails != null) {
            return this.superClassDetails.isInMetadataHierarchy(string);
        }
        return false;
    }
}

