/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.weaving.AbstractStaticWeaveOutputHandler;

public class StaticWeaveDirectoryOutputHandler
extends AbstractStaticWeaveOutputHandler {
    private URL source = null;
    private URL target = null;

    public StaticWeaveDirectoryOutputHandler(URL uRL, URL uRL2) {
        this.source = uRL;
        this.target = uRL2;
    }

    public void addDirEntry(String string) throws IOException {
        File file = new File(this.target.getPath() + File.separator + string).getAbsoluteFile();
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void addEntry(JarEntry jarEntry, byte[] byArray) throws IOException {
        File file = new File(this.target.getPath() + jarEntry.getName()).getAbsoluteFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        new FileOutputStream(file).write(byArray);
    }

    public void addEntry(InputStream inputStream, JarEntry jarEntry) throws IOException, URISyntaxException {
        File file = new File(this.target.getPath() + jarEntry.getName()).getAbsoluteFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        if (new File(Helper.toURI(this.source)).isDirectory()) {
            File file2 = new File(this.source.getPath() + jarEntry.getName());
            FileInputStream fileInputStream = new FileInputStream(file2);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            new FileOutputStream(file).write(byArray);
        } else {
            this.readwriteStreams(inputStream, new FileOutputStream(file));
        }
    }
}

