/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.UnitOfWorkQueryValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ObjectReferenceChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectReferenceMapping
extends ForeignReferenceMapping {
    protected boolean isForeignKeyRelationship;
    protected Vector<DatabaseField> foreignKeyFields;

    protected ObjectReferenceMapping() {
    }

    @Override
    public Object buildBackupCloneForPartObject(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl) {
        return object;
    }

    @Override
    public Object buildCloneForPartObject(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        if (object == null) {
            return null;
        }
        Object object4 = null;
        if (bl) {
            object4 = unitOfWorkImpl.registerExistingObject(object);
        } else {
            object4 = unitOfWorkImpl.registerObject(object);
            if (this.isCandidateForPrivateOwnedRemoval() && unitOfWorkImpl.shouldDiscoverNewObjects() && object4 != null && unitOfWorkImpl.isObjectNew(object4)) {
                unitOfWorkImpl.addPrivateOwnedObject(this, object4);
            }
        }
        return object4;
    }

    @Override
    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
        Object v;
        Object object3 = this.getRealAttributeValueFromObject(object2, objectCopyingPolicy.getSession());
        if (object3 != null && (objectCopyingPolicy.shouldCascadeAllParts() || objectCopyingPolicy.shouldCascadePrivateParts() && this.isPrivateOwned())) {
            object3 = objectCopyingPolicy.getSession().copyObject(object3, objectCopyingPolicy);
        } else if (object3 != null && (v = objectCopyingPolicy.getCopies().get(object3)) != null) {
            object3 = v;
        }
        this.setRealAttributeValueInObject(object, object3);
    }

    @Override
    public Expression buildExpression(Object object, QueryByExamplePolicy queryByExamplePolicy, Expression expression, Map map, AbstractSession abstractSession) {
        String string = this.getAttributeName();
        Object object2 = this.getRealAttributeValueFromObject(object, abstractSession);
        if (!queryByExamplePolicy.shouldIncludeInQuery(object.getClass(), string, object2)) {
            return null;
        }
        if (object2 == null) {
            Expression expression2 = expression.get(string);
            return queryByExamplePolicy.completeExpressionForNull(expression2);
        }
        ObjectBuilder objectBuilder = this.getReferenceDescriptor().getObjectBuilder();
        return objectBuilder.buildExpressionFromExample(object2, queryByExamplePolicy, expression.get(string), map, abstractSession);
    }

    @Override
    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Object object3 = null;
        Object object4 = null;
        object3 = this.getAttributeValueFromObject(object);
        if (!objectChangeSet.isNew() && (object4 = this.getAttributeValueFromObject(object2)) == null && object3 == null) {
            return null;
        }
        if (object3 != null && !this.getIndirectionPolicy().objectIsInstantiated(object3)) {
            return null;
        }
        Object object5 = null;
        Object object6 = null;
        if (object3 != null) {
            object5 = this.getRealAttributeValueFromAttribute(object3, object, abstractSession);
        }
        if (object4 != null) {
            object6 = this.getRealAttributeValueFromAttribute(object4, object2, abstractSession);
        }
        if (object5 == object6 && !objectChangeSet.isNew()) {
            return null;
        }
        ObjectReferenceChangeRecord objectReferenceChangeRecord = this.internalBuildChangeRecord(object5, objectChangeSet, abstractSession);
        if (!objectChangeSet.isNew()) {
            objectReferenceChangeRecord.setOldValue(object6);
        }
        return objectReferenceChangeRecord;
    }

    public ObjectReferenceChangeRecord internalBuildChangeRecord(Object object, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        ObjectReferenceChangeRecord objectReferenceChangeRecord = new ObjectReferenceChangeRecord(objectChangeSet);
        objectReferenceChangeRecord.setAttribute(this.getAttributeName());
        objectReferenceChangeRecord.setMapping(this);
        this.setNewValueInChangeRecord(object, objectReferenceChangeRecord, objectChangeSet, abstractSession);
        return objectReferenceChangeRecord;
    }

    public void setNewValueInChangeRecord(Object object, ObjectReferenceChangeRecord objectReferenceChangeRecord, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        if (object != null) {
            ObjectChangeSet objectChangeSet2 = this.getDescriptorForTarget(object, abstractSession).getObjectBuilder().createObjectChangeSet(object, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), abstractSession);
            objectReferenceChangeRecord.setNewValue(objectChangeSet2);
        } else {
            objectReferenceChangeRecord.setNewValue(null);
        }
    }

    @Override
    protected boolean compareObjectsWithoutPrivateOwned(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = this.getRealAttributeValueFromObject(object, abstractSession);
        Object object4 = this.getRealAttributeValueFromObject(object2, abstractSession);
        if (object3 == null && object4 == null) {
            return true;
        }
        if (object3 == null || object4 == null) {
            return false;
        }
        Vector vector = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object3, abstractSession);
        Vector vector2 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object4, abstractSession);
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            Object e2 = vector2.elementAt(i);
            if (e == null && e2 == null) continue;
            if (e == null || e2 == null) {
                return false;
            }
            if (e.equals(e2)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean compareObjectsWithPrivateOwned(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = this.getRealAttributeValueFromObject(object, abstractSession);
        Object object4 = this.getRealAttributeValueFromObject(object2, abstractSession);
        return abstractSession.compareObjects(object3, object4);
    }

    @Override
    public void fixRealObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        Object object2 = this.getRealAttributeValueFromObject(object, remoteSession);
        object2 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object2, remoteSession);
        ObjectLevelReadQuery objectLevelReadQuery2 = objectLevelReadQuery;
        if (!objectLevelReadQuery2.shouldMaintainCache() && (!objectLevelReadQuery2.shouldCascadeParts() || objectLevelReadQuery2.shouldCascadePrivateParts() && !this.isPrivateOwned())) {
            objectLevelReadQuery2 = null;
        }
        Object object3 = remoteSession.getObjectCorrespondingTo(object2, map, map2, objectLevelReadQuery2);
        object3 = this.getReferenceDescriptor().getObjectBuilder().wrapObject(object3, remoteSession);
        this.setRealAttributeValueInObject(object, object3);
    }

    public ClassDescriptor getDescriptorForTarget(Object object, AbstractSession abstractSession) {
        return abstractSession.getDescriptor(object);
    }

    @Override
    public Object getRealAttributeValueFromAttribute(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = super.getRealAttributeValueFromAttribute(object, object2, abstractSession);
        object3 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object3, abstractSession);
        return object3;
    }

    @Override
    public boolean isObjectReferenceMapping() {
        return true;
    }

    @Override
    public void iterateOnRealAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        Object object2 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object, descriptorIterator.getSession());
        descriptorIterator.iterateReferenceObjectForMapping(object2, this);
    }

    @Override
    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet;
        Object object3 = null;
        if (this.shouldMergeCascadeParts(mergeManager) && (objectChangeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue()) != null) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                object3 = objectChangeSet.getTargetVersionOfSourceObject(mergeManager.getSession(), false);
                if (object3 == null && (objectChangeSet.isNew() || objectChangeSet.isAggregate()) && objectChangeSet.containsChangesFromSynchronization()) {
                    if (!mergeManager.getObjectsAlreadyMerged().containsKey(objectChangeSet)) {
                        Class clazz = objectChangeSet.getClassType(mergeManager.getSession());
                        object3 = mergeManager.getSession().getDescriptor(clazz).getObjectBuilder().buildNewInstance();
                        mergeManager.getObjectsAlreadyMerged().put(objectChangeSet, object3);
                    } else {
                        object3 = mergeManager.getObjectsAlreadyMerged().get(objectChangeSet);
                    }
                } else {
                    object3 = objectChangeSet.getTargetVersionOfSourceObject(mergeManager.getSession(), true);
                }
                if (objectChangeSet.containsChangesFromSynchronization()) {
                    mergeManager.mergeChanges(object3, objectChangeSet);
                }
                if (object3 == null) {
                    mergeManager.getSession().getIdentityMapAccessorInstance().invalidateObject(object);
                    return;
                }
            } else {
                mergeManager.mergeChanges(objectChangeSet.getUnitOfWorkClone(), objectChangeSet);
            }
        }
        if (object3 == null && ((ObjectReferenceChangeRecord)changeRecord).getNewValue() != null) {
            object3 = ((ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue()).getTargetVersionOfSourceObject(mergeManager.getSession());
        }
        if (this.isPrivateOwned() && object2 != null) {
            mergeManager.registerRemovedNewObjectIfRequired(this.getRealAttributeValueFromObject(object2, mergeManager.getSession()));
        }
        object3 = this.getReferenceDescriptor().getObjectBuilder().wrapObject(object3, mergeManager.getSession());
        this.setRealAttributeValueInObject(object, object3);
    }

    @Override
    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        if (bl && mergeManager.shouldMergeWorkingCopyIntoOriginal()) {
            if (!this.isAttributeValueInstantiated(object2)) {
                this.setAttributeValueInObject(object, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(object2), mergeManager.getSession()));
                return;
            }
            this.getIndirectionPolicy().reset(object);
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(object, object2, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(object) : !this.isAttributeValueInstantiated(object2)) {
            return;
        }
        Object object3 = this.getRealAttributeValueFromObject(object2, mergeManager.getSession());
        Object object4 = null;
        if (this.shouldMergeCascadeParts(mergeManager) && object3 != null) {
            if (mergeManager.getSession().isUnitOfWork() && ((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet() != null) {
                mergeManager.mergeChanges(mergeManager.getObjectToMerge(object3), (ObjectChangeSet)((UnitOfWorkChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet()).getObjectChangeSetForClone(object3));
            } else {
                mergeManager.mergeChanges(mergeManager.getObjectToMerge(object3), null);
            }
        }
        if (object3 != null) {
            object4 = mergeManager.getTargetVersionOfSourceObject(object3);
        }
        if ((mergeManager.shouldMergeCloneIntoWorkingCopy() || mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy()) && this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
            Object object5 = this.getRealAttributeValueFromObject(object, mergeManager.getSession());
            if (object5 != object4) {
                this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(object, this.getAttributeName(), object5, object4);
            } else {
                return;
            }
        }
        object4 = this.referenceDescriptor.getObjectBuilder().wrapObject(object4, mergeManager.getSession());
        this.setRealAttributeValueInObject(object, object4);
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        return this.getForeignKeyFields();
    }

    public Vector<DatabaseField> getForeignKeyFields() {
        return this.foreignKeyFields;
    }

    protected void setForeignKeyFields(Vector<DatabaseField> vector) {
        this.foreignKeyFields = vector;
        if (!vector.isEmpty()) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public boolean isForeignKeyRelationship() {
        return this.isForeignKeyRelationship;
    }

    public void setIsForeignKeyRelationship(boolean bl) {
        this.isForeignKeyRelationship = bl;
    }

    @Override
    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            this.insert(writeObjectQuery);
        }
    }

    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery objectLevelModifyQuery) throws DatabaseException {
        if (objectLevelModifyQuery.getSession().isUnitOfWork()) {
            if (objectLevelModifyQuery.getObjectChangeSet() != null) {
                ObjectReferenceChangeRecord objectReferenceChangeRecord = (ObjectReferenceChangeRecord)objectLevelModifyQuery.getObjectChangeSet().getChangesForAttributeNamed(this.getAttributeName());
                if (objectReferenceChangeRecord != null) {
                    return objectReferenceChangeRecord.getOldValue();
                }
            } else {
                return this.getRealAttributeValueFromObject(objectLevelModifyQuery.getBackupClone(), objectLevelModifyQuery.getSession());
            }
        }
        return null;
    }

    @Override
    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object;
        if (!this.isAttributeValueInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        if (this.isPrivateOwned() && (object = this.readPrivateOwnedForObject(writeObjectQuery)) != null) {
            writeObjectQuery.setProperty(this, object);
        }
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        this.update(writeObjectQuery);
    }

    @Override
    public void postCalculateChanges(org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord, UnitOfWorkImpl unitOfWorkImpl) {
        Object object = ((ObjectReferenceChangeRecord)changeRecord).getOldValue();
        unitOfWorkImpl.addDeletedPrivateOwnedObjects(this, object);
    }

    @Override
    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        Object object2 = this.getRealAttributeValueFromObject(object, unitOfWorkImpl);
        if (object2 != null) {
            this.referenceDescriptor.getObjectBuilder().recordPrivateOwnedRemovals(object2, unitOfWorkImpl, false);
        }
    }

    @Override
    public void postDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = deleteObjectQuery.getProperty(this);
        if (this.isForeignKeyRelationship() && object != null) {
            deleteObjectQuery.removeProperty(this);
            if (deleteObjectQuery.isCascadeOfAggregateDelete()) {
                deleteObjectQuery.getSession().getCommitManager().addObjectToDelete(object);
            } else {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(object);
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
        }
    }

    @Override
    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            this.insert(writeObjectQuery);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object;
        if (!this.isAttributeValueInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        if (!this.isForeignKeyRelationship()) {
            this.update(writeObjectQuery);
        }
        if ((object = writeObjectQuery.getProperty(this)) == null) {
            return;
        }
        writeObjectQuery.removeProperty(this);
        if (writeObjectQuery.getObjectChangeSet() == null) {
            Object object2 = this.getRealAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
            if (object != object2) {
                CacheKey cacheKey = null;
                CacheKey cacheKey2 = new CacheKey(new Vector());
                cacheKey = new CacheKey(this.getPrimaryKeyForObject(object, writeObjectQuery.getSession()));
                if (object2 != null) {
                    cacheKey2 = new CacheKey(this.getPrimaryKeyForObject(object2, writeObjectQuery.getSession()));
                }
                if (this.cacheKeysAreEqual(cacheKey, cacheKey2)) {
                    return;
                }
            } else {
                return;
            }
        }
        if (!writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            writeObjectQuery.getSession().deleteObject(object);
        }
    }

    @Override
    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        Cloneable cloneable;
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        Object object2 = null;
        object2 = this.readPrivateOwnedForObject(deleteObjectQuery);
        if (object2 != null && object2 != object) {
            cloneable = null;
            CacheKey cacheKey = new CacheKey(new Vector());
            cloneable = new CacheKey(this.getPrimaryKeyForObject(object2, deleteObjectQuery.getSession()));
            if (object != null) {
                cacheKey = new CacheKey(this.getPrimaryKeyForObject(object, deleteObjectQuery.getSession()));
            }
            if (!this.cacheKeysAreEqual(cacheKey, (CacheKey)cloneable) && object2 != null) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(object2);
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
        }
        if (!this.isForeignKeyRelationship()) {
            if (object != null) {
                cloneable = new DeleteObjectQuery();
                cloneable.setIsExecutionClone(true);
                cloneable.setObject(object);
                cloneable.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery((DatabaseQuery)cloneable);
            }
        } else if (object != null) {
            deleteObjectQuery.setProperty(this, object);
        }
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        this.cascadePerformRemoveIfRequired(object, unitOfWorkImpl, map, true);
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map, boolean bl) {
        Object object2 = null;
        object2 = bl ? this.getAttributeValueFromObject(object) : object;
        if (object2 != null && this.isCascadeRemove()) {
            if (bl) {
                object2 = this.getIndirectionPolicy().getRealAttributeValueFromObject(object, object2);
            }
            if (object2 != null && !map.containsKey(object2)) {
                map.put(object2, object2);
                unitOfWorkImpl.performRemove(object2, map);
            }
        }
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2;
        Object object3 = this.getAttributeValueFromObject(object);
        if (object3 != null && this.getIndirectionPolicy().objectIsInstantiated(object3) && !map.containsKey(object2 = this.getRealAttributeValueFromObject(object, unitOfWorkImpl))) {
            map.put(object2, object2);
            unitOfWorkImpl.performRemovePrivateOwnedObjectFromChangeSet(object2, map);
        }
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map map, Map map2, Map map3, UnitOfWorkImpl unitOfWorkImpl) {
        this.cascadeDiscoverAndPersistUnregisteredNewObjects(object, map, map2, map3, unitOfWorkImpl, true);
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map map, Map map2, Map map3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        Object object2 = null;
        object2 = bl ? this.getAttributeValueFromObject(object) : object;
        if (object2 != null && this.getIndirectionPolicy().objectIsInstantiated(object2)) {
            if (bl) {
                object2 = this.getIndirectionPolicy().getRealAttributeValueFromObject(object, object2);
            }
            if (unitOfWorkImpl.hasPrivateOwnedObjects()) {
                unitOfWorkImpl.removePrivateOwnedObject(this, object2);
            }
            unitOfWorkImpl.discoverAndPersistUnregisteredNewObjects(object2, this.isCascadePersist(), map, map2, map3);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        this.cascadeRegisterNewIfRequired(object, unitOfWorkImpl, map, true);
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map, boolean bl) {
        Object object2 = null;
        object2 = bl ? this.getAttributeValueFromObject(object) : object;
        if (object2 != null && this.isCascadePersist() && this.getIndirectionPolicy().objectIsInstantiated(object2)) {
            if (bl) {
                object2 = this.getIndirectionPolicy().getRealAttributeValueFromObject(object, object2);
            }
            unitOfWorkImpl.registerNewObjectForPersist(object2, map);
            if (this.isCandidateForPrivateOwnedRemoval() && unitOfWorkImpl.shouldDiscoverNewObjects()) {
                unitOfWorkImpl.addPrivateOwnedObject(this, object2);
            }
        }
    }

    protected boolean cacheKeysAreEqual(CacheKey cacheKey, CacheKey cacheKey2) {
        return cacheKey.equals(cacheKey2);
    }

    protected Vector getPrimaryKeyForObject(Object object, AbstractSession abstractSession) {
        return this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, abstractSession);
    }

    @Override
    public boolean hasConstraintDependency() {
        return this.isForeignKeyRelationship();
    }

    @Override
    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface valueHolderInterface, Object object, Object object2, AbstractRecord abstractRecord, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        Object object3;
        UnitOfWorkQueryValueHolder unitOfWorkQueryValueHolder = null;
        if (abstractRecord == null && this.isPrimaryKeyMapping()) {
            object3 = this.extractPrimaryKeyRowForSourceObject(object, unitOfWorkImpl);
            unitOfWorkQueryValueHolder = new UnitOfWorkQueryValueHolder(valueHolderInterface, object2, this, (AbstractRecord)object3, unitOfWorkImpl);
        } else {
            unitOfWorkQueryValueHolder = new UnitOfWorkQueryValueHolder(valueHolderInterface, object2, this, abstractRecord, unitOfWorkImpl);
        }
        if (bl && valueHolderInterface.isInstantiated()) {
            object3 = valueHolderInterface.getValue();
            unitOfWorkQueryValueHolder.privilegedSetValue(object3);
            unitOfWorkQueryValueHolder.setInstantiated();
        }
        return unitOfWorkQueryValueHolder;
    }

    public AbstractRecord extractPrimaryKeyRowForSourceObject(Object object, AbstractSession abstractSession) {
        AbstractRecord abstractRecord = this.getDescriptor().getObjectBuilder().createRecord(abstractSession);
        this.writeFromObjectIntoRow(object, abstractRecord, abstractSession);
        return abstractRecord;
    }

    public Vector extractPrimaryKeysForReferenceObject(Object object, AbstractSession abstractSession) {
        return this.getIndirectionPolicy().extractPrimaryKeyForReferenceObject(this.getAttributeValueFromObject(object), abstractSession);
    }

    public Vector extractPrimaryKeysForReferenceObjectFromRow(AbstractRecord abstractRecord) {
        return new Vector(1);
    }

    public Vector extractPrimaryKeysFromRealReferenceObject(Object object, AbstractSession abstractSession) {
        if (object == null) {
            return new Vector(1);
        }
        Object object2 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object, abstractSession);
        return this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object2, abstractSession);
    }

    @Override
    public void preInitialize(AbstractSession abstractSession) throws DescriptorException {
        super.preInitialize(abstractSession);
        if (this.getIndirectionPolicy() instanceof ProxyIndirectionPolicy && !((ProxyIndirectionPolicy)this.getIndirectionPolicy()).hasTargetInterfaces()) {
            this.useProxyIndirection();
        }
    }

    protected void insert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        if (object == null) {
            return;
        }
        ObjectChangeSet objectChangeSet = null;
        UnitOfWorkChangeSet unitOfWorkChangeSet = null;
        if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null && ((objectChangeSet = (ObjectChangeSet)(unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet()).getObjectChangeSetForClone(object)) == null || !objectChangeSet.isNew())) {
            return;
        }
        WriteObjectQuery writeObjectQuery2 = null;
        writeObjectQuery2 = this.isPrivateOwned() && (objectChangeSet == null || objectChangeSet.isNew()) ? new InsertObjectQuery() : new WriteObjectQuery();
        writeObjectQuery2.setIsExecutionClone(true);
        writeObjectQuery2.setObject(object);
        writeObjectQuery2.setObjectChangeSet(objectChangeSet);
        writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
        writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void update(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        Serializable serializable;
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        if (object == null) return;
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        if (objectChangeSet != null) {
            serializable = (ObjectReferenceChangeRecord)writeObjectQuery.getObjectChangeSet().getChangesForAttributeNamed(this.getAttributeName());
            if (serializable == null) return;
            objectChangeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)serializable).getNewValue();
            if (!objectChangeSet.isNew()) {
                return;
            }
        } else {
            serializable = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null && ((objectChangeSet = (ObjectChangeSet)((UnitOfWorkChangeSet)(serializable = (UnitOfWorkChangeSet)((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet())).getObjectChangeSetForClone(object)) == null || !objectChangeSet.isNew())) {
                return;
            }
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts() && objectChangeSet != null && !objectChangeSet.isNew()) return;
        serializable = new WriteObjectQuery();
        ((DatabaseQuery)serializable).setIsExecutionClone(true);
        ((ObjectLevelModifyQuery)serializable).setObject(object);
        ((ObjectLevelModifyQuery)serializable).setObjectChangeSet(objectChangeSet);
        ((DatabaseQuery)serializable).setCascadePolicy(writeObjectQuery.getCascadePolicy());
        writeObjectQuery.getSession().executeQuery((DatabaseQuery)serializable);
    }

    public void useProxyIndirection() {
        Class[] classArray = this.getReferenceClass().getInterfaces();
        if (!this.getReferenceClass().isInterface() && this.getReferenceClass().getSuperclass() == null) {
            this.setIndirectionPolicy(new ProxyIndirectionPolicy(classArray));
        } else {
            HashSet<Class> hashSet = new HashSet<Class>();
            if (this.getReferenceClass().getSuperclass() != null) {
                this.buildTargetInterfaces(this.getReferenceClass(), hashSet);
            }
            if (this.getReferenceClass().isInterface()) {
                hashSet.add(this.getReferenceClass());
            }
            classArray = hashSet.toArray(classArray);
            this.setIndirectionPolicy(new ProxyIndirectionPolicy(classArray));
        }
    }

    @Override
    public Object[] buildReferencesPKList(Object object, Object object2, AbstractSession abstractSession) {
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        Object object3 = this.getIndirectionPolicy().getRealAttributeValueFromObject(object, object2);
        Object[] objectArray = new Object[1];
        if (object3 != null) {
            Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object3, abstractSession);
            CMPPolicy cMPPolicy = classDescriptor.getCMPPolicy();
            objectArray[0] = cMPPolicy != null && cMPPolicy.isCMP3Policy() ? cMPPolicy.createPrimaryKeyInstance(vector) : vector;
        }
        return objectArray;
    }

    public Collection buildTargetInterfaces(Class clazz, Collection collection) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            collection.add(classArray[i]);
        }
        if (clazz.getSuperclass() == null) {
            return collection;
        }
        return this.buildTargetInterfaces(clazz.getSuperclass(), collection);
    }

    public void useProxyIndirection(Class[] classArray) {
        this.setIndirectionPolicy(new ProxyIndirectionPolicy(classArray));
    }

    public void useProxyIndirection(Class clazz) {
        Class[] classArray = new Class[]{clazz};
        this.setIndirectionPolicy(new ProxyIndirectionPolicy(classArray));
    }

    @Override
    public Object valueFromPKList(Object[] objectArray, AbstractSession abstractSession) {
        Vector vector = null;
        if (objectArray[0] == null) {
            return null;
        }
        vector = this.getReferenceDescriptor().hasCMPPolicy() ? this.getReferenceDescriptor().getCMPPolicy().createPkVectorFromKey(objectArray[0], abstractSession) : (Vector)objectArray[0];
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(this.getReferenceClass());
        readObjectQuery.setSelectionKey(vector);
        readObjectQuery.setIsExecutionClone(true);
        return abstractSession.executeQuery(readObjectQuery);
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession abstractSession) throws DatabaseException {
        Object object2;
        if (this.isPrivateOwned() && (object2 = this.getRealAttributeValueFromObject(object, abstractSession)) != null) {
            return abstractSession.verifyDelete(object2);
        }
        return true;
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, AbstractRecord abstractRecord) {
        Object object = writeObjectQuery.getObject();
        AbstractSession abstractSession = writeObjectQuery.getSession();
        if (!this.isAttributeValueInstantiated(object)) {
            return;
        }
        if (abstractSession.isUnitOfWork() && this.compareObjectsWithoutPrivateOwned(writeObjectQuery.getBackupClone(), object, abstractSession)) {
            return;
        }
        this.writeFromObjectIntoRow(object, abstractRecord, abstractSession);
    }

    @Override
    public void writeFromObjectIntoRowForWhereClause(ObjectLevelModifyQuery objectLevelModifyQuery, AbstractRecord abstractRecord) {
        if (this.isReadOnly()) {
            return;
        }
        if (objectLevelModifyQuery.isDeleteObjectQuery()) {
            this.writeFromObjectIntoRow(objectLevelModifyQuery.getObject(), abstractRecord, objectLevelModifyQuery.getSession());
        } else if (this.isAttributeValueInstantiated(objectLevelModifyQuery.getObject())) {
            this.writeFromObjectIntoRow(objectLevelModifyQuery.getBackupClone(), abstractRecord, objectLevelModifyQuery.getSession());
        } else {
            this.writeFromObjectIntoRow(objectLevelModifyQuery.getObject(), abstractRecord, objectLevelModifyQuery.getSession());
        }
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return true;
    }

    @Override
    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        ObjectReferenceChangeRecord objectReferenceChangeRecord;
        Object object4 = object2;
        Object object5 = object3;
        if (object2 != null) {
            object4 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object2, unitOfWorkImpl);
        }
        if (object3 != null) {
            object5 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object3, unitOfWorkImpl);
        }
        if ((objectReferenceChangeRecord = (ObjectReferenceChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName())) == null) {
            objectReferenceChangeRecord = this.internalBuildChangeRecord(object4, objectChangeSet, unitOfWorkImpl);
            objectReferenceChangeRecord.setOldValue(object5);
            objectChangeSet.addChange(objectReferenceChangeRecord);
        } else {
            this.setNewValueInChangeRecord(object4, objectReferenceChangeRecord, objectChangeSet, unitOfWorkImpl);
        }
    }

    @Override
    public ChangeRecord buildChangeRecord(Object object, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        return this.internalBuildChangeRecord(this.getRealAttributeValueFromObject(object, abstractSession), objectChangeSet, abstractSession);
    }
}

