/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class UnidirectionalOneToManyMapping
extends OneToManyMapping {
    protected transient boolean shouldIncrementTargetLockValueOnAddOrRemoveTarget = true;
    protected transient boolean shouldIncrementTargetLockValueOnDeleteSource = true;

    protected AbstractRecord buildKeyRowForTargetUpdate(ObjectLevelModifyQuery objectLevelModifyQuery) {
        DatabaseRecord databaseRecord = new DatabaseRecord();
        int n = this.sourceKeyFields.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)this.sourceKeyFields.get(i);
            DatabaseField databaseField2 = (DatabaseField)this.targetForeignKeyFields.get(i);
            Object object = objectLevelModifyQuery.getTranslationRow().get(databaseField);
            databaseRecord.put(databaseField2, object);
        }
        return databaseRecord;
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        ChangeRecord changeRecord = super.compareForChange(object, object2, objectChangeSet, abstractSession);
        if (changeRecord != null && this.getReferenceDescriptor().getOptimisticLockingPolicy() != null) {
            this.postCalculateChanges(changeRecord, (UnitOfWorkImpl)abstractSession);
        }
        return changeRecord;
    }

    protected Vector extractPrimaryKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        int n = this.sourceKeyFields.size();
        Vector<Object> vector = new Vector<Object>(n);
        ConversionManager conversionManager = abstractSession.getDatasourcePlatform().getConversionManager();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)this.sourceKeyFields.get(i);
            Object object = abstractRecord.get(databaseField);
            try {
                object = conversionManager.convertObject(object, databaseField.getType());
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected Vector extractSourceKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        int n = this.sourceKeyFields.size();
        Vector<Object> vector = new Vector<Object>(n);
        ConversionManager conversionManager = abstractSession.getDatasourcePlatform().getConversionManager();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)this.targetForeignKeyFields.get(i);
            DatabaseField databaseField2 = (DatabaseField)this.sourceKeyFields.get(i);
            Object object = abstractRecord.get(databaseField);
            try {
                object = conversionManager.convertObject(object, databaseField2.getType());
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, AbstractRecord abstractRecord2) {
        Hashtable<CacheKey, Object> hashtable = null;
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = this.getBatchReadObjects(databaseQuery, abstractSession);
            if (hashtable == null) {
                ReadAllQuery readAllQuery = (ReadAllQuery)databaseQuery;
                ComplexQueryResult complexQueryResult = (ComplexQueryResult)abstractSession.executeQuery((DatabaseQuery)readAllQuery, abstractRecord2);
                List list = (List)complexQueryResult.getResult();
                hashtable = new Hashtable<CacheKey, Object>();
                List list2 = (List)complexQueryResult.getData();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Object e = list.get(i);
                    CacheKey cacheKey = new CacheKey(this.extractSourceKeyFromRow((AbstractRecord)list2.get(i), abstractSession));
                    if (!hashtable.containsKey(cacheKey)) {
                        hashtable.put(cacheKey, this.containerPolicy.containerInstance());
                    }
                    this.containerPolicy.addInto(e, hashtable.get(cacheKey), abstractSession);
                }
                this.setBatchReadObjects(hashtable, databaseQuery, abstractSession);
            }
        }
        databaseQuery2 = hashtable.get(new CacheKey(this.extractPrimaryKeyFromRow(abstractRecord, abstractSession)));
        if (databaseQuery2 == null) {
            return this.containerPolicy.containerInstance();
        }
        return databaseQuery2;
    }

    public boolean isUnidirectionalOneToManyMapping() {
        return true;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (this.getReferenceDescriptor().getOptimisticLockingPolicy() != null) {
            if (this.shouldIncrementTargetLockValueOnAddOrRemoveTarget) {
                this.descriptor.addMappingsPostCalculateChanges(this);
            }
            if (this.shouldIncrementTargetLockValueOnDeleteSource && !this.isPrivateOwned) {
                this.descriptor.addMappingsPostCalculateChangesOnDeleted(this);
            }
        }
    }

    public void postInitialize(AbstractSession abstractSession) {
        super.postInitialize(abstractSession);
        Iterator<DatabaseField> iterator = this.getTargetForeignKeyFields().iterator();
        Iterator<DatabaseField> iterator2 = this.getSourceKeyFields().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = iterator.next();
            DatabaseField databaseField2 = iterator2.next();
            if (databaseField.getType() != null) continue;
            databaseField.setType(this.getDescriptor().getObjectBuilder().getMappingForField(databaseField2).getFieldClassification(databaseField2));
        }
    }

    protected void initializeAddTargetQuery(AbstractSession abstractSession) {
        Cloneable cloneable;
        if (!this.addTargetQuery.hasSessionName()) {
            this.addTargetQuery.setSessionName(abstractSession.getName());
        }
        if (this.hasCustomAddTargetQuery) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = list.get(i);
            cloneable = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField));
            expression = cloneable.and(expression);
        }
        DatabaseRecord databaseRecord = new DatabaseRecord();
        n = this.targetForeignKeyFields.size();
        for (int i = 0; i < n; ++i) {
            cloneable = (DatabaseField)this.targetForeignKeyFields.get(i);
            databaseRecord.put((DatabaseField)cloneable, (Object)null);
        }
        this.containerPolicy.addFieldsForMapKey(databaseRecord);
        SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
        sQLUpdateStatement.setTable(this.getReferenceDescriptor().getDefaultTable());
        sQLUpdateStatement.setWhereClause(expression);
        sQLUpdateStatement.setModifyRow(databaseRecord);
        this.addTargetQuery.setSQLStatement(sQLUpdateStatement);
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            super.preDelete(deleteObjectQuery);
        } else {
            this.updateTargetRowPreDeleteSource(deleteObjectQuery);
            if (this.getContainerPolicy().propagatesEventsToCollection()) {
                Object object = deleteObjectQuery.getObject();
                Object object2 = this.getAttributeValueFromObject(object);
                Object object3 = this.containerPolicy.iteratorFor(object2);
                while (this.containerPolicy.hasNext(object3)) {
                    Object object4 = this.containerPolicy.nextEntry(object3, deleteObjectQuery.getSession());
                    this.containerPolicy.propogatePreDelete(deleteObjectQuery, object4);
                }
            }
        }
    }

    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy cascadeLockingPolicy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        cascadeLockingPolicy.setQueryKeyFields(this.getSourceKeysToTargetForeignKeys());
        cascadeLockingPolicy.setShouldHandleUnmappedFields(true);
        this.getReferenceDescriptor().addCascadeLockingPolicy(cascadeLockingPolicy);
    }

    public void postCalculateChanges(org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord, UnitOfWorkImpl unitOfWorkImpl) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeRecord;
        for (ObjectChangeSet objectChangeSet : collectionChangeRecord.getAddObjectList().values()) {
            if (objectChangeSet.hasChanges()) continue;
            objectChangeSet.setShouldModifyVersionField(Boolean.TRUE);
            ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).addObjectChangeSet(objectChangeSet, unitOfWorkImpl, false);
        }
        for (ObjectChangeSet objectChangeSet : collectionChangeRecord.getRemoveObjectList().values()) {
            if (!this.isPrivateOwned()) {
                if (objectChangeSet.hasChanges()) continue;
                objectChangeSet.setShouldModifyVersionField(Boolean.TRUE);
                ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).addObjectChangeSet(objectChangeSet, unitOfWorkImpl, false);
                continue;
            }
            this.containerPolicy.postCalculateChanges(objectChangeSet, this.referenceDescriptor, this, unitOfWorkImpl);
        }
    }

    public void postCalculateChangesOnDeleted(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        Object object2 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
        if (object2 != null) {
            Object object3 = this.containerPolicy.iteratorFor(object2);
            while (this.containerPolicy.hasNext(object3)) {
                Object object4 = this.containerPolicy.next(object3, unitOfWorkImpl);
                ObjectChangeSet objectChangeSet = this.referenceDescriptor.getObjectBuilder().createObjectChangeSet(object4, unitOfWorkChangeSet, unitOfWorkImpl);
                if (objectChangeSet.hasChanges()) continue;
                objectChangeSet.setShouldModifyVersionField(Boolean.TRUE);
                ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).addObjectChangeSet(objectChangeSet, unitOfWorkImpl, false);
            }
        }
    }

    protected void postPrepareNestedBatchQuery(ReadQuery readQuery, ReadAllQuery readAllQuery) {
        ReadAllQuery readAllQuery2 = (ReadAllQuery)readQuery;
        readAllQuery2.setShouldIncludeData(true);
        int n = this.targetForeignKeyFields.size();
        for (int i = 0; i < n; ++i) {
            readAllQuery2.addAdditionalField((DatabaseField)this.targetForeignKeyFields.get(i));
        }
    }

    protected void prepareTranslationRow(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
        int n = this.sourceKeyFields.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)this.sourceKeyFields.get(i);
            if (abstractRecord.containsKey(databaseField)) continue;
            Object object2 = this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, abstractSession);
            abstractRecord.put(databaseField, object2);
        }
    }

    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        if (this.isPrivateOwned) {
            super.recordPrivateOwnedRemovals(object, unitOfWorkImpl);
        }
    }

    public boolean requiresDataModificationEvents() {
        return true;
    }

    public void setShouldIncrementTargetLockValueOnAddOrRemoveTarget(boolean bl) {
        this.shouldIncrementTargetLockValueOnAddOrRemoveTarget = bl;
    }

    public void setShouldIncrementTargetLockValueOnDeleteSource(boolean bl) {
        this.shouldIncrementTargetLockValueOnDeleteSource = bl;
    }

    public boolean shouldIncrementTargetLockValueOnAddOrRemoveTarget() {
        return this.shouldIncrementTargetLockValueOnAddOrRemoveTarget;
    }

    public boolean shouldIncrementTargetLockValueOnDeleteSource() {
        return this.shouldIncrementTargetLockValueOnDeleteSource;
    }
}

