/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLCompositeDirectCollectionMapping
extends AbstractCompositeDirectCollectionMapping
implements XMLMapping {
    private boolean isCDATA;

    public boolean isXMLMapping() {
        return true;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        Serializable serializable;
        super.initialize(abstractSession);
        if (this.getField() instanceof XMLField && this.getValueConverter() instanceof TypeConversionConverter) {
            serializable = (TypeConversionConverter)this.getValueConverter();
            this.getField().setType(((TypeConversionConverter)serializable).getObjectClass());
        }
        if ((serializable = this.getContainerPolicy()) != null && ((ContainerPolicy)serializable).getContainerClass() == null) {
            Class clazz = abstractSession.getDatasourcePlatform().getConversionManager().convertClassNameToClass(((ContainerPolicy)serializable).getContainerClassName());
            ((ContainerPolicy)serializable).setContainerClass(clazz);
        }
        ((XMLField)this.getField()).setIsCDATA(this.isCDATA());
    }

    public void setXPath(String string) {
        if (string.indexOf("@") == -1 && !string.endsWith("text()")) {
            string = string + "/text()";
        }
        this.setField(new XMLField(string));
    }

    public String getXPath() {
        return this.getFieldName();
    }

    public void useCollectionClassName(String string) {
        this.setContainerPolicy(new CollectionContainerPolicy(string));
    }

    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object = abstractRecord.getValues(this.getField());
        if (object == null) {
            return containerPolicy.containerInstance();
        }
        Vector vector = this.getDescriptor().buildDirectValuesFromFieldValue(object);
        if (vector == null) {
            return containerPolicy.containerInstance();
        }
        Object object2 = containerPolicy.containerInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object3 = enumeration.nextElement();
            if (this.hasValueConverter()) {
                object3 = this.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.getValueConverter()).convertDataValueToObjectValue(object3, abstractSession, ((XMLRecord)abstractRecord).getUnmarshaller()) : this.getValueConverter().convertDataValueToObjectValue(object3, abstractSession);
            }
            containerPolicy.addInto(object3, object2, objectBuildingQuery.getSession());
        }
        return object2;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            abstractRecord.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Vector<Object> vector = new Vector<Object>(containerPolicy.sizeFor(object2));
        Object object3 = containerPolicy.iteratorFor(object2);
        while (containerPolicy.hasNext(object3)) {
            Object object4 = containerPolicy.next(object3, abstractSession);
            if (this.hasValueConverter()) {
                object4 = this.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.getValueConverter()).convertObjectValueToDataValue(object4, abstractSession, ((XMLRecord)abstractRecord).getMarshaller()) : this.getValueConverter().convertObjectValueToDataValue(object4, abstractSession);
            }
            if (object4 == null) continue;
            vector.addElement(object4);
        }
        object3 = null;
        if (!vector.isEmpty()) {
            object3 = this.getDescriptor().buildFieldValueFromDirectValues(vector, this.elementDataTypeName, abstractSession);
        }
        abstractRecord.put(this.getField(), object3);
    }

    public void writeSingleValue(Object object, Object object2, XMLRecord xMLRecord, AbstractSession abstractSession) {
        Object object3 = object;
        if (this.hasValueConverter()) {
            object3 = this.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.getValueConverter()).convertObjectValueToDataValue(object3, abstractSession, xMLRecord.getMarshaller()) : this.getValueConverter().convertObjectValueToDataValue(object3, abstractSession);
        }
        xMLRecord.add(this.getField(), object3);
    }

    public void setIsCDATA(boolean bl) {
        this.isCDATA = bl;
    }

    public boolean isCDATA() {
        return this.isCDATA;
    }
}

