/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class MarshalRecord
extends XMLRecord {
    private ArrayList groupingElements;
    private HashMap positionalNodes;

    public HashMap getPositionalNodes() {
        if (this.positionalNodes == null) {
            this.positionalNodes = new HashMap();
        }
        return this.positionalNodes;
    }

    public String getLocalName() {
        throw XMLMarshalException.operationNotSupported("getLocalName");
    }

    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    public Element getDOM() {
        throw XMLMarshalException.operationNotSupported("getDOM");
    }

    public void addGroupingElement(XPathNode xPathNode) {
        if (null == this.groupingElements) {
            this.groupingElements = new ArrayList();
        }
        this.groupingElements.add(xPathNode);
    }

    public void removeGroupingElement(XPathNode xPathNode) {
        if (null != this.groupingElements) {
            this.groupingElements.remove(xPathNode);
        }
    }

    public String transformToXML() {
        return null;
    }

    public void add(DatabaseField databaseField, Object object) {
        if (null == object) {
            return;
        }
        XMLField xMLField = this.convertToXMLField(databaseField);
        XPathFragment xPathFragment = xMLField.getLastXPathFragment();
        XMLConversionManager xMLConversionManager = (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager();
        if (xPathFragment.nameIsText()) {
            String string = (String)xMLConversionManager.convertObject(object, String.class);
            this.characters(string);
        } else if (xPathFragment.isAttribute()) {
            String string = (String)xMLConversionManager.convertObject(object, String.class);
            this.attribute(xPathFragment, xMLField.getNamespaceResolver(), string);
        } else {
            this.element(xPathFragment.getNamespaceURI(), xPathFragment.getXPath(), xPathFragment.getShortName());
        }
    }

    public Object put(DatabaseField databaseField, Object object) {
        this.add(databaseField, object);
        return null;
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        if (namespaceResolver == null) {
            return;
        }
        String string = namespaceResolver.getDefaultNamespaceURI();
        if (null != string) {
            this.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", string);
        }
        Enumeration enumeration = namespaceResolver.getPrefixes();
        string = null;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = namespaceResolver.resolveNamespacePrefix(string2);
            this.attribute("http://www.w3.org/2000/xmlns/", string2, "xmlns:" + string2, string);
        }
    }

    public abstract void startDocument(String var1, String var2);

    public abstract void endDocument();

    public void startPrefixMapping(String string, String string2) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null) {
            Enumeration enumeration = namespaceResolver.getPrefixes();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = namespaceResolver.resolveNamespacePrefix(string);
                this.startPrefixMapping(string, string2);
            }
        }
    }

    public void endPrefixMapping(String string) {
    }

    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null) {
            Enumeration enumeration = namespaceResolver.getPrefixes();
            while (enumeration.hasMoreElements()) {
                this.endPrefixMapping((String)enumeration.nextElement());
            }
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
    }

    public abstract void element(String var1, String var2, String var3);

    public abstract void attribute(XPathFragment var1, NamespaceResolver var2, String var3);

    public abstract void attribute(String var1, String var2, String var3, String var4);

    public abstract void closeStartElement();

    public abstract void endElement(XPathFragment var1, NamespaceResolver var2);

    public abstract void characters(String var1);

    public abstract void cdata(String var1);

    public abstract void node(Node var1, NamespaceResolver var2);

    protected String resolveNamespacePrefix(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        String string = xPathFragment.getNamespaceURI();
        if (string == null) {
            if (null == namespaceResolver) {
                if (null != xPathFragment.getPrefix()) {
                    throw XMLMarshalException.namespaceResolverNotSpecified(xPathFragment.getShortName());
                }
            } else if (!xPathFragment.isAttribute() || xPathFragment.isAttribute() && xPathFragment.getPrefix() != null) {
                string = namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            }
            if (null == string && null != xPathFragment.getPrefix()) {
                throw XMLMarshalException.namespaceNotFound(xPathFragment.getShortName());
            }
            xPathFragment.setNamespaceURI(string);
        }
        return string;
    }

    public XPathFragment openStartGroupingElements(NamespaceResolver namespaceResolver) {
        if (null == this.groupingElements) {
            return null;
        }
        XPathFragment xPathFragment = null;
        int n = this.groupingElements.size();
        for (int i = 0; i < n; ++i) {
            XPathNode xPathNode = (XPathNode)this.groupingElements.get(i);
            xPathFragment = xPathNode.getXPathFragment();
            this.openStartElement(xPathFragment, namespaceResolver);
            if (i == n - 1) continue;
            this.closeStartElement();
        }
        this.groupingElements = null;
        return xPathFragment;
    }

    public void closeStartGroupingElements(XPathFragment xPathFragment) {
        if (null != xPathFragment) {
            this.closeStartElement();
        }
    }

    protected void addPositionalNodes(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (xPathFragment.containsIndex()) {
            Integer n = (Integer)this.getPositionalNodes().get(xPathFragment.getShortName());
            int n2 = null == n ? 1 : n;
            for (int i = n2; i < xPathFragment.getIndexValue(); ++i) {
                this.element(this.resolveNamespacePrefix(xPathFragment, namespaceResolver), xPathFragment.getLocalName(), xPathFragment.getShortName());
            }
            this.getPositionalNodes().put(xPathFragment.getShortName(), new Integer(xPathFragment.getIndexValue() + 1));
        }
    }
}

