/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ExternalConnectionPool
extends ConnectionPool {
    protected Accessor cachedConnection;

    public ExternalConnectionPool() {
    }

    public ExternalConnectionPool(String string, Login login, ServerSession serverSession) {
        super(string, login, 0, 0, 0, serverSession);
    }

    public Accessor acquireConnection() throws ConcurrencyException {
        return (Accessor)this.getCachedConnection().clone();
    }

    protected Accessor getCachedConnection() {
        return this.cachedConnection;
    }

    public boolean hasConnectionAvailable() {
        return true;
    }

    public boolean isThereConflictBetweenLoginAndType() {
        return !this.getLogin().shouldUseExternalConnectionPooling();
    }

    public void releaseConnection(Accessor accessor) throws DatabaseException {
        accessor.closeConnection();
        accessor.releaseCustomizer();
    }

    protected void setCachedConnection(Accessor accessor) {
        this.cachedConnection = accessor;
    }

    public void setCheckConnections() {
    }

    public synchronized void shutDown() {
        this.setIsConnected(false);
    }

    public synchronized void startUp() {
        this.setCachedConnection(this.buildConnection());
        this.setIsConnected(true);
    }
}

