/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;

public class StoredProcedureDefinition
extends DatabaseObjectDefinition {
    protected Vector variables;
    protected Vector statements = new Vector();
    protected Vector arguments;
    protected Vector argumentTypes;
    protected static final Integer IN = new Integer(1);
    protected static final Integer OUT = new Integer(2);
    protected static final Integer INOUT = new Integer(3);

    public StoredProcedureDefinition() {
        this.variables = new Vector();
        this.arguments = new Vector();
        this.argumentTypes = new Vector();
    }

    public void addArgument(String string, Class clazz) {
        this.addArgument(new FieldDefinition(string, clazz));
    }

    public void addArgument(String string, Class clazz, int n) {
        this.addArgument(new FieldDefinition(string, clazz, n));
    }

    public void addArgument(String string, String string2) {
        this.addArgument(new FieldDefinition(string, string2));
    }

    public void addArgument(FieldDefinition fieldDefinition) {
        this.getArguments().addElement(fieldDefinition);
        this.getArgumentTypes().addElement(IN);
    }

    public void addInOutputArgument(String string, Class clazz) {
        this.addInOutputArgument(new FieldDefinition(string, clazz));
    }

    public void addInOutputArgument(FieldDefinition fieldDefinition) {
        this.getArguments().addElement(fieldDefinition);
        this.getArgumentTypes().addElement(INOUT);
    }

    public void addOutputArgument(String string, Class clazz) {
        this.addOutputArgument(new FieldDefinition(string, clazz));
    }

    public void addOutputArgument(String string, Class clazz, int n) {
        this.addOutputArgument(new FieldDefinition(string, clazz, n));
    }

    public void addOutputArgument(String string, String string2) {
        this.addOutputArgument(new FieldDefinition(string, string2));
    }

    public void addOutputArgument(FieldDefinition fieldDefinition) {
        this.getArguments().addElement(fieldDefinition);
        this.getArgumentTypes().addElement(OUT);
    }

    public void addStatement(String string) {
        this.getStatements().addElement(string);
    }

    public void addVariable(String string, String string2) {
        this.addVariable(new FieldDefinition(string, string2));
    }

    public void addVariable(FieldDefinition fieldDefinition) {
        this.getVariables().addElement(fieldDefinition);
    }

    public Writer buildCreationWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        try {
            FieldDefinition fieldDefinition;
            DatabasePlatform databasePlatform = abstractSession.getPlatform();
            writer.write(this.getCreationHeader() + this.getFullName());
            if (this.getArguments().size() > this.getFirstArgumentIndex() || databasePlatform.requiresProcedureBrackets()) {
                writer.write(" (");
            }
            writer.write("\n");
            for (int i = this.getFirstArgumentIndex(); i < this.getArguments().size(); ++i) {
                writer.write("\t");
                fieldDefinition = (FieldDefinition)this.getArguments().elementAt(i);
                Integer n = (Integer)this.getArgumentTypes().elementAt(i);
                if (n == IN) {
                    this.printArgument(fieldDefinition, writer, abstractSession);
                } else if (n == OUT) {
                    this.printOutputArgument(fieldDefinition, writer, abstractSession);
                } else if (n == INOUT) {
                    this.printInOutputArgument(fieldDefinition, writer, abstractSession);
                }
                if (i >= this.getArguments().size() - 1) continue;
                writer.write(",\n");
            }
            if (this.getArguments().size() > this.getFirstArgumentIndex() || databasePlatform.requiresProcedureBrackets()) {
                writer.write(")");
            }
            this.printReturn(writer, abstractSession);
            writer.write(databasePlatform.getProcedureAsString());
            writer.write("\n");
            if (databasePlatform.shouldPrintStoredProcedureVariablesAfterBeginString()) {
                writer.write(databasePlatform.getProcedureBeginString());
                writer.write("\n");
            }
            if (!this.getVariables().isEmpty()) {
                writer.write("DECLARE\n");
            }
            Enumeration enumeration = this.getVariables().elements();
            while (enumeration.hasMoreElements()) {
                fieldDefinition = (FieldDefinition)enumeration.nextElement();
                writer.write("\t");
                writer.write(fieldDefinition.getName());
                writer.write(" ");
                writer.write(fieldDefinition.getTypeName());
                writer.write(databasePlatform.getBatchDelimiterString());
                writer.write("\n");
            }
            if (!databasePlatform.shouldPrintStoredProcedureVariablesAfterBeginString()) {
                writer.write(databasePlatform.getProcedureBeginString());
                writer.write("\n");
            }
            enumeration = this.getStatements().elements();
            while (enumeration.hasMoreElements()) {
                writer.write((String)enumeration.nextElement());
                writer.write(databasePlatform.getBatchDelimiterString());
                writer.write("\n");
            }
            writer.write(databasePlatform.getProcedureEndString());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        try {
            writer.write(this.getDeletionHeader() + this.getFullName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Vector getArguments() {
        return this.arguments;
    }

    public String getCreationHeader() {
        return "CREATE PROCEDURE ";
    }

    public String getDeletionHeader() {
        return "DROP PROCEDURE ";
    }

    public int getFirstArgumentIndex() {
        return 0;
    }

    public Vector getArgumentTypes() {
        return this.argumentTypes;
    }

    public Vector getStatements() {
        return this.statements;
    }

    public Vector getVariables() {
        return this.variables;
    }

    protected void printArgument(FieldDefinition fieldDefinition, Writer writer, AbstractSession abstractSession) throws IOException {
        FieldTypeDefinition fieldTypeDefinition;
        DatabasePlatform databasePlatform = abstractSession.getPlatform();
        if (fieldDefinition.getType() != null) {
            fieldTypeDefinition = databasePlatform.getFieldTypeDefinition(fieldDefinition.getType());
            if (fieldTypeDefinition == null) {
                throw ValidationException.javaTypeIsNotAValidDatabaseType(fieldDefinition.getType());
            }
        } else {
            fieldTypeDefinition = new FieldTypeDefinition(fieldDefinition.getTypeName());
        }
        writer.write(databasePlatform.getProcedureArgumentString());
        if (databasePlatform.shouldPrintInputTokenAtStart()) {
            writer.write(" ");
            writer.write(databasePlatform.getInputProcedureToken());
            writer.write(" ");
        }
        writer.write(fieldDefinition.getName());
        writer.write(" ");
        writer.write(fieldTypeDefinition.getName());
        if (fieldTypeDefinition.isSizeAllowed() && databasePlatform.allowsSizeInProcedureArguments() && (fieldDefinition.getSize() != 0 || fieldTypeDefinition.isSizeRequired())) {
            writer.write("(");
            if (fieldDefinition.getSize() == 0) {
                writer.write(new Integer(fieldTypeDefinition.getDefaultSize()).toString());
            } else {
                writer.write(new Integer(fieldDefinition.getSize()).toString());
            }
            if (fieldDefinition.getSubSize() != 0) {
                writer.write(",");
                writer.write(new Integer(fieldDefinition.getSubSize()).toString());
            } else if (fieldTypeDefinition.getDefaultSubSize() != 0) {
                writer.write(",");
                writer.write(new Integer(fieldTypeDefinition.getDefaultSubSize()).toString());
            }
            writer.write(")");
        }
    }

    protected void printInOutputArgument(FieldDefinition fieldDefinition, Writer writer, AbstractSession abstractSession) throws ValidationException {
        try {
            FieldTypeDefinition fieldTypeDefinition;
            DatabasePlatform databasePlatform = abstractSession.getPlatform();
            if (fieldDefinition.getType() != null) {
                fieldTypeDefinition = databasePlatform.getFieldTypeDefinition(fieldDefinition.getType());
                if (fieldTypeDefinition == null) {
                    throw ValidationException.javaTypeIsNotAValidDatabaseType(fieldDefinition.getType());
                }
            } else {
                fieldTypeDefinition = new FieldTypeDefinition(fieldDefinition.getTypeName());
            }
            writer.write(databasePlatform.getProcedureArgumentString());
            if (databasePlatform.shouldPrintOutputTokenAtStart()) {
                writer.write(" " + databasePlatform.getCreationInOutputProcedureToken() + " ");
            }
            writer.write(fieldDefinition.getName());
            if (!databasePlatform.shouldPrintOutputTokenAtStart() && databasePlatform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" " + databasePlatform.getCreationInOutputProcedureToken());
            }
            writer.write(" " + fieldTypeDefinition.getName());
            if (fieldTypeDefinition.isSizeAllowed() && databasePlatform.allowsSizeInProcedureArguments() && (fieldDefinition.getSize() != 0 || fieldTypeDefinition.isSizeRequired())) {
                writer.write("(");
                if (fieldDefinition.getSize() == 0) {
                    writer.write(new Integer(fieldTypeDefinition.getDefaultSize()).toString());
                } else {
                    writer.write(new Integer(fieldDefinition.getSize()).toString());
                }
                if (fieldDefinition.getSubSize() != 0) {
                    writer.write(",");
                    writer.write(new Integer(fieldDefinition.getSubSize()).toString());
                } else if (fieldTypeDefinition.getDefaultSubSize() != 0) {
                    writer.write(",");
                    writer.write(new Integer(fieldTypeDefinition.getDefaultSubSize()).toString());
                }
                writer.write(")");
            }
            if (!databasePlatform.shouldPrintOutputTokenAtStart() && !databasePlatform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" " + databasePlatform.getCreationInOutputProcedureToken());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected void printOutputArgument(FieldDefinition fieldDefinition, Writer writer, AbstractSession abstractSession) throws ValidationException {
        try {
            FieldTypeDefinition fieldTypeDefinition;
            DatabasePlatform databasePlatform = abstractSession.getPlatform();
            if (fieldDefinition.getType() != null) {
                fieldTypeDefinition = databasePlatform.getFieldTypeDefinition(fieldDefinition.getType());
                if (fieldTypeDefinition == null) {
                    throw ValidationException.javaTypeIsNotAValidDatabaseType(fieldDefinition.getType());
                }
            } else {
                fieldTypeDefinition = new FieldTypeDefinition(fieldDefinition.getTypeName());
            }
            writer.write(databasePlatform.getProcedureArgumentString());
            if (databasePlatform.shouldPrintOutputTokenAtStart()) {
                writer.write(" " + databasePlatform.getCreationOutputProcedureToken() + " ");
            }
            writer.write(fieldDefinition.getName());
            if (!databasePlatform.shouldPrintOutputTokenAtStart() && databasePlatform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" " + databasePlatform.getCreationOutputProcedureToken());
            }
            writer.write(" " + fieldTypeDefinition.getName());
            if (fieldTypeDefinition.isSizeAllowed() && databasePlatform.allowsSizeInProcedureArguments() && (fieldDefinition.getSize() != 0 || fieldTypeDefinition.isSizeRequired())) {
                writer.write("(");
                if (fieldDefinition.getSize() == 0) {
                    writer.write(new Integer(fieldTypeDefinition.getDefaultSize()).toString());
                } else {
                    writer.write(new Integer(fieldDefinition.getSize()).toString());
                }
                if (fieldDefinition.getSubSize() != 0) {
                    writer.write(",");
                    writer.write(new Integer(fieldDefinition.getSubSize()).toString());
                } else if (fieldTypeDefinition.getDefaultSubSize() != 0) {
                    writer.write(",");
                    writer.write(new Integer(fieldTypeDefinition.getDefaultSubSize()).toString());
                }
                writer.write(")");
            }
            if (!databasePlatform.shouldPrintOutputTokenAtStart() && !databasePlatform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" " + databasePlatform.getCreationOutputProcedureToken());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected void printReturn(Writer writer, AbstractSession abstractSession) throws ValidationException {
    }

    public void setArguments(Vector vector) {
        this.arguments = vector;
    }

    public void setStatements(Vector vector) {
        this.statements = vector;
    }

    public void setVariables(Vector vector) {
        this.variables = vector;
    }
}

