/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;

public class VarrayDefinition
extends DatabaseObjectDefinition {
    protected int typeSize;
    protected int size;
    protected Class type;
    protected String typeName;

    public void appendTypeString(Writer writer, AbstractSession abstractSession) throws ValidationException {
        try {
            FieldTypeDefinition fieldTypeDefinition;
            if (this.getType() != null) {
                fieldTypeDefinition = abstractSession.getPlatform().getFieldTypeDefinition(this.getType());
                if (fieldTypeDefinition == null) {
                    throw ValidationException.javaTypeIsNotAValidDatabaseType(this.getType());
                }
            } else {
                fieldTypeDefinition = new FieldTypeDefinition(this.getTypeName());
            }
            writer.write(fieldTypeDefinition.getName());
            if (fieldTypeDefinition.isSizeAllowed() && (this.getTypeSize() != 0 || fieldTypeDefinition.isSizeRequired())) {
                writer.write("(");
                if (this.getTypeSize() == 0) {
                    writer.write(new Integer(fieldTypeDefinition.getDefaultSize()).toString());
                } else {
                    writer.write(new Integer(this.getTypeSize()).toString());
                }
                writer.write(")");
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public Writer buildCreationWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        try {
            writer.write("CREATE TYPE ");
            writer.write(this.getFullName());
            writer.write(" AS VARRAY(");
            if (this.getSize() < 1) {
                throw ValidationException.oracleVarrayMaximumSizeNotDefined(this.getFullName());
            }
            writer.write(new Integer(this.getSize()).toString());
            writer.write(") OF ");
            this.appendTypeString(writer, abstractSession);
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TYPE " + this.getFullName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public int getSize() {
        return this.size;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getTypeSize() {
        return this.typeSize;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setType(Class clazz) {
        this.type = clazz;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public void setTypeSize(int n) {
        this.typeSize = n;
    }
}

