/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.messagesbus;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.comet.NotificationHandler;
import com.sun.grizzly.messagesbus.MessagesBusCometHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MessagesBus
extends HttpServlet {
    private long expirationDelay = 30000L;
    private NotificationHandler notificationHandler = null;
    private static final Logger logger = Logger.getAnonymousLogger();
    private boolean suspendOnTheFly = true;

    public void init(ServletConfig config) throws ServletException {
        String stf;
        String ed = config.getInitParameter("expirationDelay");
        if (ed != null) {
            this.expirationDelay = Long.parseLong(ed);
        }
        String nh = config.getInitParameter("notificationHandler");
        if (ed != null) {
            this.notificationHandler = (NotificationHandler)MessagesBus.loadClass(nh);
        }
        if ((stf = config.getInitParameter("suspendOnTheFly")) != null) {
            this.suspendOnTheFly = Boolean.valueOf(stf);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        CometType cometType = this.suspend(req, res);
        res.setContentType("text/html");
        if (cometType != null && cometType != CometType.POLLING) {
            res.flushBuffer();
            return;
        }
        this.push(req, res);
    }

    protected synchronized void push(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String message = req.getParameter("message");
        String topic = req.getParameter("publish");
        if (message == null || topic == null) {
            return;
        }
        CometContext context = CometEngine.getEngine().getCometContext(topic);
        if (context == null && this.suspendOnTheFly) {
            context = this.createCometContext(topic);
            CometType cometType = CometType.LONG_POLLING;
            MessagesBusCometHandler cometHandler = new MessagesBusCometHandler(context, cometType);
            cometHandler.attach(res);
            context.addCometHandler((CometHandler)cometHandler);
        } else if (!this.suspendOnTheFly) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Cannot create message topic:" + topic + " on the fly. You first have to " + "subscribe");
            }
            return;
        }
        context.notify((Object)message);
    }

    protected synchronized CometType suspend(HttpServletRequest req, HttpServletResponse res) throws UnsupportedEncodingException, IOException {
        String cometTechnique = req.getParameter("cometTechnique");
        String topic = req.getParameter("subscribe");
        String message = req.getParameter("message");
        if (cometTechnique == null || topic == null) {
            return CometType.POLLING;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("CometTechnique: " + cometTechnique + " topic:" + topic);
        }
        if (cometTechnique.equals("polling")) {
            return CometType.POLLING;
        }
        CometContext context = CometEngine.getEngine().getCometContext(topic);
        if (context == null) {
            context = this.createCometContext(topic);
        }
        CometType cometType = null;
        if (cometTechnique.equals("long-polling")) {
            cometType = CometType.LONG_POLLING;
        } else if (cometTechnique.equals("http-streaming")) {
            cometType = CometType.HTTP_STREAMING;
        }
        MessagesBusCometHandler cometHandler = new MessagesBusCometHandler(context, cometType);
        cometHandler.attach(res);
        if (message != null) {
            context.notify((Object)message);
            res.getWriter().write(message);
        }
        context.addCometHandler((CometHandler)cometHandler);
        return cometType;
    }

    protected final CometContext createCometContext(String topic) {
        CometContext context = CometEngine.getEngine().register(topic);
        if (this.notificationHandler != null) {
            context.setNotificationHandler(this.notificationHandler);
        }
        context.setExpirationDelay(this.expirationDelay);
        context.setBlockingNotification(true);
        return context;
    }

    private static Object loadClass(String clazzName) {
        Class<?> className = null;
        try {
            className = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            return className.newInstance();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Invalid NotificationHandler", t);
            return null;
        }
    }

    public long getExpirationDelay() {
        return this.expirationDelay;
    }

    public void setExpirationDelay(long expirationDelay) {
        this.expirationDelay = expirationDelay;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CometType {
        POLLING,
        LONG_POLLING,
        HTTP_STREAMING;

    }
}

