/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.component;

import com.sun.mojarra.scales.component.Links;
import com.sun.mojarra.scales.util.CssUtil;
import com.sun.mojarra.scales.util.RenderingHelper;
import com.sun.mojarra.scales.util.ScalesUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class DateSelector
extends UIInput {
    public static final String COMPONENT_FAMILY = "com.sun.mojarra.scales.DateSelector";
    public static final String COMPONENT_TYPE = "com.sun.mojarra.scales.DateSelector";
    public static final String RENDERER_TYPE = "com.sun.mojarra.scales.DateSelector";
    private Object[] _state = null;
    protected Boolean hideBlankWeeks = Boolean.FALSE;
    protected String locale = "en_US";
    protected Boolean multiSelect = Boolean.FALSE;
    protected String navigator = "true";
    protected String onChange = "";
    protected Boolean popup = Boolean.TRUE;
    protected Boolean showWeekdays = Boolean.TRUE;
    protected Boolean showWeekFooter = Boolean.FALSE;
    protected Boolean showWeekHeader = Boolean.FALSE;
    protected Integer startWeekday = 0;
    protected Date minDate;
    protected Date maxDate;
    protected Boolean showMenus;
    protected String format = "yyyy/MM/dd";
    protected Boolean enableManualInput = Boolean.FALSE;
    protected String style;
    protected String styleClass;

    public DateSelector() {
        this.setRendererType("com.sun.mojarra.scales.DateSelector");
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            String baseUrl = context.getExternalContext().getRequestContextPath();
            Links.addCss("SCALES_EXTERNAL_STYLESHEETS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/assets/skins/sam/skin.css"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/calendar/calendar-min.js"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + ScalesUtil.createResourceUrl(context, "/scales/dateselector_helper.js"));
            CssUtil.linkDateSelectorOverrides(context);
        }
    }

    public String getFamily() {
        return "com.sun.mojarra.scales.DateSelector";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Map attrs = this.getAttributes();
        String formattedDate = ScalesUtil.formatDate((Date)this.getValue(), (String)attrs.get("format"), false);
        String clientId = this.getClientId(context);
        String baseUrl = ScalesUtil.getStaticResourceUrl(context, "");
        writer.startElement("span", (UIComponent)this);
        writer.writeAttribute("class", (Object)((String)attrs.get("styleClass")), "class");
        writer.writeAttribute("style", (Object)((String)attrs.get("style")), "style");
        RenderingHelper.outputElement(writer, (UIComponent)this, "input", new String[][]{{"id", clientId}, {"name", clientId}, {"type", "text"}, {"size", "10"}, {"value", formattedDate}, {"onchange", (String)attrs.get("onChange")}});
        RenderingHelper.outputElement(writer, (UIComponent)this, "span", new String[][]{{"id", clientId + "Container"}});
        RenderingHelper.outputElement(writer, (UIComponent)this, "img", new String[][]{{"id", clientId + "Trigger"}, {"alt", "calendar"}, {"style", "vertical-align: middle"}, {"src", baseUrl + "scales/dateselector_icon.gif"}});
        writer.endElement("span");
        RenderingHelper.writeOnDomReady(writer, "scales.createDateSelector('" + clientId + "', " + this.buildConfig(context) + ");");
    }

    public Boolean getEnableManualInput() {
        return this.enableManualInput;
    }

    public void setEnableManualInput(Boolean enableManualInput) {
        this.enableManualInput = enableManualInput;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Boolean getHideBlankWeeks() {
        return this.hideBlankWeeks;
    }

    public void setHideBlankWeeks(Boolean hideBlankWeeks) {
        this.hideBlankWeeks = hideBlankWeeks;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public Boolean getMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(Boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public String getNavigator() {
        return this.navigator;
    }

    public void setNavigator(String navigator) {
        this.navigator = navigator;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    public Boolean getPopup() {
        return this.popup;
    }

    public void setPopup(Boolean popup) {
        this.popup = popup;
    }

    public Boolean getShowMenus() {
        return this.showMenus;
    }

    public void setShowMenus(Boolean showMenus) {
        this.showMenus = showMenus;
    }

    public Boolean getShowWeekFooter() {
        return this.showWeekFooter;
    }

    public void setShowWeekFooter(Boolean showWeekFooter) {
        this.showWeekFooter = showWeekFooter;
    }

    public Boolean getShowWeekHeader() {
        return this.showWeekHeader;
    }

    public void setShowWeekHeader(Boolean showWeekHeader) {
        this.showWeekHeader = showWeekHeader;
    }

    public Boolean getShowWeekdays() {
        return this.showWeekdays;
    }

    public void setShowWeekdays(Boolean showWeekdays) {
        this.showWeekdays = showWeekdays;
    }

    public Integer getStartWeekday() {
        return this.startWeekday;
    }

    public void setStartWeekday(Integer startWeekday) {
        this.startWeekday = startWeekday;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    protected String buildConfig(FacesContext context) {
        Map attrs = this.getAttributes();
        StringBuilder config = new StringBuilder("{");
        ResourceBundle bundle = ScalesUtil.getBundle("com.sun.mojarra.scales.MessageResources", (String)attrs.get("locale"), ((Object)((Object)this)).getClass());
        Integer[] fieldPositions = this.calculateFieldPositions();
        ScalesUtil.appendToConfig(config, "clientId", this.getClientId(context), true, false);
        ScalesUtil.appendToConfig(config, "startMonth", ScalesUtil.formatDate((Date)this.getValue(), "MM/yyyy", true), true, true);
        ScalesUtil.appendToConfig(config, "selectedDate", ScalesUtil.formatDate((Date)this.getValue(), "MM/dd/yyyy", false), true, true);
        ScalesUtil.appendToConfig(config, "showWeekdays", (Boolean)attrs.get("showWeekdays"), false, true);
        ScalesUtil.appendToConfig(config, "startWeekday", (Integer)attrs.get("startWeekday"), false, true);
        ScalesUtil.appendToConfig(config, "showWeekHeader", (Boolean)attrs.get("showWeekHeader"), false, true);
        ScalesUtil.appendToConfig(config, "showWeekFooter", (Boolean)attrs.get("showWeekFooter"), false, true);
        ScalesUtil.appendToConfig(config, "hideBlankWeeks", (Boolean)attrs.get("hideBlankWeeks"), false, true);
        ScalesUtil.appendToConfigIfNotNull(config, "minDate", (Date)attrs.get("minDate"), true, true);
        ScalesUtil.appendToConfigIfNotNull(config, "maxDate", (Date)attrs.get("maxDate"), true, true);
        ScalesUtil.appendToConfigIfNotNull(config, "onChange", (String)attrs.get("onChange"), true, true);
        ScalesUtil.appendToConfig(config, "navigator", this.configureNavigator(), false, true);
        ScalesUtil.appendToConfig(config, "popup", (Boolean)attrs.get("popup"), false, true);
        ScalesUtil.appendToConfig(config, "dayPosition", fieldPositions[1], false, true);
        ScalesUtil.appendToConfig(config, "monthPosition", fieldPositions[0], false, true);
        ScalesUtil.appendToConfig(config, "yearPosition", fieldPositions[2], false, true);
        ScalesUtil.appendToConfig(config, "format", (String)attrs.get("format"), true, true);
        ScalesUtil.appendToConfig(config, "dateFieldDelimiter", bundle.getString("date_field_delimiter"), true, true);
        ScalesUtil.appendToConfig(config, "mdyDayPosition", bundle.getString("mdy_day_position"), false, true);
        ScalesUtil.appendToConfig(config, "mdyMonthPosition", bundle.getString("mdy_month_position"), false, true);
        ScalesUtil.appendToConfig(config, "mdyYearPosition", bundle.getString("mdy_year_position"), false, true);
        ScalesUtil.appendToConfig(config, "mdDayPosition", bundle.getString("md_day_position"), false, true);
        ScalesUtil.appendToConfig(config, "mdMonthPosition", bundle.getString("md_month_position"), false, true);
        ScalesUtil.appendToConfig(config, "monthsShort", "[" + bundle.getString("months_short") + "]", false, true);
        ScalesUtil.appendToConfig(config, "monthsLong", "[" + bundle.getString("months_long") + "]", false, true);
        ScalesUtil.appendToConfig(config, "weekdays1Char", "[" + bundle.getString("weekdays_1char") + "]", false, true);
        ScalesUtil.appendToConfig(config, "weekdaysShort", "[" + bundle.getString("weekdays_short") + "]", false, true);
        ScalesUtil.appendToConfig(config, "weekdaysMedium", "[" + bundle.getString("weekdays_medium") + "]", false, true);
        ScalesUtil.appendToConfig(config, "weekdaysLong", "[" + bundle.getString("weekdays_long") + "]", false, true);
        return config.append("}").toString();
    }

    public void decode(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = this.getClientId(facesContext);
        try {
            Date date = null;
            String string_submit_val = (String)requestMap.get(clientId);
            if (string_submit_val != null) {
                SimpleDateFormat df = new SimpleDateFormat((String)this.getAttributes().get("format"));
                date = df.parse(string_submit_val);
            }
            this.setSubmittedValue(date);
        }
        catch (ParseException ex) {
            facesContext.addMessage(this.getClientId(facesContext), new FacesMessage(FacesMessage.SEVERITY_ERROR, ex.getMessage(), null));
            Logger.getLogger(DateSelector.class.getName()).severe(ex.getMessage());
        }
    }

    private Integer[] calculateFieldPositions() {
        Integer[] positions = new Integer[]{1, 2, 3};
        String localFormat = ((String)this.getAttributes().get("format")).toLowerCase();
        String[] parts = localFormat.split("/");
        if (parts.length == 1) {
            parts = localFormat.split("-");
        }
        int index = 1;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].startsWith("m")) {
                index = 0;
            } else if (parts[i].startsWith("y")) {
                index = 2;
            }
            positions[index] = i + 1;
        }
        return positions;
    }

    private String configureNavigator() {
        String retvalue = (String)this.getAttributes().get("navigator");
        ResourceBundle bundle = ScalesUtil.getBundle("com.sun.mojarra.scales.MessageResources", (String)this.getAttributes().get("locale"), ((Object)((Object)this)).getClass());
        if (!"true".equalsIgnoreCase(retvalue)) {
            retvalue = "{strings: {month:\"" + bundle.getString("navigator_month") + "\"," + "year:\"" + bundle.getString("navigator_year") + "\"," + "submit: \"" + bundle.getString("navigator_submit") + "\"," + "cancel: \"" + bundle.getString("navigator_cancel") + "\"," + "invalidYear: \"" + bundle.getString("navigator_invalid_year") + "\"}," + "monthFormat: " + bundle.getString("navigator_month_format") + "," + "initialFocus: \"" + bundle.getString("navigator_initial_focus") + "\"}";
        }
        return retvalue;
    }

    public void restoreState(FacesContext _context, Object _state) {
        this._state = (Object[])_state;
        super.restoreState(_context, this._state[0]);
        this.hideBlankWeeks = (Boolean)this._state[1];
        this.locale = (String)this._state[2];
        this.multiSelect = (Boolean)this._state[3];
        this.navigator = (String)this._state[4];
        this.onChange = (String)this._state[5];
        this.popup = (Boolean)this._state[6];
        this.showWeekdays = (Boolean)this._state[7];
        this.showWeekFooter = (Boolean)this._state[8];
        this.showWeekHeader = (Boolean)this._state[9];
        this.startWeekday = (Integer)this._state[10];
        this.minDate = (Date)this._state[11];
        this.maxDate = (Date)this._state[12];
        this.showMenus = (Boolean)this._state[13];
        this.format = (String)this._state[14];
        this.enableManualInput = (Boolean)this._state[15];
        this.style = (String)this._state[16];
        this.styleClass = (String)this._state[17];
    }

    public Object saveState(FacesContext _context) {
        if (this._state == null) {
            this._state = new Object[18];
        }
        this._state[0] = super.saveState(_context);
        this._state[1] = this.hideBlankWeeks;
        this._state[2] = this.locale;
        this._state[3] = this.multiSelect;
        this._state[4] = this.navigator;
        this._state[5] = this.onChange;
        this._state[6] = this.popup;
        this._state[7] = this.showWeekdays;
        this._state[8] = this.showWeekFooter;
        this._state[9] = this.showWeekHeader;
        this._state[10] = this.startWeekday;
        this._state[11] = this.minDate;
        this._state[12] = this.maxDate;
        this._state[13] = this.showMenus;
        this._state[14] = this.format;
        this._state[15] = this.enableManualInput;
        this._state[16] = this.style;
        this._state[17] = this.styleClass;
        return this._state;
    }
}

