/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.renderer;

import com.sun.mojarra.scales.component.YuiTree;
import com.sun.mojarra.scales.component.YuiTreeNode;
import com.sun.mojarra.scales.model.ITreeNode;
import com.sun.mojarra.scales.renderer.AbstractRenderer;
import com.sun.mojarra.scales.util.RenderingHelper;
import com.sun.mojarra.scales.util.ScalesUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class YuiTreeRenderer
extends AbstractRenderer {
    protected Map<String, YuiTreeNode> nodeTypes = new HashMap<String, YuiTreeNode>();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("param 'context' is null");
        }
        if (component == null) {
            throw new NullPointerException("param 'component' is null");
        }
        if (!component.isRendered()) {
            return;
        }
        YuiTree tree = (YuiTree)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        ScalesUtil.renderPassThruAttributes(writer, component);
        writer.startElement("ul", null);
        for (Map.Entry facet : tree.getFacets().entrySet()) {
            YuiTreeNode node = (YuiTreeNode)context.getApplication().createComponent("com.sun.mojarra.scales.YuiTreeNode");
            node.getFacets().put("label", facet.getValue());
            this.nodeTypes.put((String)facet.getKey(), node);
        }
        List model = (List)tree.getValue();
        if (model != null) {
            for (int i = 0; i < model.size(); ++i) {
                ITreeNode item = (ITreeNode)model.get(i);
                this.encodeNode(context, writer, item, (UIComponent)tree, i, tree.getVar());
            }
        } else {
            this.processComponentSubTree((UIComponent)tree);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("param 'context' is null");
        }
        if (component == null) {
            throw new NullPointerException("param 'component' is null");
        }
        if (!component.isRendered()) {
            return;
        }
        YuiTree tree = (YuiTree)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("ul");
        writer.endElement("div");
        RenderingHelper.writeOnDomReady(writer, "scales.createTree('" + tree.getClientId(context) + "', " + tree.getShowExpanded() + ");");
    }

    public boolean getRendersChildren() {
        return false;
    }

    protected void encodeNode(FacesContext context, ResponseWriter writer, ITreeNode modelItem, UIComponent parent, int index, String varName) throws IOException {
        YuiTreeNode treeNode = this.nodeTypes.get(modelItem.getType());
        if (treeNode != null) {
            treeNode.setValue(modelItem);
            ValueExpression ve = ScalesUtil.createValueExpression("#{" + varName + "}", String.class);
            Object backup = ve.getValue(context.getELContext());
            ve.setValue(context.getELContext(), (Object)modelItem);
            treeNode.encodeBegin(context);
            ve.setValue(context.getELContext(), backup);
            ve = null;
            List<ITreeNode> children = modelItem.getChildren();
            if (children != null) {
                writer.startElement("ul", (UIComponent)treeNode);
                for (int i = 0; i < children.size(); ++i) {
                    ITreeNode item = children.get(i);
                    this.encodeNode(context, writer, item, (UIComponent)treeNode, index + i + 1, varName);
                }
                writer.endElement("ul");
            }
            treeNode.encodeEnd(context);
        }
    }

    private void processComponentSubTree(UIComponent start) {
        for (UIComponent child : start.getChildren()) {
            if (!(child instanceof YuiTreeNode)) continue;
            YuiTreeNode node = (YuiTreeNode)child;
            if (Boolean.TRUE.equals(node.getExpanded())) {
                this.applyExpandedUpTree(child);
            }
            this.processComponentSubTree((UIComponent)node);
        }
    }

    private void applyExpandedUpTree(UIComponent node) {
        UIComponent parent;
        if (node instanceof YuiTreeNode) {
            ((YuiTreeNode)node).setExpanded(true);
        }
        if (!((parent = node.getParent()) instanceof YuiTree)) {
            this.applyExpandedUpTree(parent);
        }
    }
}

