/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintDescriptor;
import javax.validation.ConstraintValidatorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintValidatorContextImpl
implements ConstraintValidatorContext {
    private final List<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>(3);
    private final String property;
    private final String propertyParent;
    private final ConstraintDescriptor<?> constraintDescriptor;
    private boolean defaultDisabled;

    public ConstraintValidatorContextImpl(String propertyParent, String property, ConstraintDescriptor<?> constraintDescriptor) {
        this.property = property;
        this.propertyParent = propertyParent;
        this.constraintDescriptor = constraintDescriptor;
    }

    @Override
    public void disableDefaultError() {
        this.defaultDisabled = true;
    }

    @Override
    public String getDefaultErrorMessage() {
        return (String)this.constraintDescriptor.getAttributes().get("message");
    }

    @Override
    public void addError(String message) {
        this.errorMessages.add(new ErrorMessage(message, this.buildPropertyPath(this.propertyParent, this.property)));
    }

    @Override
    public void addError(String message, String property) {
        this.errorMessages.add(new ErrorMessage(message, this.buildPropertyPath(this.propertyParent, property)));
    }

    public ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintDescriptor;
    }

    public boolean isDefaultErrorDisabled() {
        return this.defaultDisabled;
    }

    public List<ErrorMessage> getErrorMessages() {
        ArrayList<ErrorMessage> returnedErrorMessages = new ArrayList<ErrorMessage>(this.errorMessages);
        if (!this.defaultDisabled) {
            returnedErrorMessages.add(new ErrorMessage(this.getDefaultErrorMessage(), this.buildPropertyPath(this.propertyParent, this.property)));
        }
        return returnedErrorMessages;
    }

    private String buildPropertyPath(String parent, String leaf) {
        if ("".equals(parent)) {
            return leaf;
        }
        return parent + "." + leaf;
    }

    public class ErrorMessage {
        private final String message;
        private final String property;

        public ErrorMessage(String message, String property) {
            this.message = message;
            this.property = property;
        }

        public String getMessage() {
            return this.message;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

