/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class JavaSECMPInitializer
extends JPAInitializer {
    public static Instrumentation globalInstrumentation;
    protected static JavaSECMPInitializer javaSECMPInitializer;

    public static synchronized JavaSECMPInitializer getJavaSECMPInitializer() {
        if (javaSECMPInitializer == null) {
            javaSECMPInitializer = new JavaSECMPInitializer();
        }
        JavaSECMPInitializer.initializeTopLinkLoggingFile();
        return javaSECMPInitializer;
    }

    public static boolean isSingletonInitialized() {
        return javaSECMPInitializer != null;
    }

    protected JavaSECMPInitializer() {
    }

    public void checkWeaving(Map map) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.weaving", map, null);
        if (globalInstrumentation == null) {
            if (string == null) {
                map.put("eclipselink.weaving", "false");
                string = "false";
            } else if (string.equalsIgnoreCase("true")) {
                throw new PersistenceException((Throwable)EntityManagerSetupException.wrongWeavingPropertyValue());
            }
        }
        if (string != null && (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("static"))) {
            this.shouldCreateInternalLoader = false;
        }
    }

    protected ClassLoader createTempLoader(Collection collection) {
        return this.createTempLoader(collection, true);
    }

    protected ClassLoader createTempLoader(Collection collection, boolean bl) {
        if (!this.shouldCreateInternalLoader) {
            return Thread.currentThread().getContextClassLoader();
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            return classLoader;
        }
        URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
        TempEntityLoader tempEntityLoader = new TempEntityLoader(uRLArray, classLoader, collection, bl);
        AbstractSessionLog.getLog().log(2, "cmp_init_tempLoader_created", (Object)tempEntityLoader);
        AbstractSessionLog.getLog().log(2, "cmp_init_shouldOverrideLoadClassForCollectionMembers", (Object)bl);
        return tempEntityLoader;
    }

    public void initializeClassLoader(PersistenceInitializationHelper persistenceInitializationHelper) {
        this.initializationClassloader = persistenceInitializationHelper.getClassLoader(null, null);
    }

    protected static void initializeFromAgent(Instrumentation instrumentation) throws Exception {
        JavaSECMPInitializer.initializeTopLinkLoggingFile();
        AbstractSessionLog.getLog().log(2, "cmp_init_initialize_from_agent", (Object[])null);
        globalInstrumentation = instrumentation;
        javaSECMPInitializer = new JavaSECMPInitializer();
        javaSECMPInitializer.initialize(new HashMap(), new PersistenceInitializationHelper());
    }

    public static void initializeFromMain(Map map) {
        if (javaSECMPInitializer != null) {
            return;
        }
        JavaSECMPInitializer.getJavaSECMPInitializer().initialize(map, new PersistenceInitializationHelper());
    }

    public static void initializeFromMain() {
        JavaSECMPInitializer.initializeFromMain(new HashMap());
    }

    public void registerTransformer(final ClassTransformer classTransformer, PersistenceUnitInfo persistenceUnitInfo) {
        if (classTransformer != null && globalInstrumentation != null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_register_transformer", (Object)persistenceUnitInfo.getPersistenceUnitName());
            globalInstrumentation.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
                    return classTransformer.transform(classLoader, string, clazz, protectionDomain, byArray);
                }
            });
        } else if (classTransformer == null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_transformer_is_null");
        } else if (globalInstrumentation == null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_globalInstrumentation_is_null");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TempEntityLoader
    extends URLClassLoader {
        Collection classNames;
        boolean shouldOverrideLoadClassForCollectionMembers;

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            return this.getParent().getResources(string);
        }

        public TempEntityLoader(URL[] uRLArray, ClassLoader classLoader, Collection collection, boolean bl) {
            super(uRLArray, classLoader);
            this.classNames = collection;
            this.shouldOverrideLoadClassForCollectionMembers = bl;
        }

        public TempEntityLoader(URL[] uRLArray, ClassLoader classLoader, Collection collection) {
            this(uRLArray, classLoader, collection, true);
        }

        protected boolean shouldOverrideLoadClass(String string) {
            if (this.shouldOverrideLoadClassForCollectionMembers) {
                return this.classNames != null && this.classNames.contains(string);
            }
            return !string.startsWith("java.") && !string.startsWith("javax.") && (this.classNames == null || !this.classNames.contains(string));
        }

        protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (this.shouldOverrideLoadClass(string)) {
                Class<?> clazz = this.findLoadedClass(string);
                if (clazz == null) {
                    clazz = this.findClass(string);
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            return super.loadClass(string, bl);
        }
    }
}

