/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import sun.misc.CompoundEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeClassLoader
extends ClassLoader {
    private List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

    public CompositeClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        this.classLoaders.add(classLoader);
        this.classLoaders.add(classLoader2);
    }

    public CompositeClassLoader(List<ClassLoader> list) {
        this.classLoaders.addAll(list);
    }

    public List<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    @Override
    public synchronized void clearAssertionStatus() {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.clearAssertionStatus();
        }
    }

    @Override
    public URL getResource(String string) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            URL uRL = classLoader.getResource(string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            InputStream inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        Enumeration[] enumerationArray = new Enumeration[this.getClassLoaders().size()];
        for (int i = 0; i < this.getClassLoaders().size(); ++i) {
            enumerationArray[i] = this.getClassLoaders().get(i).getResources(string);
        }
        return new CompoundEnumeration(enumerationArray);
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(string);
    }

    @Override
    public synchronized void setClassAssertionStatus(String string, boolean bl) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setClassAssertionStatus(string, bl);
        }
    }

    @Override
    public synchronized void setDefaultAssertionStatus(boolean bl) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setDefaultAssertionStatus(bl);
        }
    }

    @Override
    public synchronized void setPackageAssertionStatus(String string, boolean bl) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setPackageAssertionStatus(string, bl);
        }
    }
}

