/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

public class ManyToManyAccessor
extends CollectionAccessor {
    public ManyToManyAccessor() {
        super("<many-to-many>");
    }

    public ManyToManyAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        this.setMappedBy((String)MetadataHelper.invokeMethod("mappedBy", annotation));
    }

    protected String getLoggingContext() {
        return "metadata_default_many_to_many_reference_class";
    }

    public boolean isManyToMany() {
        return true;
    }

    public boolean isPrivateOwned() {
        if (super.isPrivateOwned()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_private_owned", this);
        }
        return false;
    }

    public void process() {
        super.process();
        ManyToManyMapping manyToManyMapping = new ManyToManyMapping();
        this.process((CollectionMapping)manyToManyMapping);
        if (this.getMappedBy() == null || this.getMappedBy().equals("")) {
            this.processJoinTable(manyToManyMapping);
        } else {
            manyToManyMapping.setIsReadOnly(true);
            ManyToManyMapping manyToManyMapping2 = null;
            if (!this.getOwningMapping(this.getMappedBy()).isManyToManyMapping()) {
                throw ValidationException.invalidMapping((Class)this.getJavaClass(), (Class)this.getReferenceClass());
            }
            manyToManyMapping2 = (ManyToManyMapping)this.getOwningMapping(this.getMappedBy());
            manyToManyMapping.setRelationTable(manyToManyMapping2.getRelationTable());
            if (this.getDescriptor().usesTablePerClassInheritanceStrategy()) {
                Vector<DatabaseField> vector = new Vector<DatabaseField>();
                for (Object object : manyToManyMapping2.getTargetKeyFields()) {
                    DatabaseField databaseField = (DatabaseField)object.clone();
                    databaseField.setTable(this.getDescriptor().getPrimaryTable());
                    vector.add(databaseField);
                }
                manyToManyMapping.setSourceKeyFields(vector);
                Vector vector2 = new Vector();
                for (DatabaseField databaseField : manyToManyMapping2.getTargetRelationKeyFields()) {
                    DatabaseField databaseField2 = (DatabaseField)databaseField.clone();
                    databaseField2.setTable(this.getDescriptor().getPrimaryTable());
                    vector2.add(databaseField2);
                }
                manyToManyMapping.setSourceRelationKeyFields(vector2);
            } else {
                manyToManyMapping.setSourceKeyFields(manyToManyMapping2.getTargetKeyFields());
                manyToManyMapping.setSourceRelationKeyFields(manyToManyMapping2.getTargetRelationKeyFields());
            }
            manyToManyMapping.setTargetKeyFields(manyToManyMapping2.getSourceKeyFields());
            manyToManyMapping.setTargetRelationKeyFields(manyToManyMapping2.getSourceRelationKeyFields());
        }
    }
}

