/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.InterfaceAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorClassMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableOneToOneAccessor
extends ObjectAccessor {
    public static final String DEFAULT_QUERY_KEY = "id";
    private Integer m_lastDiscriminatorIndex;
    private DiscriminatorColumnMetadata m_discriminatorColumn;
    private List<DiscriminatorClassMetadata> m_discriminatorClasses;

    public VariableOneToOneAccessor() {
        super("<variable-one-to-one>");
    }

    public VariableOneToOneAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        this.m_discriminatorClasses = new ArrayList<DiscriminatorClassMetadata>();
        if (annotation != null) {
            this.setTargetEntity((Class)MetadataHelper.invokeMethod("targetInterface", annotation));
            this.setOrphanRemoval((Boolean)MetadataHelper.invokeMethod("orphanRemoval", annotation));
            this.m_discriminatorColumn = new DiscriminatorColumnMetadata((Annotation)MetadataHelper.invokeMethod("discriminatorColumn", annotation), metadataAccessibleObject);
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("discriminatorClasses", annotation)) {
                this.m_discriminatorClasses.add(new DiscriminatorClassMetadata(annotation2, metadataAccessibleObject));
            }
        }
    }

    public void addDiscriminatorClassFor(EntityAccessor entityAccessor) {
        VariableOneToOneMapping variableOneToOneMapping = (VariableOneToOneMapping)this.getDescriptor().getMappingForAttributeName(this.getAttributeName());
        entityAccessor.getDescriptor().getClassDescriptor().getInterfacePolicy().addParentInterfaceName(variableOneToOneMapping.getReferenceClassName());
        for (DiscriminatorClassMetadata object : this.m_discriminatorClasses) {
            if (!object.getValue().equals(entityAccessor.getJavaClass())) continue;
            return;
        }
        Class clazz = variableOneToOneMapping.getTypeField().getType();
        if (clazz.equals(String.class)) {
            variableOneToOneMapping.addClassNameIndicator(entityAccessor.getJavaClassName(), (Object)entityAccessor.getDescriptor().getAlias());
        } else if (clazz.equals(Character.class)) {
            variableOneToOneMapping.addClassNameIndicator(entityAccessor.getJavaClassName(), (Object)entityAccessor.getJavaClassName().substring(0, 1));
        } else {
            if (this.m_lastDiscriminatorIndex == null) {
                for (String string : (List)variableOneToOneMapping.getTypeIndicatorNameTranslation().values()) {
                    Integer n = new Integer(string);
                    if (this.m_lastDiscriminatorIndex != null && this.m_lastDiscriminatorIndex >= n) continue;
                    this.m_lastDiscriminatorIndex = n;
                }
            }
            this.m_lastDiscriminatorIndex = this.m_lastDiscriminatorIndex + 1;
            variableOneToOneMapping.addClassNameIndicator(entityAccessor.getJavaClassName(), (Object)this.m_lastDiscriminatorIndex);
        }
    }

    public List<DiscriminatorClassMetadata> getDiscriminatorClasses() {
        return this.m_discriminatorClasses;
    }

    public DiscriminatorColumnMetadata getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    @Override
    protected String getLoggingContext() {
        return "metadata_default_variable_one_to_one_reference_class";
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        return this.getDescriptor();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_discriminatorColumn, metadataAccessibleObject);
        this.initXMLObjects(this.m_discriminatorClasses, metadataAccessibleObject);
    }

    @Override
    public boolean isVariableOneToOne() {
        return true;
    }

    @Override
    public void process() {
        InterfaceAccessor interfaceAccessor = this.getProject().getInterfaceAccessor(this.getReferenceClassName());
        if (interfaceAccessor == null) {
            interfaceAccessor = new InterfaceAccessor(null, this.getReferenceClass(), this.getProject());
            interfaceAccessor.process();
            this.getProject().addInterfaceAccessor(interfaceAccessor);
        }
        interfaceAccessor.addVariableOneToOneAccessor(this);
        VariableOneToOneMapping variableOneToOneMapping = new VariableOneToOneMapping();
        this.setMapping((DatabaseMapping)variableOneToOneMapping);
        variableOneToOneMapping.setIsReadOnly(false);
        variableOneToOneMapping.setIsPrivateOwned(this.isPrivateOwned());
        variableOneToOneMapping.setIsOptional(this.isOptional());
        variableOneToOneMapping.setAttributeName(this.getAttributeName());
        variableOneToOneMapping.setReferenceClassName(this.getReferenceClassName());
        this.processIndirection((ObjectReferenceMapping)variableOneToOneMapping);
        this.setAccessorMethods((DatabaseMapping)variableOneToOneMapping);
        this.processCascadeTypes((ForeignReferenceMapping)variableOneToOneMapping);
        this.processReturnInsertAndUpdate();
        if (this.m_discriminatorColumn == null) {
            variableOneToOneMapping.setTypeField(new DiscriminatorColumnMetadata().process(this.getDescriptor(), this.getAnnotatedElementName(), "metadata_default_variable_one_to_one_discriminator_column"));
        } else {
            variableOneToOneMapping.setTypeField(this.m_discriminatorColumn.process(this.getDescriptor(), this.getAnnotatedElementName(), "metadata_default_variable_one_to_one_discriminator_column"));
        }
        for (DiscriminatorClassMetadata discriminatorClassMetadata : this.m_discriminatorClasses) {
            discriminatorClassMetadata.process(variableOneToOneMapping);
        }
        this.processForeignQueryKeyNames(variableOneToOneMapping);
    }

    protected void processForeignQueryKeyNames(VariableOneToOneMapping variableOneToOneMapping) {
        for (JoinColumnMetadata joinColumnMetadata : this.getJoinColumns(this.getJoinColumns(), this.getReferenceDescriptor())) {
            String string = this.getName(joinColumnMetadata.getReferencedColumnName(), DEFAULT_QUERY_KEY, "metadata_default_qk_column");
            DatabaseField databaseField = joinColumnMetadata.getForeignKeyField();
            databaseField.setName(this.getName(databaseField, this.getUpperCaseAttributeName() + "_ID", "metadata_default_fk_column"));
            if (databaseField.getTableName().equals("")) {
                databaseField.setTable(this.getDescriptor().getPrimaryTable());
            }
            variableOneToOneMapping.addForeignQueryKeyName(databaseField, string);
            if (!databaseField.isReadOnly()) continue;
            variableOneToOneMapping.setIsReadOnly(true);
        }
    }

    public void setDiscriminatorClasses(List<DiscriminatorClassMetadata> list) {
        this.m_discriminatorClasses = list;
    }

    public void setDiscriminatorColumn(DiscriminatorColumnMetadata discriminatorColumnMetadata) {
        this.m_discriminatorColumn = discriminatorColumnMetadata;
    }
}

