/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public class TypeConverterMetadata
extends AbstractConverterMetadata {
    private Class m_dataType;
    private Class m_objectType;
    private String m_dataTypeName;
    private String m_objectTypeName;

    public TypeConverterMetadata() {
        super("<type-converter>");
    }

    public TypeConverterMetadata(String string) {
        super(string);
    }

    public TypeConverterMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_dataType = (Class)MetadataHelper.invokeMethod("dataType", annotation);
        this.m_objectType = (Class)MetadataHelper.invokeMethod("objectType", annotation);
    }

    public boolean equals(Object object) {
        if (object instanceof TypeConverterMetadata) {
            TypeConverterMetadata typeConverterMetadata = (TypeConverterMetadata)object;
            if (!this.valuesMatch(this.getName(), typeConverterMetadata.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_dataType, typeConverterMetadata.getDataType())) {
                return false;
            }
            return this.valuesMatch(this.m_objectType, typeConverterMetadata.getObjectType());
        }
        return false;
    }

    public Class getDataType() {
        return this.m_dataType;
    }

    public Class getDataType(MappingAccessor mappingAccessor, Class clazz) {
        if (this.m_dataType == Void.TYPE) {
            if (clazz == null) {
                throw ValidationException.noConverterDataTypeSpecified((Class)mappingAccessor.getJavaClass(), (String)mappingAccessor.getAttributeName(), (String)this.getName());
            }
            mappingAccessor.getLogger().logConfigMessage("metadata_default_converter_data_type", mappingAccessor, this.getName(), clazz);
            return clazz;
        }
        return this.m_dataType;
    }

    public String getDataTypeName() {
        return this.m_dataTypeName;
    }

    public Class getObjectType(MappingAccessor mappingAccessor, Class clazz) {
        if (this.m_objectType == Void.TYPE) {
            if (clazz == null) {
                throw ValidationException.noConverterObjectTypeSpecified((Class)mappingAccessor.getJavaClass(), (String)mappingAccessor.getAttributeName(), (String)this.getName());
            }
            mappingAccessor.getLogger().logConfigMessage("metadata_default_converter_object_type", mappingAccessor, this.getName(), clazz);
            return clazz;
        }
        return this.m_objectType;
    }

    public Class getObjectType() {
        return this.m_objectType;
    }

    public String getObjectTypeName() {
        return this.m_objectTypeName;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.m_dataType = this.initXMLClassName(this.m_dataTypeName);
        this.m_objectType = this.initXMLClassName(this.m_objectTypeName);
    }

    public void process(DatabaseMapping databaseMapping, MappingAccessor mappingAccessor, Class clazz, boolean bl) {
        TypeConversionConverter typeConversionConverter = new TypeConversionConverter(databaseMapping);
        typeConversionConverter.setDataClassName(this.getDataType(mappingAccessor, clazz).getName());
        typeConversionConverter.setObjectClassName(this.getObjectType(mappingAccessor, clazz).getName());
        this.setConverter(databaseMapping, (Converter)typeConversionConverter, bl);
        this.setFieldClassification(databaseMapping, this.m_dataType, bl);
    }

    public void setDataType(Class clazz) {
        this.m_dataType = clazz;
    }

    public void setDataTypeName(String string) {
        this.m_dataTypeName = string;
    }

    public void setObjectType(Class clazz) {
        this.m_objectType = clazz;
    }

    public void setObjectTypeName(String string) {
        this.m_objectTypeName = string;
    }
}

