/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.transformers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

final class MetadataHelper {
    MetadataHelper() {
    }

    public static boolean classImplementsInterface(Class clazz, String string) {
        Class<?>[] classArray;
        if (clazz.getName().contains(string)) {
            return true;
        }
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (!clazz2.getName().contains(string)) continue;
            return true;
        }
        for (Class<?> clazz2 : classArray) {
            if (!MetadataHelper.classImplementsInterface(clazz2, string)) continue;
            return true;
        }
        Class clazz3 = clazz.getSuperclass();
        if (clazz == null) {
            return false;
        }
        return MetadataHelper.classImplementsInterface(clazz3, string);
    }

    static Object invokeMethod(String string, Object object) {
        Method method = null;
        try {
            method = Helper.getDeclaredMethod(object.getClass(), (String)string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)object, (Exception)noSuchMethodException);
        }
        if (method != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, object));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IllegalAccessException) {
                            throw EntityManagerSetupException.cannotAccessMethodOnObject((Method)method, (Object)object);
                        }
                        throw EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)object, (Exception)exception);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod((Method)method, (Object)object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw EntityManagerSetupException.cannotAccessMethodOnObject((Method)method, (Object)object);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)object, (Exception)invocationTargetException);
            }
        }
        return null;
    }
}

