/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm.telemetry;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.monitor.jvm.telemetry.JVMStatsTelemetry;
import org.glassfish.api.monitoring.TelemetryProvider;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service(name="jvm")
@Scoped(value=Singleton.class)
public class JVMTelemetryBootstrap
implements TelemetryProvider,
PostConstruct {
    @Inject
    Logger logger;
    @Inject
    private Domain domain;
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    private boolean jvmMonitoringEnabled = false;
    private JVMStatsTelemetry jvmTM = null;
    private TreeNode serverNode;

    public void postConstruct() {
        Level dbgLevel = Level.FINEST;
        Level defaultLevel = this.logger.getLevel();
        if (defaultLevel == null || dbgLevel.intValue() < defaultLevel.intValue()) {
            // empty if block
        }
        this.logger.finest("[Monitor]In the JVMTelemetry bootstrap ************");
        this.buildTopLevelMonitoringTree();
    }

    public void onLevelChange(String newLevel) {
        boolean newLevelEnabledValue = this.getEnabledValue(newLevel);
        this.logger.finest("[Monitor]In the Level Change = " + newLevel + "  ************");
        if (this.jvmMonitoringEnabled == newLevelEnabledValue) {
            return;
        }
        this.jvmMonitoringEnabled = newLevelEnabledValue;
        if (this.jvmMonitoringEnabled) {
            if (this.jvmTM != null) {
                this.enableJVMMonitoring(true);
            } else {
                this.buildJVMTelemetry();
            }
        } else {
            this.enableJVMMonitoring(false);
        }
    }

    private boolean getEnabledValue(String enabledStr) {
        return !"OFF".equals(enabledStr);
    }

    private void buildTopLevelMonitoringTree() {
        if (this.serverNode != null) {
            return;
        }
        if (this.mrdr.get("server") != null) {
            this.serverNode = this.mrdr.get("server");
            return;
        }
        Server srvr = null;
        List ls = this.domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            srvr = sr;
            break;
        }
        this.serverNode = TreeNodeFactory.createTreeNode("server", null, "server");
        this.mrdr.add("server", this.serverNode);
    }

    private void buildJVMTelemetry() {
        if (this.jvmTM == null) {
            this.jvmTM = new JVMStatsTelemetry(this.serverNode, this.logger);
        }
    }

    private void enableJVMMonitoring(boolean isEnabled) {
        if (!isEnabled) {
            TreeNode jvmNode;
            this.jvmTM = null;
            if (this.serverNode != null && (jvmNode = this.serverNode.getNode("jvm")) != null) {
                this.serverNode.removeChild(this.serverNode.getNode("jvm"));
            }
        } else {
            this.buildJVMTelemetry();
        }
    }
}

