/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.ConfigConfig;
import org.glassfish.admin.amx.intf.config.ThreadPoolConfig;
import org.glassfish.admin.amx.intf.config.ThreadPoolsConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListener;
import org.glassfish.admin.amx.intf.config.grizzly.Protocol;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyHandlers {
    private static List httpServiceSkipPropsList = new ArrayList();

    public static void getNetworkListeners(HandlerContext handlerCtx) {
        ConfigConfig config = V3AMX.getServerConfig((String)((String)handlerCtx.getInputValue("configName")));
        Map nls = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners().getNetworkListener();
        ArrayList result = new ArrayList();
        for (NetworkListener nl : nls.values()) {
            try {
                Map attrs = nl.attributesMap();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("Name", GrizzlyHandlers.getA(attrs, "Name"));
                oneRow.put("Protocol", GrizzlyHandlers.getA(attrs, "Protocol"));
                oneRow.put("selected", false);
                oneRow.put("Port", GrizzlyHandlers.getA(attrs, "Port"));
                oneRow.put("ThreadPool", GrizzlyHandlers.getA(attrs, "ThreadPool"));
                String enabled = GrizzlyHandlers.getA(attrs, "Enabled");
                oneRow.put("enabled", enabled);
                String enableURL = enabled.equals("true") ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
                oneRow.put("enableURL", enableURL);
                result.add(oneRow);
            }
            catch (Exception ex) {
                GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    private static String getA(Map<String, Object> attrs, String key) {
        String res = (String)attrs.get(key);
        if (res == null) {
            res = "";
        }
        return res;
    }

    public static void getprotocols(HandlerContext handlerCtx) {
        ConfigConfig config = V3AMX.getServerConfig((String)((String)handlerCtx.getInputValue("configName")));
        Map pMap = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getProtocols().getProtocol();
        ArrayList result = new ArrayList();
        for (Protocol protocol : pMap.values()) {
            try {
                Map attrs = protocol.attributesMap();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("Name", GrizzlyHandlers.getA(attrs, "Name"));
                oneRow.put("SecurityEnabled", GrizzlyHandlers.getA(attrs, "SecurityEnabled"));
                oneRow.put("selected", false);
                result.add(oneRow);
            }
            catch (Exception ex) {
                GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getThreadPools(HandlerContext handlerCtx) {
        ConfigConfig config = V3AMX.getServerConfig((String)((String)handlerCtx.getInputValue("configName")));
        Map pMap = config.getThreadPools().getThreadPool();
        ArrayList result = new ArrayList();
        for (ThreadPoolConfig tpc : pMap.values()) {
            try {
                Map attrs = tpc.attributesMap();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("Name", GrizzlyHandlers.getA(attrs, "Name"));
                oneRow.put("MinThreadPoolSize", GrizzlyHandlers.getA(attrs, "MinThreadPoolSize"));
                oneRow.put("MaxThreadPoolSize", GrizzlyHandlers.getA(attrs, "MaxThreadPoolSize"));
                oneRow.put("MaxQueueSize", GrizzlyHandlers.getA(attrs, "MaxQueueSize"));
                oneRow.put("IdleThreadTimeoutSeconds", GrizzlyHandlers.getA(attrs, "IdleThreadTimeoutSeconds"));
                oneRow.put("selected", false);
                result.add(oneRow);
            }
            catch (Exception ex) {
                GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void deleteGrizzlyElement(HandlerContext handlerCtx) {
        List obj;
        ConfigConfig config = V3AMX.getServerConfig((String)((String)handlerCtx.getInputValue("configName")));
        String type = (String)handlerCtx.getInputValue("type");
        ThreadPoolsConfig amxP = null;
        if (type.equals("thread-pool")) {
            amxP = config.getThreadPools();
        } else if (type.equals("network-listener")) {
            amxP = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners();
        } else if (type.equals("protocol")) {
            amxP = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getProtocols();
        }
        if (amxP == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)("GUI internal error, Not such Type: " + type));
            return;
        }
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String Name = (String)oneRow.get("Name");
                amxP.removeChild(type, Name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getBeanAttrs(HandlerContext handlerCtx) {
        try {
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            AMXProxy amx = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectNameStr));
            handlerCtx.setOutputValue("valueMap", (Object)amx.attributesMap());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("valueMap", new HashMap());
        }
    }

    public static void getDefaultBeanAttrs(HandlerContext handlerCtx) {
        try {
            String parentName = (String)handlerCtx.getInputValue("parentObjectNameStr");
            String childType = (String)handlerCtx.getInputValue("childType");
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(parentName));
            Map valueMap = amx.getDefaultValues(childType, true);
            handlerCtx.setOutputValue("valueMap", (Object)valueMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("valueMap", new HashMap());
        }
    }

    public static void saveBeanAttributes(HandlerContext handlerCtx) {
        try {
            List convertToFalse;
            Map attrs = (Map)handlerCtx.getInputValue("attrs");
            String objectNameStr = (String)handlerCtx.getInputValue("objectNameStr");
            List skipAttrs = (List)handlerCtx.getInputValue("skipAttrs");
            if (skipAttrs != null) {
                for (String sk : skipAttrs) {
                    if (!attrs.keySet().contains(sk)) continue;
                    attrs.remove(sk);
                }
            }
            if ((convertToFalse = (List)handlerCtx.getInputValue("convertToFalse")) != null) {
                for (String sk : convertToFalse) {
                    if (!attrs.keySet().contains(sk) || attrs.get(sk) != null) continue;
                    attrs.remove(sk);
                    attrs.put(sk, "false");
                }
            }
            V3AMX.setAttributes((Object)objectNameStr, (Map)attrs);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void createProxy(HandlerContext handlerCtx) {
        try {
            String childType = (String)handlerCtx.getInputValue("childType");
            HashMap<String, String> attrs = (HashMap<String, String>)handlerCtx.getInputValue("attrs");
            String parentObjectNameStr = (String)handlerCtx.getInputValue("parentObjectNameStr");
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(parentObjectNameStr));
            List convertToFalse = (List)handlerCtx.getInputValue("convertToFalse");
            if (convertToFalse != null) {
                for (String sk : convertToFalse) {
                    if (!attrs.keySet().contains(sk) || attrs.get(sk) != null) continue;
                    attrs.put(sk, "false");
                }
            }
            List skipAttrs = (List)handlerCtx.getInputValue("skipAttrs");
            V3AMX.removeSpecifiedAttr((Map)attrs, (List)skipAttrs);
            List onlyUseAttrs = (List)handlerCtx.getInputValue("onlyUseAttrs");
            if (onlyUseAttrs != null) {
                HashMap<String, String> newAttrs = new HashMap<String, String>();
                for (String key : onlyUseAttrs) {
                    if (!attrs.keySet().contains(key)) continue;
                    newAttrs.put(key, (String)attrs.get(key));
                }
                attrs = newAttrs;
            }
            System.out.println("========createChild========");
            System.out.println(amx.toString());
            System.out.println("childType = " + childType);
            System.out.println(attrs);
            V3AMX.removeElement(attrs);
            AMXConfigProxy child = amx.createChild(childType, attrs);
            handlerCtx.setOutputValue("result", (Object)child.objectName().toString());
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getChildrenByType(HandlerContext handlerCtx) {
        try {
            String type = (String)handlerCtx.getInputValue("type");
            String parentObjectNameStr = (String)handlerCtx.getInputValue("parentObjectNameStr");
            ArrayList result = new ArrayList();
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(parentObjectNameStr));
            Map childrenMap = amx.childrenMap(type);
            result.addAll(childrenMap.keySet());
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void fixCheckbox(HandlerContext handlerCtx) {
        List keyList = (List)handlerCtx.getInputValue("keys");
        if (keyList == null || keyList.size() < 1) {
            return;
        }
        Map attrs = (Map)handlerCtx.getInputValue("attrs");
        for (String key : keyList) {
            if (attrs.get(key) != null) continue;
            attrs.remove(key);
            attrs.put(key, "false");
        }
    }

    static {
        httpServiceSkipPropsList.add("accessLogBufferSize");
        httpServiceSkipPropsList.add("accessLogWriteInterval");
        httpServiceSkipPropsList.add("accessLoggingEnabled");
    }
}

